/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.fontbox.cff.CFFDataInput;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.cff.CFFOperator;
import org.apache.fontbox.cff.CFFStandardString;
import org.apache.fontbox.cff.DataInput;
import org.apache.fontbox.cff.charset.CFFCharset;
import org.apache.fontbox.cff.charset.CFFExpertCharset;
import org.apache.fontbox.cff.charset.CFFExpertSubsetCharset;
import org.apache.fontbox.cff.charset.CFFISOAdobeCharset;
import org.apache.fontbox.cff.encoding.CFFEncoding;
import org.apache.fontbox.cff.encoding.CFFExpertEncoding;
import org.apache.fontbox.cff.encoding.CFFStandardEncoding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFFParser {
    private CFFDataInput input = null;
    private Header header = null;
    private IndexData nameIndex = null;
    private IndexData topDictIndex = null;
    private IndexData stringIndex = null;
    private IndexData globalSubrIndex = null;

    public List<CFFFont> parse(byte[] bytes) throws IOException {
        this.input = new CFFDataInput(bytes);
        this.header = CFFParser.readHeader(this.input);
        this.nameIndex = CFFParser.readIndexData(this.input);
        this.topDictIndex = CFFParser.readIndexData(this.input);
        this.stringIndex = CFFParser.readIndexData(this.input);
        this.globalSubrIndex = CFFParser.readIndexData(this.input);
        ArrayList<CFFFont> fonts = new ArrayList<CFFFont>();
        for (int i = 0; i < this.nameIndex.count; ++i) {
            CFFFont font = this.parseFont(i);
            fonts.add(font);
        }
        return fonts;
    }

    private static Header readHeader(CFFDataInput input) throws IOException {
        Header header = new Header();
        header.major = input.readCard8();
        header.minor = input.readCard8();
        header.hdrSize = input.readCard8();
        header.offSize = input.readOffSize();
        return header;
    }

    private static IndexData readIndexData(CFFDataInput input) throws IOException {
        int i;
        IndexData index = new IndexData();
        index.count = input.readCard16();
        if (index.count == 0) {
            return index;
        }
        index.offSize = input.readOffSize();
        IndexData.access$802(index, new int[index.count + 1]);
        for (i = 0; i < index.offset.length; ++i) {
            ((IndexData)index).offset[i] = input.readOffset(index.offSize);
        }
        IndexData.access$902(index, new int[index.offset[index.offset.length - 1] - index.offset[0]]);
        for (i = 0; i < index.data.length; ++i) {
            ((IndexData)index).data[i] = input.readCard8();
        }
        return index;
    }

    private static DictData readDictData(CFFDataInput input) throws IOException {
        DictData dict = new DictData();
        dict.entries = new ArrayList();
        while (input.hasRemaining()) {
            DictData.Entry entry = CFFParser.readEntry(input);
            dict.entries.add(entry);
        }
        return dict;
    }

    private static DictData.Entry readEntry(CFFDataInput input) throws IOException {
        int b0;
        DictData.Entry entry;
        block3: {
            entry = new DictData.Entry();
            while (true) {
                if ((b0 = input.readUnsignedByte()) >= 0 && b0 <= 21) break block3;
                if (b0 == 28 || b0 == 29) {
                    entry.operands.add(CFFParser.readIntegerNumber(input, b0));
                    continue;
                }
                if (b0 == 30) {
                    entry.operands.add(CFFParser.readRealNumber(input, b0));
                    continue;
                }
                if (b0 < 32 || b0 > 254) break;
                entry.operands.add(CFFParser.readIntegerNumber(input, b0));
            }
            throw new IllegalArgumentException();
        }
        entry.operator = CFFParser.readOperator(input, b0);
        return entry;
    }

    private static CFFOperator readOperator(CFFDataInput input, int b0) throws IOException {
        CFFOperator.Key key = CFFParser.readOperatorKey(input, b0);
        return CFFOperator.getOperator(key);
    }

    private static CFFOperator.Key readOperatorKey(CFFDataInput input, int b0) throws IOException {
        if (b0 == 12) {
            int b1 = input.readUnsignedByte();
            return new CFFOperator.Key(b0, b1);
        }
        return new CFFOperator.Key(b0);
    }

    private static Integer readIntegerNumber(CFFDataInput input, int b0) throws IOException {
        if (b0 == 28) {
            int b1 = input.readUnsignedByte();
            int b2 = input.readUnsignedByte();
            return (short)(b1 << 8 | b2);
        }
        if (b0 == 29) {
            int b1 = input.readUnsignedByte();
            int b2 = input.readUnsignedByte();
            int b3 = input.readUnsignedByte();
            int b4 = input.readUnsignedByte();
            return b1 << 24 | b2 << 16 | b3 << 8 | b4;
        }
        if (b0 >= 32 && b0 <= 246) {
            return b0 - 139;
        }
        if (b0 >= 247 && b0 <= 250) {
            int b1 = input.readUnsignedByte();
            return (b0 - 247) * 256 + b1 + 108;
        }
        if (b0 >= 251 && b0 <= 254) {
            int b1 = input.readUnsignedByte();
            return -(b0 - 251) * 256 - b1 - 108;
        }
        throw new IllegalArgumentException();
    }

    private static Double readRealNumber(CFFDataInput input, int b0) throws IOException {
        StringBuffer sb = new StringBuffer();
        boolean done = false;
        while (!done) {
            int[] nibbles;
            int b = input.readUnsignedByte();
            block10: for (int nibble : nibbles = new int[]{b / 16, b % 16}) {
                switch (nibble) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        sb.append(nibble);
                        continue block10;
                    }
                    case 10: {
                        sb.append(".");
                        continue block10;
                    }
                    case 11: {
                        sb.append("E");
                        continue block10;
                    }
                    case 12: {
                        sb.append("E-");
                        continue block10;
                    }
                    case 13: {
                        continue block10;
                    }
                    case 14: {
                        sb.append("-");
                        continue block10;
                    }
                    case 15: {
                        done = true;
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
        }
        return Double.valueOf(sb.toString());
    }

    private CFFFont parseFont(int index) throws IOException {
        CFFEncoding encoding;
        int encodingId;
        CFFCharset charset;
        int charsetId;
        CFFFont font = new CFFFont();
        DataInput nameInput = new DataInput(this.nameIndex.getBytes(index));
        String name = nameInput.getString();
        font.setName(name);
        CFFDataInput topDictInput = new CFFDataInput(this.topDictIndex.getBytes(index));
        DictData topDict = CFFParser.readDictData(topDictInput);
        DictData.Entry syntheticBaseEntry = topDict.getEntry("SyntheticBase");
        if (syntheticBaseEntry != null) {
            throw new IOException("Synthetic Fonts are not supported");
        }
        DictData.Entry rosEntry = topDict.getEntry("ROS");
        if (rosEntry != null) {
            throw new IOException("CID-keyed Fonts are not supported");
        }
        font.addValueToTopDict("version", this.getString(topDict, "version"));
        font.addValueToTopDict("Notice", this.getString(topDict, "Notice"));
        font.addValueToTopDict("Copyright", this.getString(topDict, "Copyright"));
        font.addValueToTopDict("FullName", this.getString(topDict, "FullName"));
        font.addValueToTopDict("FamilyName", this.getString(topDict, "FamilyName"));
        font.addValueToTopDict("Weight", this.getString(topDict, "Weight"));
        font.addValueToTopDict("isFixedPitch", this.getBoolean(topDict, "isFixedPitch", false));
        font.addValueToTopDict("ItalicAngle", this.getNumber(topDict, "ItalicAngle", 0));
        font.addValueToTopDict("UnderlinePosition", this.getNumber(topDict, "UnderlinePosition", -100));
        font.addValueToTopDict("UnderlineThickness", this.getNumber(topDict, "UnderlineThickness", 50));
        font.addValueToTopDict("PaintType", this.getNumber(topDict, "PaintType", 0));
        font.addValueToTopDict("CharstringType", this.getNumber(topDict, "CharstringType", 2));
        font.addValueToTopDict("FontMatrix", this.getArray(topDict, "FontMatrix", Arrays.asList(0.001, 0.0, 0.0, 0.001, 0.0, 0.0)));
        font.addValueToTopDict("UniqueID", this.getNumber(topDict, "UniqueID", null));
        font.addValueToTopDict("FontBBox", this.getArray(topDict, "FontBBox", Arrays.asList(0, 0, 0, 0)));
        font.addValueToTopDict("StrokeWidth", this.getNumber(topDict, "StrokeWidth", 0));
        font.addValueToTopDict("XUID", this.getArray(topDict, "XUID", null));
        DictData.Entry charStringsEntry = topDict.getEntry("CharStrings");
        int charStringsOffset = charStringsEntry.getNumber(0).intValue();
        this.input.setPosition(charStringsOffset);
        IndexData charStringsIndex = CFFParser.readIndexData(this.input);
        DictData.Entry charsetEntry = topDict.getEntry("charset");
        int n = charsetId = charsetEntry != null ? charsetEntry.getNumber(0).intValue() : 0;
        if (charsetId == 0) {
            charset = CFFISOAdobeCharset.getInstance();
        } else if (charsetId == 1) {
            charset = CFFExpertCharset.getInstance();
        } else if (charsetId == 2) {
            charset = CFFExpertSubsetCharset.getInstance();
        } else {
            this.input.setPosition(charsetId);
            charset = this.readCharset(this.input, charStringsIndex.count);
        }
        font.setCharset(charset);
        font.getCharStringsDict().put(".notdef", charStringsIndex.getBytes(0));
        int[] gids = new int[charStringsIndex.count];
        List<CFFCharset.Entry> glyphEntries = charset.getEntries();
        for (int i = 0; i < glyphEntries.size(); ++i) {
            CFFCharset.Entry glyphEntry = glyphEntries.get(i);
            gids[i] = glyphEntry.getSID();
            font.getCharStringsDict().put(glyphEntry.getName(), charStringsIndex.getBytes(i + 1));
        }
        DictData.Entry encodingEntry = topDict.getEntry("Encoding");
        int n2 = encodingId = encodingEntry != null ? encodingEntry.getNumber(0).intValue() : 0;
        if (encodingId == 0) {
            encoding = CFFStandardEncoding.getInstance();
        } else if (encodingId == 1) {
            encoding = CFFExpertEncoding.getInstance();
        } else {
            this.input.setPosition(encodingId);
            encoding = this.readEncoding(this.input, gids);
        }
        font.setEncoding(encoding);
        DictData.Entry privateEntry = topDict.getEntry("Private");
        int privateOffset = privateEntry.getNumber(1).intValue();
        this.input.setPosition(privateOffset);
        int privateSize = privateEntry.getNumber(0).intValue();
        CFFDataInput privateDictData = new CFFDataInput(this.input.readBytes(privateSize));
        DictData privateDict = CFFParser.readDictData(privateDictData);
        font.addValueToPrivateDict("BlueValues", this.getDelta(privateDict, "BlueValues", null));
        font.addValueToPrivateDict("OtherBlues", this.getDelta(privateDict, "OtherBlues", null));
        font.addValueToPrivateDict("FamilyBlues", this.getDelta(privateDict, "FamilyBlues", null));
        font.addValueToPrivateDict("FamilyOtherBlues", this.getDelta(privateDict, "FamilyOtherBlues", null));
        font.addValueToPrivateDict("BlueScale", this.getNumber(privateDict, "BlueScale", 0.039625));
        font.addValueToPrivateDict("BlueShift", this.getNumber(privateDict, "BlueShift", 7));
        font.addValueToPrivateDict("BlueFuzz", this.getNumber(privateDict, "BlueFuzz", 1));
        font.addValueToPrivateDict("StdHW", this.getNumber(privateDict, "StdHW", null));
        font.addValueToPrivateDict("StdVW", this.getNumber(privateDict, "StdVW", null));
        font.addValueToPrivateDict("StemSnapH", this.getDelta(privateDict, "StemSnapH", null));
        font.addValueToPrivateDict("StemSnapV", this.getDelta(privateDict, "StemSnapV", null));
        font.addValueToPrivateDict("ForceBold", this.getBoolean(privateDict, "ForceBold", false));
        font.addValueToPrivateDict("LanguageGroup", this.getNumber(privateDict, "LanguageGroup", 0));
        font.addValueToPrivateDict("ExpansionFactor", this.getNumber(privateDict, "ExpansionFactor", 0.06));
        font.addValueToPrivateDict("initialRandomSeed", this.getNumber(privateDict, "initialRandomSeed", 0));
        font.addValueToPrivateDict("defaultWidthX", this.getNumber(privateDict, "defaultWidthX", 0));
        font.addValueToPrivateDict("nominalWidthX", this.getNumber(privateDict, "nominalWidthX", 0));
        return font;
    }

    private String readString(int index) throws IOException {
        if (index >= 0 && index <= 390) {
            return CFFStandardString.getName(index);
        }
        DataInput dataInput = new DataInput(this.stringIndex.getBytes(index - 391));
        return dataInput.getString();
    }

    private String getString(DictData dict, String name) throws IOException {
        DictData.Entry entry = dict.getEntry(name);
        return entry != null ? this.readString(entry.getNumber(0).intValue()) : null;
    }

    private Boolean getBoolean(DictData dict, String name, boolean defaultValue) throws IOException {
        DictData.Entry entry = dict.getEntry(name);
        return entry != null ? entry.getBoolean(0) : defaultValue;
    }

    private Number getNumber(DictData dict, String name, Number defaultValue) throws IOException {
        DictData.Entry entry = dict.getEntry(name);
        return entry != null ? (Number)entry.getNumber(0) : (Number)defaultValue;
    }

    private List<Number> getArray(DictData dict, String name, List<Number> defaultValue) throws IOException {
        DictData.Entry entry = dict.getEntry(name);
        return entry != null ? entry.getArray() : defaultValue;
    }

    private List<Number> getDelta(DictData dict, String name, List<Number> defaultValue) throws IOException {
        DictData.Entry entry = dict.getEntry(name);
        return entry != null ? entry.getArray() : defaultValue;
    }

    private CFFEncoding readEncoding(CFFDataInput dataInput, int[] gids) throws IOException {
        int format = dataInput.readCard8();
        int baseFormat = format & 0x7F;
        if (baseFormat == 0) {
            return this.readFormat0Encoding(dataInput, format, gids);
        }
        if (baseFormat == 1) {
            return this.readFormat1Encoding(dataInput, format, gids);
        }
        throw new IllegalArgumentException();
    }

    private Format0Encoding readFormat0Encoding(CFFDataInput dataInput, int format, int[] gids) throws IOException {
        Format0Encoding encoding = new Format0Encoding();
        encoding.format = format;
        encoding.nCodes = dataInput.readCard8();
        Format0Encoding.access$1802(encoding, new int[encoding.nCodes]);
        for (int i = 0; i < encoding.code.length; ++i) {
            ((Format0Encoding)encoding).code[i] = dataInput.readCard8();
            encoding.register(encoding.code[i], gids[i]);
        }
        if ((format & 0x80) != 0) {
            this.readSupplement(dataInput, encoding);
        }
        return encoding;
    }

    private Format1Encoding readFormat1Encoding(CFFDataInput dataInput, int format, int[] gids) throws IOException {
        Format1Encoding encoding = new Format1Encoding();
        encoding.format = format;
        encoding.nRanges = dataInput.readCard8();
        int count = 0;
        Format1Encoding.access$2202(encoding, new Format1Encoding.Range1[encoding.nRanges]);
        for (int i = 0; i < encoding.range.length; ++i) {
            Format1Encoding.Range1 range = new Format1Encoding.Range1();
            range.first = dataInput.readCard8();
            range.nLeft = dataInput.readCard8();
            ((Format1Encoding)encoding).range[i] = range;
            for (int j = 0; j < 1 + range.nLeft; ++j) {
                encoding.register(range.first + j, gids[count + j]);
            }
            count += 1 + range.nLeft;
        }
        if ((format & 0x80) != 0) {
            this.readSupplement(dataInput, encoding);
        }
        return encoding;
    }

    private void readSupplement(CFFDataInput dataInput, EmbeddedEncoding encoding) throws IOException {
        encoding.nSups = dataInput.readCard8();
        EmbeddedEncoding.access$2702(encoding, new EmbeddedEncoding.Supplement[encoding.nSups]);
        for (int i = 0; i < encoding.supplement.length; ++i) {
            EmbeddedEncoding.Supplement supplement = new EmbeddedEncoding.Supplement();
            supplement.code = dataInput.readCard8();
            supplement.glyph = dataInput.readSID();
            ((EmbeddedEncoding)encoding).supplement[i] = supplement;
        }
    }

    private CFFCharset readCharset(CFFDataInput dataInput, int nGlyphs) throws IOException {
        int format = dataInput.readCard8();
        if (format == 0) {
            return this.readFormat0Charset(dataInput, format, nGlyphs);
        }
        if (format == 1) {
            return this.readFormat1Charset(dataInput, format, nGlyphs);
        }
        throw new IllegalArgumentException();
    }

    private Format0Charset readFormat0Charset(CFFDataInput dataInput, int format, int nGlyphs) throws IOException {
        Format0Charset charset = new Format0Charset();
        charset.format = format;
        Format0Charset.access$3302(charset, new int[nGlyphs - 1]);
        for (int i = 0; i < charset.glyph.length; ++i) {
            ((Format0Charset)charset).glyph[i] = dataInput.readSID();
            charset.register(charset.glyph[i], this.readString(charset.glyph[i]));
        }
        return charset;
    }

    private Format1Charset readFormat1Charset(CFFDataInput dataInput, int format, int nGlyphs) throws IOException {
        Format1Charset.Range1 range;
        Format1Charset charset = new Format1Charset();
        charset.format = format;
        Format1Charset.access$3602(charset, new Format1Charset.Range1[0]);
        for (int i = 0; i < nGlyphs - 1; i += 1 + range.nLeft) {
            Format1Charset.Range1[] newRange = new Format1Charset.Range1[charset.range.length + 1];
            System.arraycopy(charset.range, 0, newRange, 0, charset.range.length);
            Format1Charset.access$3602(charset, newRange);
            range = new Format1Charset.Range1();
            range.first = dataInput.readSID();
            range.nLeft = dataInput.readCard8();
            ((Format1Charset)charset).range[((Format1Charset)charset).range.length - 1] = range;
            for (int j = 0; j < 1 + range.nLeft; ++j) {
                charset.register(range.first + j, this.readString(range.first + j));
            }
        }
        return charset;
    }

    private static class Format1Charset
    extends EmbeddedCharset {
        private int format;
        private Range1[] range;

        private Format1Charset() {
        }

        public String toString() {
            return this.getClass().getName() + "[format=" + this.format + ", range=" + Arrays.toString(this.range) + "]";
        }

        static /* synthetic */ Range1[] access$3602(Format1Charset x0, Range1[] x1) {
            x0.range = x1;
            return x1;
        }

        private static class Range1 {
            private int first;
            private int nLeft;

            private Range1() {
            }

            public String toString() {
                return this.getClass().getName() + "[first=" + this.first + ", nLeft=" + this.nLeft + "]";
            }
        }
    }

    private static class Format0Charset
    extends EmbeddedCharset {
        private int format;
        private int[] glyph;

        private Format0Charset() {
        }

        public String toString() {
            return this.getClass().getName() + "[format=" + this.format + ", glyph=" + Arrays.toString(this.glyph) + "]";
        }

        static /* synthetic */ int[] access$3302(Format0Charset x0, int[] x1) {
            x0.glyph = x1;
            return x1;
        }
    }

    private static abstract class EmbeddedCharset
    extends CFFCharset {
        private EmbeddedCharset() {
        }

        public boolean isFontSpecific() {
            return true;
        }
    }

    private static class Format1Encoding
    extends EmbeddedEncoding {
        private int format;
        private int nRanges;
        private Range1[] range;

        private Format1Encoding() {
        }

        public String toString() {
            return this.getClass().getName() + "[format=" + this.format + ", nRanges=" + this.nRanges + ", range=" + Arrays.toString(this.range) + ", supplement=" + Arrays.toString(((EmbeddedEncoding)this).supplement) + "]";
        }

        static /* synthetic */ Range1[] access$2202(Format1Encoding x0, Range1[] x1) {
            x0.range = x1;
            return x1;
        }

        private static class Range1 {
            private int first;
            private int nLeft;

            private Range1() {
            }

            public String toString() {
                return this.getClass().getName() + "[first=" + this.first + ", nLeft=" + this.nLeft + "]";
            }
        }
    }

    private static class Format0Encoding
    extends EmbeddedEncoding {
        private int format;
        private int nCodes;
        private int[] code;

        private Format0Encoding() {
        }

        public String toString() {
            return this.getClass().getName() + "[format=" + this.format + ", nCodes=" + this.nCodes + ", code=" + Arrays.toString(this.code) + ", supplement=" + Arrays.toString(((EmbeddedEncoding)this).supplement) + "]";
        }

        static /* synthetic */ int[] access$1802(Format0Encoding x0, int[] x1) {
            x0.code = x1;
            return x1;
        }
    }

    private static abstract class EmbeddedEncoding
    extends CFFEncoding {
        private int nSups;
        private Supplement[] supplement;

        private EmbeddedEncoding() {
        }

        public boolean isFontSpecific() {
            return true;
        }

        static /* synthetic */ Supplement[] access$2702(EmbeddedEncoding x0, Supplement[] x1) {
            x0.supplement = x1;
            return x1;
        }

        private static class Supplement {
            private int code;
            private int glyph;

            private Supplement() {
            }

            public String toString() {
                return this.getClass().getName() + "[code=" + this.code + ", glyph=" + this.glyph + "]";
            }
        }
    }

    private static class DictData {
        private List<Entry> entries = null;

        private DictData() {
        }

        public Entry getEntry(CFFOperator.Key key) {
            return this.getEntry(CFFOperator.getOperator(key));
        }

        public Entry getEntry(String name) {
            return this.getEntry(CFFOperator.getOperator(name));
        }

        private Entry getEntry(CFFOperator operator) {
            for (Entry entry : this.entries) {
                if (!entry.operator.equals(operator)) continue;
                return entry;
            }
            return null;
        }

        public String toString() {
            return this.getClass().getName() + "[entries=" + this.entries + "]";
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Entry {
            private List<Number> operands = new ArrayList<Number>();
            private CFFOperator operator = null;

            private Entry() {
            }

            public Number getNumber(int index) {
                return this.operands.get(index);
            }

            public Boolean getBoolean(int index) {
                Number operand = this.operands.get(index);
                if (operand instanceof Integer) {
                    switch (operand.intValue()) {
                        case 0: {
                            return Boolean.FALSE;
                        }
                        case 1: {
                            return Boolean.TRUE;
                        }
                    }
                }
                throw new IllegalArgumentException();
            }

            public Integer getSID(int index) {
                Number operand = this.operands.get(index);
                if (operand instanceof Integer) {
                    return (Integer)operand;
                }
                throw new IllegalArgumentException();
            }

            public List<Number> getArray() {
                return this.operands;
            }

            public List<Number> getDelta() {
                return this.operands;
            }

            public String toString() {
                return this.getClass().getName() + "[operands=" + this.operands + ", operator=" + this.operator + "]";
            }
        }
    }

    private static class IndexData {
        private int count;
        private int offSize;
        private int[] offset;
        private int[] data;

        private IndexData() {
        }

        public byte[] getBytes(int index) {
            int length = this.offset[index + 1] - this.offset[index];
            byte[] bytes = new byte[length];
            for (int i = 0; i < length; ++i) {
                bytes[i] = (byte)this.data[this.offset[index] - 1 + i];
            }
            return bytes;
        }

        public String toString() {
            return this.getClass().getName() + "[count=" + this.count + ", offSize=" + this.offSize + ", offset=" + Arrays.toString(this.offset) + ", data=" + Arrays.toString(this.data) + "]";
        }

        static /* synthetic */ int[] access$802(IndexData x0, int[] x1) {
            x0.offset = x1;
            return x1;
        }

        static /* synthetic */ int[] access$902(IndexData x0, int[] x1) {
            x0.data = x1;
            return x1;
        }
    }

    private static class Header {
        private int major;
        private int minor;
        private int hdrSize;
        private int offSize;

        private Header() {
        }

        public String toString() {
            return this.getClass().getName() + "[major=" + this.major + ", minor=" + this.minor + ", hdrSize=" + this.hdrSize + ", offSize=" + this.offSize + "]";
        }
    }
}

