/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.core.ItemData;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.NodeTypeConflictException;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.SessionItemStateManager;
import org.apache.jackrabbit.core.state.StaleItemStateException;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.version.InternalVersionManager;
import org.apache.jackrabbit.core.version.VersionHistoryInfo;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.nodetype.PropertyDefinitionImpl;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ItemImpl
implements Item {
    private static Logger log = LoggerFactory.getLogger(ItemImpl.class);
    protected static final int STATUS_NORMAL = 0;
    protected static final int STATUS_MODIFIED = 1;
    protected static final int STATUS_DESTROYED = 2;
    protected static final int STATUS_INVALIDATED = 3;
    protected final ItemId id;
    protected final SessionImpl session;
    protected final RepositoryImpl rep;
    protected final ItemData data;
    protected final ItemManager itemMgr;
    protected final SessionItemStateManager stateMgr;

    ItemImpl(ItemManager itemMgr, SessionImpl session, ItemData data) {
        this.session = session;
        this.rep = (RepositoryImpl)session.getRepository();
        this.stateMgr = session.getItemStateManager();
        this.id = data.getId();
        this.itemMgr = itemMgr;
        this.data = data;
    }

    protected void sanityCheck() throws RepositoryException {
        this.session.sanityCheck();
        int status = this.data.getStatus();
        if (status == 2 || status == 3) {
            throw new InvalidItemStateException(this.id + ": the item does not exist anymore");
        }
    }

    protected boolean isTransient() {
        return this.getItemState().isTransient();
    }

    protected abstract ItemState getOrCreateTransientItemState() throws RepositoryException;

    protected abstract void makePersistent() throws InvalidItemStateException;

    protected void setRemoved() throws RepositoryException {
        int status = this.data.getStatus();
        if (status == 3 || status == 2) {
            return;
        }
        ItemState transientState = this.getOrCreateTransientItemState();
        if (transientState.getStatus() == 4) {
            this.stateMgr.disposeTransientItemState(transientState);
        } else {
            transientState.setStatus(3);
            this.stateMgr.moveTransientItemStateToAttic(transientState);
            this.data.setStatus(3);
            this.itemMgr.itemInvalidated(this.id, this.data);
        }
    }

    ItemState getItemState() {
        return this.data.getState();
    }

    public ItemId getId() {
        return this.id;
    }

    public Path getPrimaryPath() throws RepositoryException {
        return this.session.getHierarchyManager().getPath(this.id);
    }

    private Collection<ItemState> getTransientStates() throws InvalidItemStateException, RepositoryException {
        ArrayList<ItemState> dirty = new ArrayList<ItemState>();
        if (this.isNode()) {
            Iterator<ItemState> iter = this.stateMgr.getDescendantTransientItemStates((NodeId)this.id);
            block13: while (iter.hasNext()) {
                ItemState transientState = iter.next();
                switch (transientState.getStatus()) {
                    case 2: 
                    case 4: {
                        dirty.add(transientState);
                        continue block13;
                    }
                    case 5: {
                        throw new InvalidItemStateException("Item cannot be saved because it has been modified externally: " + this);
                    }
                    case 6: {
                        throw new InvalidItemStateException("Item cannot be saved because it has been deleted externally: " + this);
                    }
                    case 0: {
                        throw new InvalidItemStateException("Item cannot be saved; it seems to have been removed externally: " + this);
                    }
                }
                log.warn("Unexpected item state status: " + transientState.getStatus() + " of " + this);
            }
        }
        if (this.isTransient()) {
            ItemState state = this.getItemState();
            switch (state.getStatus()) {
                case 2: {
                    dirty.add(state);
                    break;
                }
                case 4: {
                    throw new RepositoryException("Cannot save a new item: " + this);
                }
                case 5: {
                    throw new InvalidItemStateException("Item cannot be saved because it has been modified externally: " + this);
                }
                case 6: {
                    throw new InvalidItemStateException("Item cannot be saved because it has been deleted externally:" + this);
                }
                case 0: {
                    throw new InvalidItemStateException("Item cannot be saved; it seems to have been removed externally: " + this);
                }
                default: {
                    log.warn("Unexpected item state status:" + state.getStatus() + " of " + this);
                }
            }
        }
        return dirty;
    }

    private Collection<ItemState> getRemovedStates() throws InvalidItemStateException, RepositoryException {
        ArrayList<ItemState> removed = new ArrayList<ItemState>();
        if (this.isNode()) {
            Iterator<ItemState> iter = this.stateMgr.getDescendantTransientItemStatesInAttic((NodeId)this.id);
            while (iter.hasNext()) {
                ItemState transientState = iter.next();
                if (transientState.getStatus() == 5) {
                    String msg = transientState.getId() + ": the item cannot be removed because it has been modified externally.";
                    log.debug(msg);
                    throw new InvalidItemStateException(msg);
                }
                if (transientState.getStatus() == 6) {
                    String msg = transientState.getId() + ": the item cannot be removed because it has already been deleted externally.";
                    log.debug(msg);
                    throw new InvalidItemStateException(msg);
                }
                removed.add(transientState);
            }
        }
        return removed;
    }

    private void validateTransientItems(Iterable<ItemState> dirty, Iterable<ItemState> removed) throws AccessDeniedException, ConstraintViolationException, RepositoryException {
        String msg;
        Path path;
        Object def;
        AccessManager accessMgr = this.session.getAccessManager();
        NodeTypeManagerImpl ntMgr = this.session.getNodeTypeManager();
        for (ItemState itemState : dirty) {
            String[] constraints;
            def = itemState.isNode() ? this.itemMgr.getDefinition((NodeState)itemState) : this.itemMgr.getDefinition((PropertyState)itemState);
            if (!def.isProtected()) {
                path = this.stateMgr.getHierarchyMgr().getPath(itemState.getId());
                boolean isGranted = true;
                if (itemState.isNode()) {
                    if (itemState.getStatus() == 4) {
                        isGranted = accessMgr.isGranted(path, 4);
                    }
                } else {
                    isGranted = accessMgr.isGranted(path, 2);
                }
                if (!isGranted) {
                    msg = this.itemMgr.safeGetJCRPath(path) + ": not allowed to add or modify item";
                    log.debug(msg);
                    throw new AccessDeniedException(msg);
                }
            }
            if (itemState.isNode()) {
                String msg2;
                NodeState nodeState = (NodeState)itemState;
                NodeId id = nodeState.getNodeId();
                NodeDefinition nodeDef = (NodeDefinition)def;
                NodeTypeImpl pnt = ntMgr.getNodeType(nodeState.getNodeTypeName());
                EffectiveNodeType ent = this.getEffectiveNodeType(nodeState);
                if (nodeState.getStatus() == 4 || !nodeState.getNodeTypeName().equals(((NodeState)nodeState.getOverlayedState()).getNodeTypeName())) {
                    for (NodeType ntReq : nodeDef.getRequiredPrimaryTypes()) {
                        Name ntName = ((NodeTypeImpl)ntReq).getQName();
                        if (pnt.getQName().equals(ntName) || pnt.isDerivedFrom(ntName)) continue;
                        String msg3 = this.itemMgr.safeGetJCRPath(id) + " must be of node type " + ntReq.getName();
                        log.debug(msg3);
                        throw new ConstraintViolationException(msg3);
                    }
                }
                for (QPropertyDefinition pd : ent.getMandatoryPropDefs()) {
                    if (pd.getDeclaringNodeType().equals(NameConstants.MIX_VERSIONABLE) || pd.getDeclaringNodeType().equals(NameConstants.MIX_SIMPLE_VERSIONABLE)) continue;
                    msg2 = this.itemMgr.safeGetJCRPath(id) + ": mandatory property " + pd.getName() + " does not exist";
                    if (!nodeState.hasPropertyName(pd.getName())) {
                        log.debug(msg2);
                        throw new ConstraintViolationException(msg2);
                    }
                    PropertyId pi = new PropertyId(nodeState.getNodeId(), pd.getName());
                    ItemData childData = this.itemMgr.getItemData(pi, null, false);
                    if (childData.getDefinition().isMandatory()) continue;
                    throw new ConstraintViolationException(msg2);
                }
                for (QNodeDefinition cnd : ent.getMandatoryNodeDefs()) {
                    msg2 = this.itemMgr.safeGetJCRPath(id) + ": mandatory child node " + cnd.getName() + " does not exist";
                    if (!nodeState.hasChildNodeEntry(cnd.getName())) {
                        log.debug(msg2);
                        throw new ConstraintViolationException(msg2);
                    }
                    boolean hasMandatoryChild = false;
                    for (ChildNodeEntry cne : nodeState.getChildNodeEntries(cnd.getName())) {
                        ItemData childData = this.itemMgr.getItemData(cne.getId(), null, false);
                        if (!childData.getDefinition().isMandatory()) continue;
                        hasMandatoryChild = true;
                        break;
                    }
                    if (hasMandatoryChild) continue;
                    throw new ConstraintViolationException(msg2);
                }
                continue;
            }
            PropertyState propState = (PropertyState)itemState;
            PropertyId propId = propState.getPropertyId();
            PropertyDefinitionImpl propDef = (PropertyDefinitionImpl)def;
            if (def.isProtected() || (constraints = propDef.getValueConstraints()) == null) continue;
            InternalValue[] values = propState.getValues();
            try {
                EffectiveNodeType.checkSetPropertyValueConstraints(propDef.unwrap(), values);
            }
            catch (RepositoryException e) {
                String msg4 = this.itemMgr.safeGetJCRPath(propId) + ": " + e.getMessage();
                log.debug(msg4);
                throw new ConstraintViolationException(msg4);
            }
            if (constraints.length <= 0 || propDef.getRequiredType() != 9 && propDef.getRequiredType() != 10) continue;
            for (InternalValue internalV : values) {
                boolean satisfied = false;
                String constraintViolationMsg = null;
                try {
                    NodeId targetId = internalV.getNodeId();
                    if (propDef.getRequiredType() == 10 && !this.itemMgr.itemExists(targetId)) continue;
                    NodeImpl targetNode = this.session.getNodeById(targetId);
                    for (String constrNtName : constraints) {
                        if (!targetNode.isNodeType(constrNtName)) continue;
                        satisfied = true;
                        break;
                    }
                    if (!satisfied) {
                        NodeType[] mixinNodeTypes = targetNode.getMixinNodeTypes();
                        String[] targetMixins = new String[mixinNodeTypes.length];
                        for (int j = 0; j < mixinNodeTypes.length; ++j) {
                            targetMixins[j] = mixinNodeTypes[j].getName();
                        }
                        String targetMixinsString = Text.implode(targetMixins, ", ");
                        String constraintsString = Text.implode(constraints, ", ");
                        constraintViolationMsg = this.itemMgr.safeGetJCRPath(propId) + ": is constraint to [" + constraintsString + "] but references [primaryType=" + targetNode.getPrimaryNodeType().getName() + ", mixins=" + targetMixinsString + "]";
                    }
                }
                catch (RepositoryException re) {
                    String msg5 = this.itemMgr.safeGetJCRPath(propId) + ": failed to check " + (propDef.getRequiredType() == 9 ? "REFERENCE" : "WEAKREFERENCE") + " value constraint";
                    log.debug(msg5);
                    throw new ConstraintViolationException(msg5, re);
                }
                if (satisfied) continue;
                log.debug(constraintViolationMsg);
                throw new ConstraintViolationException(constraintViolationMsg);
            }
        }
        for (ItemState itemState : removed) {
            int permission;
            try {
                def = itemState.isNode() ? this.itemMgr.getDefinition((NodeState)itemState).unwrap() : this.itemMgr.getDefinition((PropertyState)itemState).unwrap();
            }
            catch (ConstraintViolationException e) {
                continue;
            }
            if (def.isProtected() || accessMgr.isGranted(path = this.stateMgr.getAtticAwareHierarchyMgr().getPath(itemState.getId()), permission = itemState.isNode() ? 8 : 16)) continue;
            msg = this.itemMgr.safeGetJCRPath(path) + ": not allowed to remove item";
            log.debug(msg);
            throw new AccessDeniedException(msg);
        }
    }

    private void removeTransientItems(Iterable<ItemState> states) {
        for (ItemState transientState : states) {
            ItemState persistentState = transientState.getOverlayedState();
            this.stateMgr.destroy(persistentState);
        }
    }

    private void persistTransientItems(Iterable<ItemState> states) throws RepositoryException {
        for (ItemState state : states) {
            this.itemMgr.getItem(state.getId()).makePersistent();
        }
    }

    private void restoreTransientItems(Iterable<ItemState> items) {
        for (ItemState itemState : items) {
            ItemId id = itemState.getId();
            try {
                ItemImpl item;
                if (this.stateMgr.isItemStateInAttic(id)) {
                    item = this.itemMgr.createItemInstance(itemState);
                    itemState.setStatus(4);
                } else {
                    try {
                        item = this.itemMgr.getItem(id);
                    }
                    catch (ItemNotFoundException infe) {
                        item = this.itemMgr.createItemInstance(itemState);
                        itemState.setStatus(4);
                    }
                }
                if (item.isTransient()) continue;
                if (item.isNode()) {
                    NodeImpl node = (NodeImpl)item;
                    node.restoreTransient((NodeState)itemState);
                    continue;
                }
                PropertyImpl prop = (PropertyImpl)item;
                prop.restoreTransient((PropertyState)itemState);
            }
            catch (RepositoryException re) {
                String msg = this.itemMgr.safeGetJCRPath(id) + ": failed to restore transient state";
                log.warn(msg, re);
            }
        }
    }

    private void processShareableNodes(Iterable<ItemState> states) throws RepositoryException {
        for (ItemState is : states) {
            if (!is.isNode()) continue;
            NodeState ns = (NodeState)is;
            boolean wasShareable = false;
            if (ns.hasOverlayedState()) {
                NodeState old = (NodeState)ns.getOverlayedState();
                EffectiveNodeType ntOld = this.getEffectiveNodeType(old);
                wasShareable = ntOld.includesNodeType(NameConstants.MIX_SHAREABLE);
            }
            EffectiveNodeType ntNew = this.getEffectiveNodeType(ns);
            boolean isShareable = ntNew.includesNodeType(NameConstants.MIX_SHAREABLE);
            if (!wasShareable && isShareable) {
                ns.addShare(ns.getParentId());
                continue;
            }
            if (!wasShareable || isShareable) continue;
            String msg = "Removing mix:shareable is not supported.";
            log.debug(msg);
            throw new UnsupportedRepositoryOperationException(msg);
        }
    }

    private boolean initVersionHistories(Iterable<ItemState> states) throws RepositoryException {
        boolean createdTransientState = false;
        for (ItemState itemState : states) {
            if (!itemState.isNode()) continue;
            NodeState nodeState = (NodeState)itemState;
            EffectiveNodeType nt = this.getEffectiveNodeType(nodeState);
            if (nt.includesNodeType(NameConstants.MIX_VERSIONABLE)) {
                if (nodeState.hasPropertyName(NameConstants.JCR_VERSIONHISTORY)) continue;
                NodeImpl node = (NodeImpl)this.itemMgr.getItem(itemState.getId());
                InternalVersionManager vMgr = this.session.getInternalVersionManager();
                VersionHistoryInfo history = vMgr.getVersionHistory(this.session, nodeState, null);
                InternalValue historyId = InternalValue.create(history.getVersionHistoryId());
                InternalValue versionId = InternalValue.create(history.getRootVersionId());
                node.internalSetProperty(NameConstants.JCR_VERSIONHISTORY, historyId);
                node.internalSetProperty(NameConstants.JCR_BASEVERSION, versionId);
                node.internalSetProperty(NameConstants.JCR_ISCHECKEDOUT, InternalValue.create(true));
                node.internalSetProperty(NameConstants.JCR_PREDECESSORS, new InternalValue[]{versionId});
                createdTransientState = true;
                continue;
            }
            if (!nt.includesNodeType(NameConstants.MIX_SIMPLE_VERSIONABLE)) continue;
            InternalVersionManager vMgr = this.session.getInternalVersionManager();
            vMgr.getVersionHistory(this.session, nodeState, null);
            NodeImpl node = (NodeImpl)this.itemMgr.getItem(itemState.getId());
            if (nodeState.hasPropertyName(NameConstants.JCR_ISCHECKEDOUT)) continue;
            node.internalSetProperty(NameConstants.JCR_ISCHECKEDOUT, InternalValue.create(true));
            createdTransientState = true;
        }
        return createdTransientState;
    }

    private EffectiveNodeType getEffectiveNodeType(NodeState state) throws RepositoryException {
        try {
            NodeTypeRegistry registry = this.session.getNodeTypeManager().getNodeTypeRegistry();
            return registry.getEffectiveNodeType(state.getNodeTypeName(), state.getMixinTypeNames());
        }
        catch (NodeTypeConflictException e) {
            throw new RepositoryException("Failed to build effective node type of node state " + state.getId(), e);
        }
    }

    public String safeGetJCRPath() {
        return this.itemMgr.safeGetJCRPath(this.id);
    }

    protected void internalRemove(boolean noChecks) throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        if (this.getDepth() == 0) {
            throw new RepositoryException("Cannot remove the root node");
        }
        NodeImpl parentNode = (NodeImpl)this.getParent();
        if (!noChecks) {
            int options = 400;
            this.session.getValidator().checkRemove(this, options, 0);
            options = 22;
            this.session.getValidator().checkModify(parentNode, options, 0);
        }
        Path.Element thisName = this.getPrimaryPath().getNameElement();
        if (this.isNode()) {
            parentNode.removeChildNode(thisName.getName(), thisName.getIndex());
        } else {
            parentNode.removeChildProperty(thisName.getName());
        }
    }

    public abstract Name getQName() throws RepositoryException;

    @Override
    public abstract void accept(ItemVisitor var1) throws RepositoryException;

    @Override
    public abstract boolean isNode();

    @Override
    public abstract String getName() throws RepositoryException;

    @Override
    public abstract Node getParent() throws ItemNotFoundException, AccessDeniedException, RepositoryException;

    @Override
    public boolean isNew() {
        ItemState state = this.getItemState();
        return state.isTransient() && state.getOverlayedState() == null;
    }

    protected boolean isTransactionalNew() {
        ItemState state = this.getItemState();
        return state.getStatus() == 4;
    }

    @Override
    public boolean isModified() {
        ItemState state = this.getItemState();
        return state.isTransient() && state.getOverlayedState() != null;
    }

    @Override
    public void remove() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.internalRemove(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() throws AccessDeniedException, ItemExistsException, ConstraintViolationException, InvalidItemStateException, ReferentialIntegrityException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        this.sanityCheck();
        SessionImpl sessionImpl = this.session;
        synchronized (sessionImpl) {
            Collection<ItemState> dirty;
            try {
                dirty = this.getTransientStates();
            }
            catch (ConcurrentModificationException e) {
                String msg = "Concurrent modification; session is closed";
                log.error(msg, e);
                this.session.logout();
                throw e;
            }
            if (dirty.size() == 0) {
                return;
            }
            Collection<ItemState> removed = this.getRemovedStates();
            HashMap<ItemId, ItemState> affected = new HashMap<ItemId, ItemState>(dirty.size() + removed.size());
            for (ItemState state : dirty) {
                affected.put(state.getId(), state);
            }
            for (ItemState state : removed) {
                affected.put(state.getId(), state);
            }
            for (ItemState transientState : affected.values()) {
                if (!transientState.isNode()) continue;
                NodeState nodeState = (NodeState)transientState;
                HashSet<NodeId> dependentIDs = new HashSet<NodeId>();
                if (nodeState.hasOverlayedState()) {
                    NodeState overlayedState = (NodeState)nodeState.getOverlayedState();
                    NodeId oldParentId = overlayedState.getParentId();
                    NodeId newParentId = nodeState.getParentId();
                    if (oldParentId != null) {
                        if (newParentId == null) {
                            if (overlayedState.isShareable()) {
                                dependentIDs.addAll(overlayedState.getSharedSet());
                            } else {
                                dependentIDs.add(oldParentId);
                            }
                        } else if (!oldParentId.equals(newParentId)) {
                            dependentIDs.add(oldParentId);
                            dependentIDs.add(newParentId);
                        } else if (!affected.containsKey(newParentId) && this.stateMgr.hasTransientItemState(newParentId)) {
                            try {
                                NodeState parent = (NodeState)this.stateMgr.getTransientItemState(newParentId);
                                for (ChildNodeEntry cne : parent.getRenamedChildNodeEntries()) {
                                    if (!cne.getId().equals(nodeState.getId())) continue;
                                    dependentIDs.add(newParentId);
                                }
                            }
                            catch (ItemStateException ise) {
                                log.warn("failed to retrieve transient state: " + newParentId, ise);
                            }
                        }
                    }
                }
                for (ChildNodeEntry cne : nodeState.getRemovedChildNodeEntries()) {
                    dependentIDs.add(cne.getId());
                }
                for (ChildNodeEntry cne : nodeState.getAddedChildNodeEntries()) {
                    dependentIDs.add(cne.getId());
                }
                for (NodeId id : dependentIDs) {
                    if (affected.containsKey(id) || !this.stateMgr.hasTransientItemState(id) && !this.stateMgr.hasTransientItemStateInAttic(id)) continue;
                    String msg = this.itemMgr.safeGetJCRPath(id) + " needs to be saved as well.";
                    log.debug(msg);
                    throw new ConstraintViolationException(msg);
                }
            }
            this.validateTransientItems(dirty, removed);
            try {
                this.stateMgr.edit();
            }
            catch (IllegalStateException e) {
                String msg = "Unable to start edit operation";
                log.debug(msg);
                throw new RepositoryException(msg, e);
            }
            boolean succeeded = false;
            try {
                this.removeTransientItems(removed);
                this.processShareableNodes(dirty);
                if (this.initVersionHistories(dirty)) {
                    dirty = this.getTransientStates();
                }
                this.persistTransientItems(dirty);
                for (ItemState transientState : dirty) {
                    this.stateMgr.disposeTransientItemState(transientState);
                }
                this.stateMgr.update();
                succeeded = true;
            }
            catch (StaleItemStateException e) {
                throw new InvalidItemStateException(e.getMessage());
            }
            catch (ItemStateException e) {
                throw new RepositoryException("Unable to update item: " + this, e);
            }
            finally {
                if (!succeeded) {
                    this.stateMgr.cancel();
                    this.restoreTransientItems(dirty);
                }
            }
            for (ItemState transientState : removed) {
                this.stateMgr.disposeTransientItemStateInAttic(transientState);
            }
        }
    }

    @Override
    public synchronized void refresh(boolean keepChanges) throws InvalidItemStateException, RepositoryException {
        Iterator<ItemState> iter;
        ItemState transientState;
        this.sanityCheck();
        if (keepChanges) {
            return;
        }
        if (this.isNode() && this.getDepth() == 0) {
            this.stateMgr.disposeAllTransientItemStates();
            return;
        }
        ArrayList<ItemState> list = new ArrayList<ItemState>();
        if (this.isTransient()) {
            transientState = this.getItemState();
            switch (transientState.getStatus()) {
                case 5: 
                case 6: {
                    list.add(transientState);
                    break;
                }
                case 2: {
                    if (!transientState.getParentId().equals(transientState.getOverlayedState().getParentId())) {
                        throw new RepositoryException("Cannot refresh a moved item: " + this + " - possible solution: refresh the parent");
                    }
                    list.add(transientState);
                    break;
                }
                case 4: {
                    throw new RepositoryException("Cannot refresh a new item: " + this);
                }
                default: {
                    log.warn("Unexpected item state status:" + transientState.getStatus() + " of " + this);
                }
            }
        }
        if (this.isNode()) {
            iter = this.stateMgr.getDescendantTransientItemStates((NodeId)this.id);
            block8: while (iter.hasNext()) {
                transientState = iter.next();
                switch (transientState.getStatus()) {
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: {
                        list.add(transientState);
                        continue block8;
                    }
                }
                log.debug("unexpected state status (" + transientState.getStatus() + ")");
            }
        }
        for (ItemState state : list) {
            this.stateMgr.disposeTransientItemState(state);
        }
        if (this.isNode()) {
            iter = this.stateMgr.getDescendantTransientItemStatesInAttic((NodeId)this.id);
            while (iter.hasNext()) {
                transientState = iter.next();
                this.stateMgr.disposeTransientItemStateInAttic(transientState);
            }
        }
    }

    @Override
    public Item getAncestor(int degree) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        this.sanityCheck();
        if (degree == 0) {
            return this.itemMgr.getRootNode();
        }
        try {
            Path path = this.getPrimaryPath();
            int relDegree = path.getAncestorCount() - degree;
            if (relDegree < 0) {
                throw new ItemNotFoundException();
            }
            if (relDegree == 0) {
                return this;
            }
            Path ancestorPath = path.getAncestor(relDegree);
            return this.itemMgr.getNode(ancestorPath);
        }
        catch (PathNotFoundException pnfe) {
            throw new ItemNotFoundException();
        }
    }

    @Override
    public String getPath() throws RepositoryException {
        this.sanityCheck();
        return this.session.getJCRPath(this.getPrimaryPath());
    }

    @Override
    public int getDepth() throws RepositoryException {
        this.sanityCheck();
        ItemState state = this.getItemState();
        if (state.getParentId() == null) {
            return 0;
        }
        return this.session.getHierarchyManager().getDepth(this.id);
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public boolean isSame(Item otherItem) throws RepositoryException {
        this.sanityCheck();
        if (this == otherItem) {
            return true;
        }
        if (otherItem instanceof ItemImpl) {
            ItemImpl other = (ItemImpl)otherItem;
            return this.id.equals(other.id) && this.session.getWorkspace().getName().equals(other.getSession().getWorkspace().getName());
        }
        return false;
    }

    public String toString() {
        return this.safeGetJCRPath();
    }
}

