/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.LazyItemIterator;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.WorkspaceImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.UpdatableItemStateManager;
import org.apache.jackrabbit.core.version.InternalActivity;
import org.apache.jackrabbit.core.version.InternalBaseline;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.NodeStateEx;
import org.apache.jackrabbit.core.version.VersionImpl;
import org.apache.jackrabbit.core.version.VersionManagerImplBase;
import org.apache.jackrabbit.core.version.VersionManagerImplConfig;
import org.apache.jackrabbit.core.version.VersionSet;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionManagerImpl
extends VersionManagerImplConfig
implements VersionManager {
    private static final Logger log = LoggerFactory.getLogger(VersionManagerImpl.class);

    public VersionManagerImpl(SessionImpl session, UpdatableItemStateManager stateMgr, HierarchyManager hierMgr) {
        super(session, stateMgr, hierMgr);
    }

    @Override
    public Version checkin(String absPath) throws RepositoryException {
        return this.checkin(absPath, null);
    }

    public Version checkin(String absPath, Calendar created) throws RepositoryException {
        NodeStateEx state = this.getNodeState(absPath, 194, 256);
        NodeId baseId = this.checkoutCheckin(state, true, false, created);
        return (VersionImpl)this.session.getNodeById(baseId);
    }

    @Override
    public void checkout(String absPath) throws RepositoryException {
        NodeStateEx state = this.getNodeState(absPath, 130, 256);
        this.checkoutCheckin(state, false, true, null);
    }

    @Override
    public Version checkpoint(String absPath) throws RepositoryException {
        NodeStateEx state = this.getNodeState(absPath, 194, 256);
        NodeId baseId = this.checkoutCheckin(state, true, true, null);
        return (VersionImpl)this.session.getNodeById(baseId);
    }

    @Override
    public boolean isCheckedOut(String absPath) throws RepositoryException {
        return this.session.getNode(absPath).isCheckedOut();
    }

    @Override
    public VersionHistory getVersionHistory(String absPath) throws RepositoryException {
        NodeStateEx state = this.getNodeState(absPath);
        InternalVersionHistory vh = this.getVersionHistory(state);
        return (VersionHistory)((Object)this.session.getNodeById(vh.getId()));
    }

    @Override
    public Version getBaseVersion(String absPath) throws RepositoryException {
        NodeStateEx state = this.getNodeState(absPath);
        InternalVersion v = this.getBaseVersion(state);
        return (Version)((Object)this.session.getNodeById(v.getId()));
    }

    @Override
    public void restore(Version version, boolean removeExisting) throws RepositoryException {
        this.restore(new Version[]{version}, removeExisting);
    }

    @Override
    public void restore(Version[] versions, boolean removeExisting) throws RepositoryException {
        if (this.session.hasPendingChanges()) {
            String msg = "Unable to restore version. Session has pending changes.";
            log.error(msg);
            throw new InvalidItemStateException(msg);
        }
        HashMap<NodeId, InternalVersion> toRestore = new HashMap<NodeId, InternalVersion>();
        for (Version version : versions) {
            InternalVersion v = this.vMgr.getVersion(((VersionImpl)version).getNodeId());
            NodeId historyId = v.getVersionHistory().getId();
            if (toRestore.containsKey(historyId)) {
                String msg = "Unable to restore. Two or more versions have same version history.";
                log.error(msg);
                throw new VersionException(msg);
            }
            toRestore.put(historyId, v);
        }
        VersionManagerImplBase.WriteOperation ops = this.startWriteOperation();
        try {
            this.internalRestore(new VersionSet(toRestore, true), removeExisting);
            ops.save();
        }
        catch (ItemStateException e) {
            throw new RepositoryException(e);
        }
        finally {
            ops.close();
        }
    }

    @Override
    public void restore(String absPath, String versionName, boolean removeExisting) throws RepositoryException {
        NodeStateEx state = this.getNodeState(absPath, 162, 0);
        this.restore(state, this.session.getQName(versionName), removeExisting);
    }

    @Override
    public void restore(String absPath, Version version, boolean removeExisting) throws RepositoryException {
        if (this.session.nodeExists(absPath)) {
            String msg = "VersionManager.restore(String, Version, boolean) not allowed on existing nodes. use VersionManager.restore(Version, boolean) instead: " + absPath;
            log.error(msg);
            throw new VersionException(msg);
        }
        Path path = this.session.getQPath(absPath);
        Path parentPath = path.getAncestor(1);
        Name name = path.getNameElement().getName();
        NodeImpl parent = this.session.getItemManager().getNode(parentPath);
        NodeStateEx state = this.getNodeState(parent, 162, 0);
        InternalVersion v = this.getVersion(version);
        if (v instanceof InternalBaseline) {
            this.restore(state, name, (InternalBaseline)v);
        } else {
            this.restore(state, name, v, removeExisting);
        }
    }

    protected void restore(NodeImpl node, Version version, boolean removeExisting) throws RepositoryException {
        NodeStateEx state = this.getNodeState(node.getPath(), 162, 0);
        InternalVersion v = this.getVersion(version);
        this.restore(state, v, removeExisting);
    }

    @Override
    public void restoreByLabel(String absPath, String versionLabel, boolean removeExisting) throws RepositoryException {
        NodeStateEx state = this.getNodeState(absPath, 162, 0);
        this.restoreByLabel(state, this.session.getQName(versionLabel), removeExisting);
    }

    public void update(NodeImpl node, String srcWorkspaceName) throws RepositoryException {
        NodeStateEx state = this.getNodeState(node, 32, 256);
        this.mergeOrUpdate(state, srcWorkspaceName, null, false, false);
    }

    @Override
    public NodeIterator merge(String absPath, String srcWorkspace, boolean bestEffort) throws RepositoryException {
        return this.merge(absPath, srcWorkspace, bestEffort, false);
    }

    @Override
    public NodeIterator merge(String absPath, String srcWorkspaceName, boolean bestEffort, boolean isShallow) throws RepositoryException {
        NodeStateEx state = this.getNodeState(absPath, 32, 256);
        LinkedList<ItemId> failedIds = new LinkedList<ItemId>();
        this.mergeOrUpdate(state, srcWorkspaceName, failedIds, bestEffort, isShallow);
        return new LazyItemIterator(this.session.getItemManager(), failedIds);
    }

    private void mergeOrUpdate(NodeStateEx state, String srcWorkspaceName, List<ItemId> failedIds, boolean bestEffort, boolean isShallow) throws RepositoryException {
        if (!srcWorkspaceName.equals(this.session.getWorkspace().getName())) {
            if (!this.session.getAccessManager().canAccess(srcWorkspaceName)) {
                String msg = "not authorized to access " + srcWorkspaceName;
                log.error(msg);
                throw new AccessDeniedException(msg);
            }
            SessionImpl srcSession = null;
            try {
                srcSession = ((RepositoryImpl)this.session.getRepository()).createSession(this.session.getSubject(), srcWorkspaceName);
                WorkspaceImpl srcWsp = (WorkspaceImpl)srcSession.getWorkspace();
                NodeId rootNodeId = ((NodeImpl)srcSession.getRootNode()).getNodeId();
                NodeStateEx srcRoot = new NodeStateEx(srcWsp.getItemStateManager(), this.ntReg, rootNodeId);
                this.merge(state, srcRoot, failedIds, bestEffort, isShallow);
            }
            catch (ItemStateException e) {
                throw new RepositoryException(e);
            }
            finally {
                if (srcSession != null) {
                    srcSession.logout();
                }
            }
        }
    }

    @Override
    public void doneMerge(String absPath, Version version) throws RepositoryException {
        NodeStateEx state = this.getNodeState(absPath, 194, 256);
        this.finishMerge(state, version, false);
    }

    @Override
    public void cancelMerge(String absPath, Version version) throws RepositoryException {
        NodeStateEx state = this.getNodeState(absPath, 194, 256);
        this.finishMerge(state, version, true);
    }

    @Override
    public Node createConfiguration(String absPath) throws RepositoryException {
        if (this.session.nodeExists(absPath)) {
            NodeStateEx state = this.getNodeState(absPath, 194, 256);
            if (!this.checkVersionable(state)) {
                throw new UnsupportedRepositoryOperationException("Node not full versionable: " + absPath);
            }
            if (state.getPropertyValue(NameConstants.JCR_CONFIGURATION) != null) {
                String msg = "Node is already a configuration root: " + absPath;
                log.error(msg);
                throw new UnsupportedRepositoryOperationException(msg);
            }
            NodeId configId = this.createConfiguration(state);
            return this.session.getNodeById(configId);
        }
        String msg = "Create configuration node must exist: " + absPath;
        log.error(msg);
        throw new UnsupportedRepositoryOperationException(msg);
    }

    @Override
    public Node setActivity(Node activity) throws RepositoryException {
        Node oldActivity = this.getActivity();
        if (activity == null) {
            this.currentActivity = null;
        } else {
            NodeImpl actNode = (NodeImpl)activity;
            if (!actNode.isNodeType(NameConstants.NT_ACTIVITY)) {
                String msg = "Given node is not an activity: " + actNode.safeGetJCRPath();
                log.error(msg);
                throw new UnsupportedRepositoryOperationException(msg);
            }
            this.currentActivity = actNode.getNodeId();
        }
        return oldActivity;
    }

    @Override
    public Node getActivity() throws RepositoryException {
        if (this.currentActivity == null) {
            return null;
        }
        return this.session.getNodeById(this.currentActivity);
    }

    @Override
    public Node createActivity(String title) throws RepositoryException {
        NodeId id = this.vMgr.createActivity(this.session, title);
        return this.session.getNodeById(id);
    }

    @Override
    public void removeActivity(Node node) throws RepositoryException {
        NodeImpl actNode = (NodeImpl)node;
        if (!actNode.isNodeType(NameConstants.NT_ACTIVITY)) {
            String msg = "Given node is not an activity: " + actNode.safeGetJCRPath();
            log.error(msg);
            throw new UnsupportedRepositoryOperationException(msg);
        }
        NodeId actId = actNode.getNodeId();
        this.vMgr.removeActivity(this.session, actId);
        if (actId.equals(this.currentActivity)) {
            this.currentActivity = null;
        }
    }

    @Override
    public NodeIterator merge(Node activityNode) throws RepositoryException {
        NodeImpl actNode = (NodeImpl)activityNode;
        if (!actNode.isNodeType(NameConstants.NT_ACTIVITY)) {
            String msg = "Given node is not an activity: " + actNode.safeGetJCRPath();
            log.error(msg);
            throw new UnsupportedRepositoryOperationException(msg);
        }
        InternalActivity activity = this.vMgr.getActivity(actNode.getNodeId());
        if (activity == null) {
            String msg = "Given activity not found in version storage.";
            log.error(msg);
            throw new UnsupportedRepositoryOperationException(msg);
        }
        ArrayList<ItemId> failedIds = new ArrayList<ItemId>();
        this.merge(activity, failedIds);
        return new LazyItemIterator(this.session.getItemManager(), failedIds);
    }

    private NodeStateEx getNodeState(String path) throws RepositoryException {
        return this.getNodeState(path, 0, 0);
    }

    private NodeStateEx getNodeState(String path, int options, int permissions) throws RepositoryException {
        return this.getNodeState((NodeImpl)this.session.getNode(path), options, permissions);
    }

    private NodeStateEx getNodeState(NodeImpl node, int options, int permissions) throws RepositoryException {
        try {
            if (options > 0 || permissions > 0) {
                this.session.getValidator().checkModify(node, options, permissions);
            }
            return new NodeStateEx(this.stateMgr, this.ntReg, (NodeState)this.stateMgr.getItemState(node.getNodeId()), node.getQName());
        }
        catch (ItemStateException e) {
            throw new RepositoryException(e);
        }
    }
}

