/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Workspace;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.QueryManager;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.api.JackrabbitWorkspace;
import org.apache.jackrabbit.commons.AbstractWorkspace;
import org.apache.jackrabbit.core.BatchedItemOperations;
import org.apache.jackrabbit.core.CachingHierarchyManager;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SearchManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.VersionManagerImpl;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.lock.LockManager;
import org.apache.jackrabbit.core.lock.SessionLockManager;
import org.apache.jackrabbit.core.observation.EventStateCollection;
import org.apache.jackrabbit.core.observation.EventStateCollectionFactory;
import org.apache.jackrabbit.core.observation.ObservationManagerImpl;
import org.apache.jackrabbit.core.query.QueryManagerImpl;
import org.apache.jackrabbit.core.retention.RetentionRegistry;
import org.apache.jackrabbit.core.state.LocalItemStateManager;
import org.apache.jackrabbit.core.state.SharedItemStateManager;
import org.apache.jackrabbit.core.xml.ImportHandler;
import org.apache.jackrabbit.core.xml.WorkspaceImporter;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class WorkspaceImpl
extends AbstractWorkspace
implements JackrabbitWorkspace,
Workspace,
EventStateCollectionFactory {
    private static Logger log = LoggerFactory.getLogger(WorkspaceImpl.class);
    protected final WorkspaceConfig wspConfig;
    protected final RepositoryImpl rep;
    protected final LocalItemStateManager stateMgr;
    protected final CachingHierarchyManager hierMgr;
    protected ObservationManagerImpl obsMgr;
    protected QueryManagerImpl queryManager;
    protected final SessionImpl session;
    protected LockManager lockMgr;
    private javax.jcr.lock.LockManager jcr283LockManager;
    protected VersionManagerImpl versionMgr;
    private RetentionRegistry retentionRegistry;

    protected WorkspaceImpl(WorkspaceConfig wspConfig, SharedItemStateManager stateMgr, RepositoryImpl rep, SessionImpl session) {
        this.wspConfig = wspConfig;
        this.rep = rep;
        this.stateMgr = this.createItemStateManager(stateMgr);
        this.hierMgr = new CachingHierarchyManager(rep.getRootNodeId(), this.stateMgr);
        this.stateMgr.addListener(this.hierMgr);
        this.session = session;
    }

    public HierarchyManager getHierarchyManager() {
        return this.hierMgr;
    }

    public LocalItemStateManager getItemStateManager() {
        return this.stateMgr;
    }

    void dispose() {
        if (this.obsMgr != null) {
            this.obsMgr.dispose();
            this.obsMgr = null;
        }
        this.stateMgr.dispose();
    }

    public void sanityCheck() throws RepositoryException {
        this.session.sanityCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createWorkspace(String name, String srcWorkspace) throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        this.sanityCheck();
        this.session.createWorkspace(name);
        SessionImpl tmpSession = null;
        try {
            tmpSession = this.rep.createSession(this.session.getSubject(), name);
            WorkspaceImpl newWsp = (WorkspaceImpl)tmpSession.getWorkspace();
            Node root = this.session.getRootNode();
            NodeIterator it = root.getNodes();
            while (it.hasNext()) {
                Node child = it.nextNode();
                if (tmpSession.nodeExists(child.getPath())) continue;
                newWsp.clone(srcWorkspace, child.getPath(), child.getPath(), false);
            }
        }
        finally {
            if (tmpSession != null) {
                tmpSession.logout();
            }
        }
    }

    public void deleteWorkspace(String name) throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        this.rep.getWorkspaceInfo(name);
        throw new UnsupportedRepositoryOperationException("not yet implemented");
    }

    public javax.jcr.lock.LockManager getLockManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        if (this.jcr283LockManager == null) {
            this.jcr283LockManager = new SessionLockManager(this.session, this.session.getLockManager());
        }
        return this.jcr283LockManager;
    }

    public VersionManager getVersionManager() {
        return this.getVersionManagerImpl();
    }

    VersionManagerImpl getVersionManagerImpl() {
        if (this.versionMgr == null) {
            this.versionMgr = new VersionManagerImpl(this.session, this.stateMgr, this.hierMgr);
        }
        return this.versionMgr;
    }

    public void createWorkspace(String name) throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        this.sanityCheck();
        this.session.createWorkspace(name);
    }

    public void createWorkspace(String workspaceName, InputSource configTemplate) throws AccessDeniedException, RepositoryException {
        this.sanityCheck();
        this.session.createWorkspace(workspaceName, configTemplate);
    }

    public WorkspaceConfig getConfig() {
        return this.wspConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String internalCopy(String srcAbsPath, WorkspaceImpl srcWsp, String destAbsPath, int flag) throws ConstraintViolationException, AccessDeniedException, VersionException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        Path destPath;
        Path srcPath;
        try {
            srcPath = this.session.getQPath(srcAbsPath).getNormalizedPath();
        }
        catch (NameException e) {
            String msg = "invalid path: " + srcAbsPath;
            log.debug(msg);
            throw new RepositoryException(msg, e);
        }
        if (!srcPath.isAbsolute()) {
            throw new RepositoryException("not an absolute path: " + srcAbsPath);
        }
        try {
            destPath = this.session.getQPath(destAbsPath).getNormalizedPath();
        }
        catch (NameException e) {
            String msg = "invalid path: " + destAbsPath;
            log.debug(msg);
            throw new RepositoryException(msg, e);
        }
        if (!destPath.isAbsolute()) {
            throw new RepositoryException("not an absolute path: " + destAbsPath);
        }
        BatchedItemOperations ops = new BatchedItemOperations(this.stateMgr, this.rep.getNodeTypeRegistry(), this.session.getLockManager(), this.session, this.hierMgr);
        try {
            ops.edit();
        }
        catch (IllegalStateException e) {
            String msg = "unable to start edit operation";
            log.debug(msg);
            throw new RepositoryException(msg, e);
        }
        boolean succeeded = false;
        try {
            NodeId id = ops.copy(srcPath, srcWsp.getItemStateManager(), srcWsp.getHierarchyManager(), ((SessionImpl)srcWsp.getSession()).getAccessManager(), destPath, flag);
            ops.update();
            succeeded = true;
            String string = this.session.getJCRPath(this.hierMgr.getPath(id));
            return string;
        }
        finally {
            if (!succeeded) {
                ops.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String internalClone(String srcAbsPath, String destAbsPath) throws ConstraintViolationException, AccessDeniedException, VersionException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        Path destPath;
        Path srcPath;
        try {
            srcPath = this.session.getQPath(srcAbsPath).getNormalizedPath();
        }
        catch (NameException e) {
            String msg = "invalid path: " + srcAbsPath;
            log.debug(msg);
            throw new RepositoryException(msg, e);
        }
        if (!srcPath.isAbsolute()) {
            throw new RepositoryException("not an absolute path: " + srcAbsPath);
        }
        try {
            destPath = this.session.getQPath(destAbsPath).getNormalizedPath();
        }
        catch (NameException e) {
            String msg = "invalid path: " + destAbsPath;
            log.debug(msg);
            throw new RepositoryException(msg, e);
        }
        if (!destPath.isAbsolute()) {
            throw new RepositoryException("not an absolute path: " + destAbsPath);
        }
        BatchedItemOperations ops = new BatchedItemOperations(this.stateMgr, this.rep.getNodeTypeRegistry(), this.session.getLockManager(), this.session, this.hierMgr);
        try {
            ops.edit();
        }
        catch (IllegalStateException e) {
            String msg = "unable to start edit operation";
            log.debug(msg);
            throw new RepositoryException(msg, e);
        }
        boolean succeeded = false;
        try {
            NodeId id = ops.clone(srcPath, destPath);
            ops.update();
            succeeded = true;
            String string = this.session.getJCRPath(this.hierMgr.getPath(id));
            return string;
        }
        finally {
            if (!succeeded) {
                ops.cancel();
            }
        }
    }

    public synchronized LockManager getInternalLockManager() throws RepositoryException {
        this.sanityCheck();
        if (this.lockMgr == null) {
            this.lockMgr = this.rep.getLockManager(this.wspConfig.getName());
        }
        return this.lockMgr;
    }

    synchronized RetentionRegistry getRetentionRegistry() throws RepositoryException {
        this.sanityCheck();
        if (this.retentionRegistry == null) {
            this.retentionRegistry = this.rep.getRetentionRegistry(this.wspConfig.getName());
        }
        return this.retentionRegistry;
    }

    public String getName() {
        return this.wspConfig.getName();
    }

    public Session getSession() {
        return this.session;
    }

    public NamespaceRegistry getNamespaceRegistry() throws RepositoryException {
        this.sanityCheck();
        return this.rep.getNamespaceRegistry();
    }

    public NodeTypeManager getNodeTypeManager() throws RepositoryException {
        this.sanityCheck();
        return this.session.getNodeTypeManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clone(String srcWorkspace, String srcAbsPath, String destAbsPath, boolean removeExisting) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        this.sanityCheck();
        if (this.getName().equals(srcWorkspace)) {
            if (!removeExisting) {
                this.internalClone(srcAbsPath, destAbsPath);
                return;
            }
            String msg = srcWorkspace + ": illegal workspace (same as current)";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        if (!this.session.getAccessManager().canAccess(srcWorkspace)) {
            throw new AccessDeniedException("not authorized to access " + srcWorkspace);
        }
        SessionImpl srcSession = null;
        try {
            srcSession = this.rep.createSession(this.session.getSubject(), srcWorkspace);
            WorkspaceImpl srcWsp = (WorkspaceImpl)srcSession.getWorkspace();
            int mode = 1;
            if (removeExisting) {
                mode = 2;
            }
            this.internalCopy(srcAbsPath, srcWsp, destAbsPath, mode);
        }
        finally {
            if (srcSession != null) {
                srcSession.logout();
            }
        }
    }

    public void copy(String srcAbsPath, String destAbsPath) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        this.sanityCheck();
        this.internalCopy(srcAbsPath, this, destAbsPath, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(String srcWorkspace, String srcAbsPath, String destAbsPath) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        this.sanityCheck();
        if (this.getName().equals(srcWorkspace)) {
            this.copy(srcAbsPath, destAbsPath);
            return;
        }
        if (!this.session.getAccessManager().canAccess(srcWorkspace)) {
            throw new AccessDeniedException("not authorized to access " + srcWorkspace);
        }
        SessionImpl srcSession = null;
        try {
            srcSession = this.rep.createSession(this.session.getSubject(), srcWorkspace);
            WorkspaceImpl srcWsp = (WorkspaceImpl)srcSession.getWorkspace();
            this.internalCopy(srcAbsPath, srcWsp, destAbsPath, 0);
        }
        finally {
            if (srcSession != null) {
                srcSession.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(String srcAbsPath, String destAbsPath) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        Path destPath;
        Path srcPath;
        this.sanityCheck();
        try {
            srcPath = this.session.getQPath(srcAbsPath).getNormalizedPath();
        }
        catch (NameException e) {
            String msg = "invalid path: " + srcAbsPath;
            log.debug(msg);
            throw new RepositoryException(msg, e);
        }
        if (!srcPath.isAbsolute()) {
            throw new RepositoryException("not an absolute path: " + srcAbsPath);
        }
        try {
            destPath = this.session.getQPath(destAbsPath).getNormalizedPath();
        }
        catch (NameException e) {
            String msg = "invalid path: " + destAbsPath;
            log.debug(msg);
            throw new RepositoryException(msg, e);
        }
        if (!destPath.isAbsolute()) {
            throw new RepositoryException("not an absolute path: " + destAbsPath);
        }
        BatchedItemOperations ops = new BatchedItemOperations(this.stateMgr, this.rep.getNodeTypeRegistry(), this.session.getLockManager(), this.session, this.hierMgr);
        try {
            ops.edit();
        }
        catch (IllegalStateException e) {
            String msg = "unable to start edit operation";
            log.debug(msg);
            throw new RepositoryException(msg, e);
        }
        boolean succeeded = false;
        try {
            ops.move(srcPath, destPath);
            ops.update();
            succeeded = true;
        }
        finally {
            if (!succeeded) {
                ops.cancel();
            }
        }
    }

    public ObservationManager getObservationManager() throws RepositoryException {
        this.sanityCheck();
        if (this.obsMgr == null) {
            try {
                this.obsMgr = new ObservationManagerImpl(this.rep.getObservationDispatcher(this.wspConfig.getName()), this.session, this.session.getItemManager(), this.rep.getClusterNode());
            }
            catch (NoSuchWorkspaceException nswe) {
                String msg = "internal error: failed to instantiate observation manager";
                log.debug(msg);
                throw new RepositoryException(msg, nswe);
            }
        }
        return this.obsMgr;
    }

    public synchronized QueryManager getQueryManager() throws RepositoryException {
        this.sanityCheck();
        if (this.queryManager == null) {
            SearchManager searchManager;
            try {
                searchManager = this.rep.getSearchManager(this.wspConfig.getName());
                if (searchManager == null) {
                    String msg = "no search manager configured for this workspace";
                    log.debug(msg);
                    throw new RepositoryException(msg);
                }
            }
            catch (NoSuchWorkspaceException nswe) {
                String msg = "internal error: failed to instantiate query manager";
                log.debug(msg);
                throw new RepositoryException(msg, nswe);
            }
            this.queryManager = new QueryManagerImpl(this.session, this.session.getItemManager(), searchManager);
        }
        return this.queryManager;
    }

    @Deprecated
    public void restore(Version[] versions, boolean removeExisting) throws ItemExistsException, UnsupportedRepositoryOperationException, VersionException, LockException, InvalidItemStateException, RepositoryException {
        this.sanityCheck();
        this.getVersionManager().restore(versions, removeExisting);
    }

    public String[] getAccessibleWorkspaceNames() throws RepositoryException {
        this.sanityCheck();
        return this.session.getWorkspaceNames();
    }

    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, RepositoryException {
        Path parentPath;
        this.sanityCheck();
        try {
            parentPath = this.session.getQPath(parentAbsPath).getNormalizedPath();
        }
        catch (NameException e) {
            String msg = "invalid path: " + parentAbsPath;
            log.debug(msg);
            throw new RepositoryException(msg, e);
        }
        if (!parentPath.isAbsolute()) {
            throw new RepositoryException("not an absolute path: " + parentAbsPath);
        }
        WorkspaceImporter importer = new WorkspaceImporter(parentPath, this, this.rep.getNodeTypeRegistry(), uuidBehavior, this.wspConfig.getImportConfig());
        return new ImportHandler(importer, this.session);
    }

    protected LocalItemStateManager createItemStateManager(SharedItemStateManager shared) {
        return LocalItemStateManager.createInstance(shared, this, this.rep.getItemStateCacheFactory());
    }

    public EventStateCollection createEventStateCollection() throws RepositoryException {
        return ((ObservationManagerImpl)this.getObservationManager()).createEventStateCollection();
    }
}

