/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.core.config.AccessManagerConfig;
import org.apache.jackrabbit.core.config.BeanConfig;
import org.apache.jackrabbit.core.config.ClusterConfig;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.config.ConfigurationParser;
import org.apache.jackrabbit.core.config.DataSourceConfig;
import org.apache.jackrabbit.core.config.ImportConfig;
import org.apache.jackrabbit.core.config.LoginModuleConfig;
import org.apache.jackrabbit.core.config.PersistenceManagerConfig;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.config.SecurityConfig;
import org.apache.jackrabbit.core.config.SecurityManagerConfig;
import org.apache.jackrabbit.core.config.UserManagerConfig;
import org.apache.jackrabbit.core.config.VersioningConfig;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.config.WorkspaceSecurityConfig;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.DataStoreFactory;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemFactory;
import org.apache.jackrabbit.core.journal.AbstractJournal;
import org.apache.jackrabbit.core.journal.Journal;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.JournalFactory;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.core.query.QueryHandlerContext;
import org.apache.jackrabbit.core.query.QueryHandlerFactory;
import org.apache.jackrabbit.core.state.DefaultISMLocking;
import org.apache.jackrabbit.core.state.ISMLocking;
import org.apache.jackrabbit.core.state.ISMLockingFactory;
import org.apache.jackrabbit.core.util.RepositoryLock;
import org.apache.jackrabbit.core.util.RepositoryLockMechanism;
import org.apache.jackrabbit.core.util.RepositoryLockMechanismFactory;
import org.apache.jackrabbit.core.util.db.ConnectionFactory;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class RepositoryConfigurationParser
extends ConfigurationParser {
    public static final String REPOSITORY_HOME_VARIABLE = "rep.home";
    public static final String REPOSITORY_CONF_VARIABLE = "rep.conf";
    public static final String WORKSPACE_HOME_VARIABLE = "wsp.home";
    public static final String WORKSPACE_NAME_VARIABLE = "wsp.name";
    public static final String SECURITY_ELEMENT = "Security";
    public static final String SECURITY_MANAGER_ELEMENT = "SecurityManager";
    public static final String ACCESS_MANAGER_ELEMENT = "AccessManager";
    public static final String LOGIN_MODULE_ELEMENT = "LoginModule";
    private static final String WORKSPACE_ACCESS_ELEMENT = "WorkspaceAccessManager";
    private static final String USER_MANAGER_ELEMENT = "UserManager";
    public static final String WORKSPACES_ELEMENT = "Workspaces";
    public static final String WORKSPACE_ELEMENT = "Workspace";
    public static final String VERSIONING_ELEMENT = "Versioning";
    public static final String FILE_SYSTEM_ELEMENT = "FileSystem";
    public static final String CLUSTER_ELEMENT = "Cluster";
    public static final String DATASOURCES_ELEMENT = "DataSources";
    public static final String DATASOURCE_ELEMENT = "DataSource";
    public static final String JOURNAL_ELEMENT = "Journal";
    public static final String DATA_STORE_ELEMENT = "DataStore";
    public static final String REPOSITORY_LOCK_MECHANISM_ELEMENT = "RepositoryLockMechanism";
    public static final String PERSISTENCE_MANAGER_ELEMENT = "PersistenceManager";
    public static final String SEARCH_INDEX_ELEMENT = "SearchIndex";
    public static final String ISM_LOCKING_ELEMENT = "ISMLocking";
    public static final String APP_NAME_ATTRIBUTE = "appName";
    public static final String WSP_NAME_ATTRIBUTE = "workspaceName";
    public static final String ROOT_PATH_ATTRIBUTE = "rootPath";
    public static final String CONFIG_ROOT_PATH_ATTRIBUTE = "configRootPath";
    public static final String MAX_IDLE_TIME_ATTRIBUTE = "maxIdleTime";
    public static final String DEFAULT_WORKSPACE_ATTRIBUTE = "defaultWorkspace";
    public static final String ID_ATTRIBUTE = "id";
    public static final String SYNC_DELAY_ATTRIBUTE = "syncDelay";
    public static final String DEFAULT_QUERY_HANDLER = "org.apache.jackrabbit.core.query.lucene.SearchIndex";
    public static final String CLUSTERED_ATTRIBUTE = "clustered";
    public static final String DEFAULT_SYNC_DELAY = "5000";
    private static final String WSP_SECURITY_ELEMENT = "WorkspaceSecurity";
    private static final String AC_PROVIDER_ELEMENT = "AccessControlProvider";
    protected final ConnectionFactory connectionFactory;
    private static final String USERID_CLASS_ELEMENT = "UserIdClass";
    private static final String IMPORT_ELEMENT = "Import";
    private static final String IMPORT_PNI_ELEMENT = "ProtectedNodeImporter";
    private static final String IMPORT_PPI_ELEMENT = "ProtectedPropertyImporter";
    private static final String CLUSTER_NODE_ID_FILE = "cluster_node.id";

    protected RepositoryConfigurationParser(Properties variables, ConnectionFactory connectionFactory) {
        super(variables);
        this.connectionFactory = connectionFactory;
    }

    public RepositoryConfigurationParser(Properties variables) {
        this(variables, new ConnectionFactory());
    }

    public RepositoryConfig parseRepositoryConfig(InputSource xml) throws ConfigurationException {
        Element root = this.parseXML(xml, true);
        String home = this.getVariables().getProperty(REPOSITORY_HOME_VARIABLE);
        FileSystemFactory fsf = this.getFileSystemFactory(root, FILE_SYSTEM_ELEMENT);
        Element security = this.getElement(root, SECURITY_ELEMENT);
        SecurityConfig securityConfig = this.parseSecurityConfig(security);
        Element workspaces = this.getElement(root, WORKSPACES_ELEMENT);
        String workspaceDirectory = this.replaceVariables(this.getAttribute(workspaces, ROOT_PATH_ATTRIBUTE));
        String workspaceConfigDirectory = this.getAttribute(workspaces, CONFIG_ROOT_PATH_ATTRIBUTE, null);
        String defaultWorkspace = this.replaceVariables(this.getAttribute(workspaces, DEFAULT_WORKSPACE_ATTRIBUTE));
        int maxIdleTime = Integer.parseInt(this.getAttribute(workspaces, MAX_IDLE_TIME_ATTRIBUTE, "0"));
        Element template = this.getElement(root, WORKSPACE_ELEMENT);
        VersioningConfig vc = this.parseVersioningConfig(root);
        QueryHandlerFactory qhf = this.getQueryHandlerFactory(root);
        ClusterConfig cc = this.parseClusterConfig(root, new File(home));
        DataStoreFactory dsf = this.getDataStoreFactory(root, home);
        RepositoryLockMechanismFactory rlf = this.getRepositoryLockMechanismFactory(root);
        DataSourceConfig dsc = this.parseDataSourceConfig(root);
        return new RepositoryConfig(home, securityConfig, fsf, workspaceDirectory, workspaceConfigDirectory, defaultWorkspace, maxIdleTime, template, vc, qhf, cc, dsf, rlf, dsc, this.connectionFactory, this);
    }

    protected BeanConfig parseBeanConfig(Element parent, String name) throws ConfigurationException {
        BeanConfig cfg = super.parseBeanConfig(parent, name);
        cfg.setConnectionFactory(this.connectionFactory);
        return cfg;
    }

    protected BeanConfig parseBeanConfig(Element element) throws ConfigurationException {
        BeanConfig cfg = super.parseBeanConfig(element);
        cfg.setConnectionFactory(this.connectionFactory);
        return cfg;
    }

    public SecurityConfig parseSecurityConfig(Element security) throws ConfigurationException {
        String appName = this.getAttribute(security, APP_NAME_ATTRIBUTE);
        SecurityManagerConfig smc = this.parseSecurityManagerConfig(security);
        AccessManagerConfig amc = this.parseAccessManagerConfig(security);
        LoginModuleConfig lmc = this.parseLoginModuleConfig(security);
        return new SecurityConfig(appName, smc, amc, lmc);
    }

    public SecurityManagerConfig parseSecurityManagerConfig(Element security) throws ConfigurationException {
        Element smElement = this.getElement(security, SECURITY_MANAGER_ELEMENT, false);
        if (smElement != null) {
            BeanConfig bc = this.parseBeanConfig(smElement);
            String wspAttr = this.getAttribute(smElement, WSP_NAME_ATTRIBUTE, null);
            BeanConfig wac = null;
            Element element = this.getElement(smElement, WORKSPACE_ACCESS_ELEMENT, false);
            if (element != null) {
                wac = this.parseBeanConfig(smElement, WORKSPACE_ACCESS_ELEMENT);
            }
            UserManagerConfig umc = null;
            element = this.getElement(smElement, USER_MANAGER_ELEMENT, false);
            if (element != null) {
                umc = new UserManagerConfig(this.parseBeanConfig(smElement, USER_MANAGER_ELEMENT));
            }
            BeanConfig uidcc = null;
            element = this.getElement(smElement, USERID_CLASS_ELEMENT, false);
            if (element != null) {
                uidcc = this.parseBeanConfig(element);
            }
            return new SecurityManagerConfig(bc, wspAttr, wac, umc, uidcc);
        }
        return null;
    }

    public AccessManagerConfig parseAccessManagerConfig(Element security) throws ConfigurationException {
        Element accessMgr = this.getElement(security, ACCESS_MANAGER_ELEMENT, false);
        if (accessMgr != null) {
            return new AccessManagerConfig(this.parseBeanConfig(accessMgr));
        }
        return null;
    }

    public LoginModuleConfig parseLoginModuleConfig(Element security) throws ConfigurationException {
        Element loginModule = this.getElement(security, LOGIN_MODULE_ELEMENT, false);
        if (loginModule != null) {
            return new LoginModuleConfig(this.parseBeanConfig(security, LOGIN_MODULE_ELEMENT));
        }
        return null;
    }

    public WorkspaceConfig parseWorkspaceConfig(InputSource xml) throws ConfigurationException {
        Element root = this.parseXML(xml);
        return this.parseWorkspaceConfig(root);
    }

    protected WorkspaceConfig parseWorkspaceConfig(Element root) throws ConfigurationException {
        String home = this.getVariables().getProperty(WORKSPACE_HOME_VARIABLE);
        String name = this.getAttribute(root, "name", new File(home).getName());
        boolean clustered = Boolean.valueOf(this.getAttribute(root, CLUSTERED_ATTRIBUTE, "true"));
        Properties tmpVariables = (Properties)this.getVariables().clone();
        tmpVariables.put(WORKSPACE_NAME_VARIABLE, name);
        RepositoryConfigurationParser tmpParser = this.createSubParser(tmpVariables);
        FileSystemFactory fsf = tmpParser.getFileSystemFactory(root, FILE_SYSTEM_ELEMENT);
        PersistenceManagerConfig pmc = tmpParser.parsePersistenceManagerConfig(root);
        QueryHandlerFactory qhf = tmpParser.getQueryHandlerFactory(root);
        ISMLockingFactory ismLockingFactory = tmpParser.getISMLockingFactory(root);
        WorkspaceSecurityConfig workspaceSecurityConfig = tmpParser.parseWorkspaceSecurityConfig(root);
        ImportConfig importConfig = tmpParser.parseImportConfig(root);
        return new WorkspaceConfig(home, name, clustered, fsf, pmc, qhf, ismLockingFactory, workspaceSecurityConfig, importConfig);
    }

    protected QueryHandlerFactory getQueryHandlerFactory(Element parent) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            final Node child = children.item(i);
            if (child.getNodeType() != 1 || !SEARCH_INDEX_ELEMENT.equals(child.getNodeName())) continue;
            return new QueryHandlerFactory(){

                public QueryHandler getQueryHandler(QueryHandlerContext context) throws RepositoryException {
                    Element element = (Element)child;
                    FileSystem fs = null;
                    if (RepositoryConfigurationParser.this.getElement(element, RepositoryConfigurationParser.FILE_SYSTEM_ELEMENT, false) != null) {
                        fs = RepositoryConfigurationParser.this.getFileSystemFactory(element, RepositoryConfigurationParser.FILE_SYSTEM_ELEMENT).getFileSystem();
                    }
                    String className = RepositoryConfigurationParser.this.getAttribute(element, "class", RepositoryConfigurationParser.DEFAULT_QUERY_HANDLER);
                    BeanConfig config = new BeanConfig(className, RepositoryConfigurationParser.this.parseParameters(element));
                    QueryHandler handler = config.newInstance(QueryHandler.class);
                    try {
                        handler.init(fs, context);
                        return handler;
                    }
                    catch (IOException e) {
                        throw new RepositoryException("Unable to initialize query handler: " + handler, e);
                    }
                }
            };
        }
        return null;
    }

    public WorkspaceSecurityConfig parseWorkspaceSecurityConfig(Element parent) throws ConfigurationException {
        BeanConfig acProviderConfig = null;
        Element element = this.getElement(parent, WSP_SECURITY_ELEMENT, false);
        if (element != null) {
            Element provFact = this.getElement(element, AC_PROVIDER_ELEMENT, false);
            if (provFact != null) {
                acProviderConfig = this.parseBeanConfig(element, AC_PROVIDER_ELEMENT);
                acProviderConfig.setValidate(false);
            }
            return new WorkspaceSecurityConfig(acProviderConfig);
        }
        return null;
    }

    public ImportConfig parseImportConfig(Element parent) throws ConfigurationException {
        ArrayList<BeanConfig> protectedNodeImporters = new ArrayList<BeanConfig>();
        ArrayList<BeanConfig> protectedPropertyImporters = new ArrayList<BeanConfig>();
        Element element = this.getElement(parent, IMPORT_ELEMENT, false);
        if (element != null) {
            NodeList children = element.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                BeanConfig bc;
                String className;
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                if (IMPORT_PNI_ELEMENT.equals(child.getNodeName())) {
                    className = this.getAttribute((Element)child, "class");
                    bc = new BeanConfig(className, this.parseParameters((Element)child));
                    bc.setValidate(false);
                    protectedNodeImporters.add(bc);
                    continue;
                }
                if (!IMPORT_PPI_ELEMENT.equals(child.getNodeName())) continue;
                className = this.getAttribute((Element)child, "class");
                bc = new BeanConfig(className, this.parseParameters((Element)child));
                bc.setValidate(false);
                protectedPropertyImporters.add(bc);
            }
            return new ImportConfig(protectedNodeImporters, protectedPropertyImporters);
        }
        return null;
    }

    protected ISMLockingFactory getISMLockingFactory(final Element parent) {
        return new ISMLockingFactory(){

            public ISMLocking getISMLocking() throws RepositoryException {
                Element element = RepositoryConfigurationParser.this.getElement(parent, RepositoryConfigurationParser.ISM_LOCKING_ELEMENT, false);
                if (element != null) {
                    return RepositoryConfigurationParser.this.parseBeanConfig(element).newInstance(ISMLocking.class);
                }
                return new DefaultISMLocking();
            }
        };
    }

    protected VersioningConfig parseVersioningConfig(Element parent) throws ConfigurationException {
        Element element = this.getElement(parent, VERSIONING_ELEMENT);
        String home = this.replaceVariables(this.getAttribute(element, ROOT_PATH_ATTRIBUTE));
        FileSystemFactory fsf = this.getFileSystemFactory(element, FILE_SYSTEM_ELEMENT);
        PersistenceManagerConfig pmc = this.parsePersistenceManagerConfig(element);
        ISMLockingFactory ismLockingFactory = this.getISMLockingFactory(element);
        return new VersioningConfig(home, fsf, pmc, ismLockingFactory);
    }

    protected ClusterConfig parseClusterConfig(Element parent, File home) throws ConfigurationException {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !CLUSTER_ELEMENT.equals(child.getNodeName())) continue;
            Element element = (Element)child;
            String id = System.getProperty("org.apache.jackrabbit.core.cluster.node_id");
            String value = this.getAttribute(element, ID_ATTRIBUTE, null);
            if (value != null) {
                id = this.replaceVariables(value);
            } else if (id == null) {
                File file = new File(home, CLUSTER_NODE_ID_FILE);
                try {
                    if (file.exists() && file.canRead()) {
                        id = FileUtils.readFileToString(file);
                    } else {
                        id = UUID.randomUUID().toString();
                        FileUtils.writeStringToFile(file, id);
                    }
                }
                catch (IOException e) {
                    throw new ConfigurationException("Failed to access cluster node id: " + file, e);
                }
            }
            long syncDelay = Long.parseLong(this.replaceVariables(this.getAttribute(element, SYNC_DELAY_ATTRIBUTE, DEFAULT_SYNC_DELAY)));
            JournalFactory jf = this.getJournalFactory(element, home, id);
            return new ClusterConfig(id, syncDelay, jf);
        }
        return null;
    }

    protected JournalFactory getJournalFactory(final Element cluster, final File home, final String id) throws ConfigurationException {
        return new JournalFactory(){

            public Journal getJournal(NamespaceResolver resolver) throws RepositoryException {
                BeanConfig config = RepositoryConfigurationParser.this.parseBeanConfig(cluster, RepositoryConfigurationParser.JOURNAL_ELEMENT);
                Journal journal = config.newInstance(Journal.class);
                if (journal instanceof AbstractJournal) {
                    ((AbstractJournal)journal).setRepositoryHome(home);
                }
                try {
                    journal.init(id, resolver);
                }
                catch (JournalException e) {
                    throw new RepositoryException("Journal initialization failed: " + journal, e);
                }
                return journal;
            }
        };
    }

    protected DataSourceConfig parseDataSourceConfig(Element parent) throws ConfigurationException {
        DataSourceConfig dsc = new DataSourceConfig();
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !DATASOURCES_ELEMENT.equals(child.getNodeName())) continue;
            Element element = (Element)child;
            NodeList children2 = element.getChildNodes();
            for (int j = 0; j < children2.getLength(); ++j) {
                Node child2 = children2.item(j);
                if (child2.getNodeType() != 1 || !DATASOURCE_ELEMENT.equals(child2.getNodeName())) continue;
                Element dsdef = (Element)child2;
                String logicalName = this.getAttribute(dsdef, "name");
                Properties props = this.parseParameters(dsdef);
                dsc.addDataSourceDefinition(logicalName, props);
            }
        }
        return dsc;
    }

    protected DataStoreFactory getDataStoreFactory(final Element parent, final String directory) throws ConfigurationException {
        return new DataStoreFactory(){

            public DataStore getDataStore() throws RepositoryException {
                NodeList children = parent.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node child = children.item(i);
                    if (child.getNodeType() != 1 || !RepositoryConfigurationParser.DATA_STORE_ELEMENT.equals(child.getNodeName())) continue;
                    BeanConfig bc = RepositoryConfigurationParser.this.parseBeanConfig(parent, RepositoryConfigurationParser.DATA_STORE_ELEMENT);
                    DataStore store = bc.newInstance(DataStore.class);
                    store.init(directory);
                    return store;
                }
                return null;
            }
        };
    }

    protected RepositoryLockMechanismFactory getRepositoryLockMechanismFactory(final Element root) {
        return new RepositoryLockMechanismFactory(){

            public RepositoryLockMechanism getRepositoryLockMechanism() throws RepositoryException {
                NodeList children = root.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node child = children.item(i);
                    if (child.getNodeType() != 1 || !RepositoryConfigurationParser.REPOSITORY_LOCK_MECHANISM_ELEMENT.equals(child.getNodeName())) continue;
                    BeanConfig bc = RepositoryConfigurationParser.this.parseBeanConfig(root, RepositoryConfigurationParser.REPOSITORY_LOCK_MECHANISM_ELEMENT);
                    return bc.newInstance(RepositoryLockMechanism.class);
                }
                return new RepositoryLock();
            }
        };
    }

    protected PersistenceManagerConfig parsePersistenceManagerConfig(Element parent) throws ConfigurationException {
        return new PersistenceManagerConfig(this.parseBeanConfig(parent, PERSISTENCE_MANAGER_ELEMENT));
    }

    protected RepositoryConfigurationParser createSubParser(Properties variables) {
        Properties props = new Properties(this.getVariables());
        props.putAll((Map<?, ?>)variables);
        return new RepositoryConfigurationParser(props, this.connectionFactory);
    }

    protected FileSystemFactory getFileSystemFactory(Element parent, String name) throws ConfigurationException {
        final BeanConfig config = this.parseBeanConfig(parent, name);
        return new FileSystemFactory(){

            public FileSystem getFileSystem() throws RepositoryException {
                try {
                    FileSystem fs = config.newInstance(FileSystem.class);
                    fs.init();
                    return fs;
                }
                catch (FileSystemException e) {
                    throw new RepositoryException("File system initialization failure.", e);
                }
            }
        };
    }
}

