/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.id;

import java.security.SecureRandom;
import java.util.Random;

class SeededSecureRandom
extends SecureRandom
implements Runnable {
    private static final int MAX_SEED_TIME = 1000;
    private static volatile Random instance = null;
    private volatile boolean seeded = false;

    public static Random getInstance() {
        if (instance == null) {
            instance = new SeededSecureRandom();
        }
        return instance;
    }

    private SeededSecureRandom() {
        Thread thread = new Thread((Runnable)this, "SeededSecureRandom");
        thread.start();
        try {
            thread.join(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (!this.seeded) {
            this.setSeed(System.currentTimeMillis());
            for (int j = 0; j < 16; ++j) {
                int i = 0;
                long start = System.currentTimeMillis();
                while (start == System.currentTimeMillis()) {
                    ++i;
                }
                this.setSeed(i);
            }
        }
    }

    public void run() {
        this.setSeed(this.generateSeed(32));
        this.seeded = true;
    }
}

