/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.lock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Workspace;
import javax.jcr.lock.LockException;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.TransactionException;
import org.apache.jackrabbit.core.XAWorkspace;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.lock.LockInfo;
import org.apache.jackrabbit.core.lock.LockManagerImpl;
import org.apache.jackrabbit.core.lock.SessionLockManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XAEnvironment {
    private static final Logger log = LoggerFactory.getLogger(XAEnvironment.class);
    private static final int STATUS_PREPARING = 1;
    private static final int STATUS_PREPARED = 2;
    private static final int STATUS_COMMITTING = 3;
    private static final int STATUS_COMMITTED = 4;
    private static final int STATUS_ROLLING_BACK = 5;
    private static final int STATUS_ROLLED_BACK = 6;
    private final LockManagerImpl lockMgr;
    private final Map<NodeId, XALockInfo> lockedNodesMap = new HashMap<NodeId, XALockInfo>();
    private final Map<NodeId, XALockInfo> unlockedNodesMap = new HashMap<NodeId, XALockInfo>();
    private final List<XALockInfo> operations = new ArrayList<XALockInfo>();
    private int opIndex;
    private int status;

    public XAEnvironment(LockManagerImpl lockMgr) {
        this.lockMgr = lockMgr;
    }

    public void reset() {
        this.lockedNodesMap.clear();
        this.unlockedNodesMap.clear();
        this.operations.clear();
        this.opIndex = 0;
    }

    public LockInfo lock(NodeImpl node, boolean isDeep, boolean isSessionScoped) throws LockException, RepositoryException {
        return this.lock(node, isDeep, isSessionScoped, Long.MAX_VALUE, null);
    }

    public LockInfo lock(NodeImpl node, boolean isDeep, boolean isSessionScoped, long timeoutHint, String ownerInfo) throws LockException, RepositoryException {
        NodeId id = node.getNodeId();
        XALockInfo info = this.unlockedNodesMap.get(id);
        if (info != null && info.isDeep() == isDeep && info.isSessionScoped() == isSessionScoped) {
            this.unlockedNodesMap.remove(id);
            this.operations.remove(info);
            return this.lockMgr.getLockInfo(id);
        }
        if (this.isLocked(node)) {
            throw new LockException("Node locked.");
        }
        String lockOwner = ownerInfo != null ? ownerInfo : node.getSession().getUserID();
        info = new XALockInfo(node, isSessionScoped, isDeep, lockOwner);
        SessionImpl session = (SessionImpl)node.getSession();
        info.setLockHolder(session);
        info.setLive(true);
        LockManagerImpl.getSessionLockManager(session).lockTokenAdded(info.getLockToken());
        this.lockedNodesMap.put(id, info);
        this.operations.add(info);
        return info;
    }

    public void unlock(NodeImpl node) throws LockException, RepositoryException {
        NodeId id = node.getNodeId();
        LockInfo info = this.lockedNodesMap.get(id);
        if (info != null) {
            this.lockedNodesMap.remove(id);
            this.operations.remove(info);
            info.setLive(false);
        } else {
            info = this.getLockInfo(node);
            if (info == null || !info.getId().equals(id)) {
                throw new LockException("Node not locked.");
            }
            if (!info.isLockHolder(node.getSession())) {
                throw new LockException("Node not locked by this session.");
            }
            XALockInfo xaInfo = new XALockInfo(node, info);
            this.unlockedNodesMap.put(id, xaInfo);
            this.operations.add(xaInfo);
        }
    }

    public boolean isLocked(NodeImpl node) throws RepositoryException {
        return this.getLockInfo(node) != null;
    }

    public LockInfo getLockInfo(NodeImpl node) throws RepositoryException {
        NodeId id = node.getNodeId();
        if (this.unlockedNodesMap.containsKey(id)) {
            return null;
        }
        if (!this.lockedNodesMap.isEmpty()) {
            NodeImpl current = node;
            while (true) {
                XALockInfo info;
                if ((info = this.lockedNodesMap.get(current.getId())) != null) {
                    if (!info.getId().equals(id) && !info.isDeep()) break;
                    return info;
                }
                if (current.getDepth() == 0) break;
                current = (NodeImpl)current.getParent();
            }
        }
        return this.lockMgr.getLockInfo(id);
    }

    public LockInfo[] getLockInfos(SessionImpl session) throws RepositoryException {
        ArrayList<LockInfo> result = new ArrayList<LockInfo>();
        for (LockInfo info : this.lockMgr.getLockInfos(session)) {
            if (this.unlockedNodesMap.containsKey(info.getId())) continue;
            result.add(info);
        }
        result.addAll(this.lockedNodesMap.values());
        return result.toArray(new LockInfo[result.size()]);
    }

    public void addLockToken(SessionImpl session, String lt) throws RepositoryException {
        try {
            NodeId id = LockInfo.parseLockToken(lt);
            NodeImpl node = (NodeImpl)session.getItemManager().getItem(id);
            LockInfo info = this.getLockInfo(node);
            if (info != null && !info.isLockHolder(session)) {
                if (info.getLockHolder() == null) {
                    info.setLockHolder(session);
                } else {
                    String msg = "Cannot add lock token: lock already held by other session.";
                    log.warn(msg);
                    throw new LockException(msg);
                }
            }
            XAEnvironment.getSessionLockManager(session).lockTokenAdded(lt);
        }
        catch (IllegalArgumentException e) {
            String msg = "Bad lock token: " + e.getMessage();
            log.warn(msg);
            throw new LockException(msg);
        }
    }

    public void removeLockToken(SessionImpl session, String lt) throws RepositoryException {
        try {
            NodeId id = LockInfo.parseLockToken(lt);
            NodeImpl node = (NodeImpl)session.getItemManager().getItem(id);
            LockInfo info = this.getLockInfo(node);
            if (info != null) {
                if (info.isLockHolder(session)) {
                    info.setLockHolder(null);
                } else if (info.getLockHolder() != null) {
                    String msg = "Cannot remove lock token: lock held by other session.";
                    log.warn(msg);
                    throw new LockException(msg);
                }
            }
            XAEnvironment.getSessionLockManager(session).lockTokenRemoved(lt);
        }
        catch (IllegalArgumentException e) {
            String msg = "Bad lock token: " + e.getMessage();
            log.warn(msg);
            throw new LockException(msg);
        }
    }

    static SessionLockManager getSessionLockManager(SessionImpl session) throws RepositoryException {
        Workspace wsp = session.getWorkspace();
        return (SessionLockManager)wsp.getLockManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws TransactionException {
        this.status = 1;
        if (!this.operations.isEmpty()) {
            XALockInfo info;
            this.lockMgr.beginUpdate();
            try {
                while (this.opIndex < this.operations.size()) {
                    try {
                        info = this.operations.get(this.opIndex);
                        info.update();
                    }
                    catch (RepositoryException e) {
                        throw new TransactionException("Unable to update.", e);
                    }
                    ++this.opIndex;
                }
            }
            finally {
                if (this.opIndex < this.operations.size()) {
                    while (this.opIndex > 0) {
                        try {
                            info = this.operations.get(this.opIndex - 1);
                            info.undo();
                        }
                        catch (RepositoryException e) {
                            log.error("Unable to undo lock operation.", e);
                        }
                        --this.opIndex;
                    }
                    this.lockMgr.cancelUpdate();
                }
            }
        }
        this.status = 2;
    }

    public void commit() {
        int oldStatus = this.status;
        this.status = 3;
        if (oldStatus == 2 && !this.operations.isEmpty()) {
            this.lockMgr.endUpdate();
            this.reset();
        }
        this.status = 4;
    }

    public void rollback() {
        int oldStatus = this.status;
        this.status = 5;
        if (oldStatus == 2 && !this.operations.isEmpty()) {
            while (this.opIndex > 0) {
                try {
                    XALockInfo info = this.operations.get(this.opIndex - 1);
                    info.undo();
                }
                catch (RepositoryException e) {
                    log.error("Unable to undo lock operation.", e);
                }
                --this.opIndex;
            }
            this.lockMgr.cancelUpdate();
            this.reset();
        }
        this.status = 6;
    }

    public boolean differentXAEnv(LockInfo info) {
        if (info instanceof XALockInfo) {
            XALockInfo lockInfo = (XALockInfo)info;
            return lockInfo.getXAEnv() != this;
        }
        return true;
    }

    class XALockInfo
    extends LockInfo {
        private final NodeImpl node;
        private boolean isUnlock;

        public XALockInfo(NodeImpl node, boolean sessionScoped, boolean deep, String lockOwner) {
            super(node.getNodeId(), sessionScoped, deep, lockOwner, Long.MAX_VALUE);
            this.node = node;
        }

        public XALockInfo(NodeImpl node, LockInfo info) {
            super(info);
            this.node = node;
            this.isUnlock = true;
        }

        public boolean isUnlock() {
            return this.isUnlock;
        }

        public void update() throws LockException, RepositoryException {
            if (this.isUnlock) {
                if (((XAWorkspace)((SessionImpl)this.node.getSession()).getWorkspace()).getItemStateManager().hasItemState(this.node.getId())) {
                    XAEnvironment.this.lockMgr.internalUnlock(this.node);
                }
            } else {
                LockInfo internalLock = XAEnvironment.this.lockMgr.internalLock(this.node, this.isDeep(), this.isSessionScoped(), this.getTimeoutTime(), this.getLockOwner());
                LockInfo xaEnvLock = XAEnvironment.this.getLockInfo(this.node);
                if (xaEnvLock != null && xaEnvLock.getLockHolder() == null) {
                    XAEnvironment.getSessionLockManager(internalLock.getLockHolder()).lockTokenRemoved(internalLock.getLockToken());
                    internalLock.setLockHolder(null);
                }
            }
        }

        public void undo() throws LockException, RepositoryException {
            if (this.isUnlock) {
                XAEnvironment.this.lockMgr.internalLock(this.node, this.isDeep(), this.isSessionScoped(), this.getTimeoutHint(), this.getLockOwner());
            } else {
                XAEnvironment.this.lockMgr.internalUnlock(this.node);
            }
        }

        public XAEnvironment getXAEnv() {
            return XAEnvironment.this;
        }

        public boolean mayChange() {
            if (XAEnvironment.this.status != 4 && XAEnvironment.this.status != 6) {
                return true;
            }
            return super.mayChange();
        }
    }
}

