/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.observation;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventListener;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.observation.EventFilter;
import org.apache.jackrabbit.core.observation.EventState;
import org.apache.jackrabbit.core.observation.EventStateCollection;
import org.apache.jackrabbit.core.observation.FilteredEventIterator;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EventConsumer {
    private static final Logger log = LoggerFactory.getLogger(EventConsumer.class);
    private final PathFactory pathFactory = PathFactoryImpl.getInstance();
    private final SessionImpl session;
    private final EventListener listener;
    private final EventFilter filter;
    private final Map<EventStateCollection, Set<ItemId>> accessDenied = Collections.synchronizedMap(new WeakHashMap());
    private int hashCode;

    EventConsumer(SessionImpl session, EventListener listener, EventFilter filter) throws NullPointerException {
        if (session == null) {
            throw new NullPointerException("session");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (filter == null) {
            throw new NullPointerException("filter");
        }
        this.session = session;
        this.listener = listener;
        this.filter = filter;
    }

    Session getSession() {
        return this.session;
    }

    EventListener getEventListener() {
        return this.listener;
    }

    void prepareEvents(EventStateCollection events) {
        Iterator<EventState> it = events.iterator();
        HashSet<ItemId> denied = null;
        while (it.hasNext()) {
            EventState state = it.next();
            if (state.getType() != 2 && state.getType() != 8 || this.session.equals(state.getSession())) continue;
            ItemId targetId = state.getTargetId();
            boolean granted = false;
            try {
                granted = this.canRead(state);
            }
            catch (RepositoryException e) {
                log.warn("Unable to check access rights for item: " + targetId);
            }
            if (granted) continue;
            if (denied == null) {
                denied = new HashSet<ItemId>();
            }
            denied.add(targetId);
        }
        if (denied != null) {
            this.accessDenied.put(events, denied);
        }
    }

    void prepareDeleted(EventStateCollection events, Iterable<ItemState> deletedItems) {
        HashSet<ItemId> denied = null;
        HashSet<ItemId> deletedIds = new HashSet<ItemId>();
        for (ItemState state : deletedItems) {
            deletedIds.add(state.getId());
        }
        Iterator<EventState> it = events.iterator();
        while (it.hasNext()) {
            EventState evState = it.next();
            ItemId targetId = evState.getTargetId();
            if (!deletedIds.contains(targetId)) continue;
            boolean granted = false;
            try {
                granted = this.canRead(evState);
            }
            catch (RepositoryException e) {
                log.warn("Unable to check access rights for item: " + targetId);
            }
            if (granted) continue;
            if (denied == null) {
                denied = new HashSet<ItemId>();
            }
            denied.add(targetId);
        }
        if (denied != null) {
            this.accessDenied.put(events, denied);
        }
    }

    void consumeEvents(EventStateCollection events) throws RepositoryException {
        Set<ItemId> denied = this.accessDenied.remove(events);
        FilteredEventIterator it = events.iterator();
        while (it.hasNext() && this.session.isLive()) {
            EventState state = it.next();
            if (state.getType() != 1 && state.getType() != 4 && state.getType() != 16) continue;
            ItemId targetId = state.getTargetId();
            if (this.canRead(state)) continue;
            if (denied == null) {
                denied = new HashSet<ItemId>();
            }
            denied.add(targetId);
        }
        if (!this.session.isLive()) {
            return;
        }
        it = new FilteredEventIterator(events.iterator(), events.getTimestamp(), events.getUserData(), this.filter, denied);
        if (it.hasNext()) {
            long time = System.currentTimeMillis();
            this.listener.onEvent(it);
            time = System.currentTimeMillis() - time;
            if (log.isDebugEnabled()) {
                log.debug("listener {} processed events in {} ms.", (Object)this.listener.getClass().getName(), (Object)time);
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EventConsumer) {
            EventConsumer other = (EventConsumer)obj;
            return this.session.equals(other.session) && this.listener.equals(other.listener);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.session.hashCode() ^ this.listener.hashCode();
        }
        return this.hashCode;
    }

    private boolean canRead(EventState eventState) throws RepositoryException {
        Path targetPath = this.pathFactory.create(eventState.getParentPath(), eventState.getChildRelPath().getName(), eventState.getChildRelPath().getNormalizedIndex(), true);
        return this.session.getAccessManager().canRead(targetPath);
    }
}

