/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.observation;

import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.observation.EventJournal;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.EventListenerIterator;
import javax.jcr.observation.ObservationManager;
import javax.security.auth.Subject;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.cluster.ClusterNode;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.core.observation.EventConsumer;
import org.apache.jackrabbit.core.observation.EventFilter;
import org.apache.jackrabbit.core.observation.EventJournalImpl;
import org.apache.jackrabbit.core.observation.EventListenerIteratorImpl;
import org.apache.jackrabbit.core.observation.EventStateCollection;
import org.apache.jackrabbit.core.observation.EventStateCollectionFactory;
import org.apache.jackrabbit.core.observation.ObservationDispatcher;
import org.apache.jackrabbit.core.security.principal.AdminPrincipal;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObservationManagerImpl
implements ObservationManager,
EventStateCollectionFactory {
    private static final Logger log = LoggerFactory.getLogger(ObservationManagerImpl.class);
    private final SessionImpl session;
    private final ItemManager itemMgr;
    private final ClusterNode clusterNode;
    private final ObservationDispatcher dispatcher;
    private String userData;

    public ObservationManagerImpl(ObservationDispatcher dispatcher, SessionImpl session, ItemManager itemMgr, ClusterNode clusterNode) {
        if (dispatcher == null) {
            throw new NullPointerException("dispatcher");
        }
        if (session == null) {
            throw new NullPointerException("session");
        }
        if (itemMgr == null) {
            throw new NullPointerException("itemMgr");
        }
        this.dispatcher = dispatcher;
        this.session = session;
        this.itemMgr = itemMgr;
        this.clusterNode = clusterNode;
    }

    public void addEventListener(EventListener listener, int eventTypes, String absPath, boolean isDeep, String[] uuid, String[] nodeTypeName, boolean noLocal) throws RepositoryException {
        EventFilter filter = this.createEventFilter(eventTypes, absPath, isDeep, uuid, nodeTypeName, noLocal);
        this.dispatcher.addConsumer(new EventConsumer(this.session, listener, filter));
    }

    public void removeEventListener(EventListener listener) throws RepositoryException {
        this.dispatcher.removeConsumer(new EventConsumer(this.session, listener, EventFilter.BLOCK_ALL));
    }

    public EventListenerIterator getRegisteredEventListeners() throws RepositoryException {
        return new EventListenerIteratorImpl(this.session, this.dispatcher.getSynchronousConsumers(), this.dispatcher.getAsynchronousConsumers());
    }

    public void setUserData(String userData) throws RepositoryException {
        this.userData = userData;
    }

    String getUserData() {
        return this.userData;
    }

    public void dispose() {
        try {
            EventListenerIterator it = this.getRegisteredEventListeners();
            while (it.hasNext()) {
                EventListener l = it.nextEventListener();
                log.debug("removing EventListener: " + l);
                this.removeEventListener(l);
            }
        }
        catch (RepositoryException e) {
            log.error("Internal error: Unable to dispose ObservationManager.", e);
        }
    }

    public EventFilter createEventFilter(int eventTypes, String absPath, boolean isDeep, String[] uuid, String[] nodeTypeName, boolean noLocal) throws RepositoryException {
        Path path;
        NodeTypeImpl[] nodeTypes;
        if (nodeTypeName == null) {
            nodeTypes = null;
        } else {
            NodeTypeManagerImpl ntMgr = this.session.getNodeTypeManager();
            nodeTypes = new NodeTypeImpl[nodeTypeName.length];
            for (int i = 0; i < nodeTypes.length; ++i) {
                nodeTypes[i] = (NodeTypeImpl)ntMgr.getNodeType(nodeTypeName[i]);
            }
        }
        try {
            path = this.session.getQPath(absPath).getNormalizedPath();
        }
        catch (NameException e) {
            String msg = "invalid path syntax: " + absPath;
            log.debug(msg);
            throw new RepositoryException(msg, e);
        }
        if (!path.isAbsolute()) {
            throw new RepositoryException("absPath must be absolute");
        }
        NodeId[] ids = null;
        if (uuid != null) {
            ids = new NodeId[uuid.length];
            for (int i = 0; i < uuid.length; ++i) {
                ids[i] = NodeId.valueOf(uuid[i]);
            }
        }
        return new EventFilter(this.itemMgr, this.session, eventTypes, path, isDeep, ids, nodeTypes, noLocal);
    }

    public EventJournal getEventJournal(int eventTypes, String absPath, boolean isDeep, String[] uuid, String[] nodeTypeName) throws RepositoryException {
        if (this.clusterNode == null) {
            throw new UnsupportedRepositoryOperationException("Event journal is only available in cluster deployments");
        }
        Subject subject = this.session.getSubject();
        if (subject.getPrincipals(AdminPrincipal.class).isEmpty()) {
            throw new RepositoryException("Only administrator session may access EventJournal");
        }
        ObservationManagerImpl obsMgr = (ObservationManagerImpl)this.session.getWorkspace().getObservationManager();
        EventFilter filter = obsMgr.createEventFilter(eventTypes, absPath, isDeep, uuid, nodeTypeName, false);
        return new EventJournalImpl(filter, this.clusterNode.getJournal(), this.clusterNode.getId());
    }

    public EventJournal getEventJournal() throws RepositoryException {
        return this.getEventJournal(-1, "/", true, null, null);
    }

    public EventStateCollection createEventStateCollection() {
        EventStateCollection esc = new EventStateCollection(this.dispatcher, this.session, null);
        esc.setUserData(this.userData);
        return esc;
    }

    static {
        EventListenerIteratorImpl.class.hashCode();
    }
}

