/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.jackrabbit.core.persistence.bundle.ConnectionRecoveryManager;
import org.apache.jackrabbit.core.persistence.bundle.DbNameIndex;

public class PostgreSQLNameIndex
extends DbNameIndex {
    protected String generatedKeySelectSQL;

    public PostgreSQLNameIndex(ConnectionRecoveryManager conMgr, String schemaObjectPrefix) throws SQLException {
        super(conMgr, schemaObjectPrefix);
    }

    protected void init(String schemaObjectPrefix) throws SQLException {
        this.nameSelectSQL = "select NAME from " + schemaObjectPrefix + "NAMES where ID = ?";
        this.indexSelectSQL = "select ID from " + schemaObjectPrefix + "NAMES where NAME = ?";
        this.nameInsertSQL = "insert into " + schemaObjectPrefix + "NAMES (NAME) values (?)";
        this.generatedKeySelectSQL = "select currval('" + schemaObjectPrefix + "NAMES_ID_SEQ')";
    }

    protected int insertString(String string) {
        try {
            this.connectionManager.executeStmt(this.nameInsertSQL, new Object[]{string});
            return this.getGeneratedKey();
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException("Unable to insert index for string: " + string);
            ise.initCause(e);
            throw ise;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int getGeneratedKey() {
        try {
            ResultSet rs = this.connectionManager.executeQuery(this.generatedKeySelectSQL);
            try {
                if (!rs.next()) {
                    int n = -1;
                    return n;
                }
                int n = rs.getInt(1);
                return n;
            }
            finally {
                rs.close();
            }
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException("Unable to read generated index");
            ise.initCause(e);
            throw ise;
        }
    }
}

