/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.core.query.lucene.MultiIndexReader;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreDocComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractScoreDocComparator
implements ScoreDocComparator {
    protected final List<IndexReader> readers = new ArrayList<IndexReader>();
    protected final int[] starts;

    public AbstractScoreDocComparator(IndexReader reader) throws IOException {
        AbstractScoreDocComparator.getIndexReaders(this.readers, reader);
        int maxDoc = 0;
        this.starts = new int[this.readers.size() + 1];
        for (int i = 0; i < this.readers.size(); ++i) {
            IndexReader r = this.readers.get(i);
            this.starts[i] = maxDoc;
            maxDoc += r.maxDoc();
        }
        this.starts[this.readers.size()] = maxDoc;
    }

    @Override
    public int compare(ScoreDoc i, ScoreDoc j) {
        return Util.compare(this.sortValue(i), this.sortValue(j));
    }

    @Override
    public int sortType() {
        return 9;
    }

    protected int readerIndex(int n) {
        int lo = 0;
        int hi = this.readers.size() - 1;
        while (hi >= lo) {
            int mid = lo + hi >> 1;
            int midValue = this.starts[mid];
            if (n < midValue) {
                hi = mid - 1;
                continue;
            }
            if (n > midValue) {
                lo = mid + 1;
                continue;
            }
            while (mid + 1 < this.readers.size() && this.starts[mid + 1] == midValue) {
                ++mid;
            }
            return mid;
        }
        return hi;
    }

    private static void getIndexReaders(List<IndexReader> readers, IndexReader reader) {
        if (reader instanceof MultiIndexReader) {
            for (IndexReader r : ((MultiIndexReader)((Object)reader)).getIndexReaders()) {
                AbstractScoreDocComparator.getIndexReaders(readers, r);
            }
        } else {
            readers.add(reader);
        }
    }
}

