/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.html.HtmlParser;
import org.apache.tika.parser.image.ImageParser;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.parser.odf.OpenDocumentParser;
import org.apache.tika.parser.pdf.PDFParser;
import org.apache.tika.parser.rtf.RTFParser;
import org.apache.tika.parser.txt.TXTParser;
import org.apache.tika.parser.xml.XMLParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

class JackrabbitParser
implements Parser {
    private static final Logger logger = LoggerFactory.getLogger(JackrabbitParser.class);
    private static volatile boolean blocked = false;
    private final AutoDetectParser parser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JackrabbitParser() {
        InputStream stream = JackrabbitParser.class.getResourceAsStream("tika-config.xml");
        try {
            try {
                this.parser = new AutoDetectParser(new TikaConfig(stream));
            }
            finally {
                stream.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load embedded Tika configuration", e);
        }
    }

    public void setTextFilterClasses(String classes) {
        HashMap<String, Parser> parsers = new HashMap<String, Parser>();
        StringTokenizer tokenizer = new StringTokenizer(classes, ", \t\n\r\f");
        while (tokenizer.hasMoreTokens()) {
            Parser parser;
            String name = tokenizer.nextToken();
            if (name.equals("org.apache.jackrabbit.extractor.HTMLTextExtractor")) {
                parsers.put("text/html", new HtmlParser());
                continue;
            }
            if (name.equals("org.apache.jackrabbit.extractor.MsExcelTextExtractor")) {
                parser = new OfficeParser();
                parsers.put("application/vnd.ms-excel", parser);
                parsers.put("application/msexcel", parser);
                parsers.put("application/excel", parser);
                continue;
            }
            if (name.equals("org.apache.jackrabbit.extractor.MsOutlookTextExtractor")) {
                parsers.put("application/vnd.ms-outlook", new OfficeParser());
                continue;
            }
            if (name.equals("org.apache.jackrabbit.extractor.MsPowerPointExtractor")) {
                parser = new OfficeParser();
                parsers.put("application/vnd.ms-powerpoint", parser);
                parsers.put("application/mspowerpoint", parser);
                parsers.put("application/powerpoint", parser);
                continue;
            }
            if (name.equals("org.apache.jackrabbit.extractor.MsWordTextExtractor")) {
                parser = new OfficeParser();
                parsers.put("application/vnd.ms-word", parser);
                parsers.put("application/msword", parser);
                continue;
            }
            if (name.equals("org.apache.jackrabbit.extractor.MsTextExtractor")) {
                parser = new OfficeParser();
                parsers.put("application/vnd.ms-word", parser);
                parsers.put("application/msword", parser);
                parsers.put("application/vnd.ms-powerpoint", parser);
                parsers.put("application/mspowerpoint", parser);
                parsers.put("application/vnd.ms-excel", parser);
                parsers.put("application/vnd.openxmlformats-officedocument.wordprocessingml.document", parser);
                parsers.put("application/vnd.openxmlformats-officedocument.presentationml.presentation", parser);
                parsers.put("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", parser);
                continue;
            }
            if (name.equals("org.apache.jackrabbit.extractor.OpenOfficeTextExtractor")) {
                parser = new OpenDocumentParser();
                parsers.put("application/vnd.oasis.opendocument.database", parser);
                parsers.put("application/vnd.oasis.opendocument.formula", parser);
                parsers.put("application/vnd.oasis.opendocument.graphics", parser);
                parsers.put("application/vnd.oasis.opendocument.presentation", parser);
                parsers.put("application/vnd.oasis.opendocument.spreadsheet", parser);
                parsers.put("application/vnd.oasis.opendocument.text", parser);
                parsers.put("application/vnd.sun.xml.calc", parser);
                parsers.put("application/vnd.sun.xml.draw", parser);
                parsers.put("application/vnd.sun.xml.impress", parser);
                parsers.put("application/vnd.sun.xml.writer", parser);
                continue;
            }
            if (name.equals("org.apache.jackrabbit.extractor.PdfTextExtractor")) {
                parsers.put("application/pdf", new PDFParser());
                continue;
            }
            if (name.equals("org.apache.jackrabbit.extractor.PlainTextExtractor")) {
                parsers.put("text/plain", new TXTParser());
                continue;
            }
            if (name.equals("org.apache.jackrabbit.extractor.PngTextExtractor")) {
                parser = new ImageParser();
                parsers.put("image/png", parser);
                parsers.put("image/apng", parser);
                parsers.put("image/mng", parser);
                continue;
            }
            if (name.equals("org.apache.jackrabbit.extractor.RTFTextExtractor")) {
                parser = new RTFParser();
                parsers.put("application/rtf", parser);
                parsers.put("text/rtf", parser);
                continue;
            }
            if (name.equals("org.apache.jackrabbit.extractor.XMLTextExtractor")) {
                parser = new XMLParser();
                parsers.put("application/xml", parser);
                parsers.put("text/xml", parser);
                continue;
            }
            logger.warn("Ignoring unknown text extractor class: {}", (Object)name);
        }
        this.parser.setParsers(parsers);
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        JackrabbitParser.waitIfBlocked();
        this.parser.parse(stream, handler, metadata, context);
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        this.parse(stream, handler, metadata, new ParseContext());
    }

    private static synchronized void waitIfBlocked() throws TikaException {
        try {
            while (blocked) {
                JackrabbitParser.class.wait();
            }
        }
        catch (InterruptedException e) {
            throw new TikaException("Text extraction block interrupted", e);
        }
    }

    static synchronized void block() {
        blocked = true;
    }

    static synchronized void unblock() {
        blocked = false;
        JackrabbitParser.class.notifyAll();
    }
}

