/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.InputStream;
import java.io.Reader;
import java.util.concurrent.Executor;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.AbstractField;
import org.apache.lucene.document.Field;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LazyTextExtractorField
extends AbstractField {
    private static final Logger log = LoggerFactory.getLogger(LazyTextExtractorField.class);
    private static final SAXException STOP = new SAXException("max field length reached");
    private volatile String extract = null;

    public LazyTextExtractorField(Parser parser, InternalValue value, Metadata metadata, Executor executor, boolean highlighting, int maxFieldLength) {
        super(FieldNames.FULLTEXT, highlighting ? Field.Store.YES : Field.Store.NO, Field.Index.ANALYZED, highlighting ? Field.TermVector.WITH_OFFSETS : Field.TermVector.NO);
        executor.execute(new ParsingTask(parser, value, metadata, maxFieldLength));
    }

    public synchronized String stringValue() {
        try {
            while (!this.isExtractorFinished()) {
                this.wait();
            }
            return this.extract;
        }
        catch (InterruptedException e) {
            log.error("Text extraction thread was interrupted", e);
            return "";
        }
    }

    public Reader readerValue() {
        return null;
    }

    public byte[] binaryValue() {
        return null;
    }

    public TokenStream tokenStreamValue() {
        return null;
    }

    public boolean isExtractorFinished() {
        return this.extract != null;
    }

    private synchronized void setExtractedText(String value) {
        this.extract = value;
        this.notify();
    }

    public void dispose() {
    }

    private class ParsingTask
    extends DefaultHandler
    implements Runnable {
        private final Parser parser;
        private final InternalValue value;
        private final Metadata metadata;
        private final int maxFieldLength;
        private final StringBuilder builder = new StringBuilder();

        public ParsingTask(Parser parser, InternalValue value, Metadata metadata, int maxFieldLength) {
            this.parser = parser;
            this.value = value;
            this.metadata = metadata;
            this.maxFieldLength = maxFieldLength;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                InputStream stream = this.value.getStream();
                try {
                    this.parser.parse(stream, this, this.metadata, new ParseContext());
                }
                finally {
                    stream.close();
                }
            }
            catch (Throwable t) {
                if (t != STOP) {
                    log.warn("Failed to extract text from a binary property", t);
                }
            }
            finally {
                this.value.discard();
            }
            LazyTextExtractorField.this.setExtractedText(this.builder.toString());
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.builder.append(ch, start, Math.min(length, this.maxFieldLength - this.builder.length()));
            if (this.builder.length() >= this.maxFieldLength) {
                throw STOP;
            }
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.characters(ch, start, length);
        }
    }
}

