/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.qom.Literal;
import javax.jcr.query.qom.StaticOperand;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.IndexFormatVersion;
import org.apache.jackrabbit.core.query.lucene.JackrabbitQueryParser;
import org.apache.jackrabbit.core.query.lucene.JackrabbitTermQuery;
import org.apache.jackrabbit.core.query.lucene.JoinQuery;
import org.apache.jackrabbit.core.query.lucene.LuceneQueryFactory;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQuery;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQueryAdapter;
import org.apache.jackrabbit.core.query.lucene.NamePathResolverImpl;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.SynonymProvider;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.query.qom.BindVariableValueImpl;
import org.apache.jackrabbit.spi.commons.query.qom.DefaultQOMTreeVisitor;
import org.apache.jackrabbit.spi.commons.query.qom.FullTextSearchImpl;
import org.apache.jackrabbit.spi.commons.query.qom.JoinConditionImpl;
import org.apache.jackrabbit.spi.commons.query.qom.JoinImpl;
import org.apache.jackrabbit.spi.commons.query.qom.PropertyExistenceImpl;
import org.apache.jackrabbit.spi.commons.query.qom.SelectorImpl;
import org.apache.jackrabbit.spi.commons.query.qom.SourceImpl;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortComparatorSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneQueryFactoryImpl
implements LuceneQueryFactory {
    private final SessionImpl session;
    private final SortComparatorSource scs;
    private final HierarchyManager hmgr;
    private final NamespaceMappings nsMappings;
    private final NamePathResolver npResolver;
    private final Analyzer analyzer;
    private final SynonymProvider synonymProvider;
    private final IndexFormatVersion version;
    private final Map<Name, Value> bindVariables;

    public LuceneQueryFactoryImpl(SessionImpl session, SortComparatorSource scs, HierarchyManager hmgr, NamespaceMappings nsMappings, Analyzer analyzer, SynonymProvider synonymProvider, IndexFormatVersion version, Map<Name, Value> bindVariables) {
        this.session = session;
        this.scs = scs;
        this.hmgr = hmgr;
        this.nsMappings = nsMappings;
        this.analyzer = analyzer;
        this.synonymProvider = synonymProvider;
        this.version = version;
        this.npResolver = NamePathResolverImpl.create(nsMappings);
        this.bindVariables = bindVariables;
    }

    @Override
    public Query create(SelectorImpl selector) throws RepositoryException {
        Query q;
        Term t;
        ArrayList<Term> terms = new ArrayList<Term>();
        String mixinTypesField = this.npResolver.getJCRName(NameConstants.JCR_MIXINTYPES);
        String primaryTypeField = this.npResolver.getJCRName(NameConstants.JCR_PRIMARYTYPE);
        NodeTypeManager ntMgr = this.session.getWorkspace().getNodeTypeManager();
        NodeTypeDefinition base = null;
        try {
            base = ntMgr.getNodeType(this.session.getJCRName(selector.getNodeTypeQName()));
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        if (base != null && base.isMixin()) {
            t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(mixinTypesField, this.npResolver.getJCRName(selector.getNodeTypeQName())));
            terms.add(t);
        } else {
            t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(primaryTypeField, this.npResolver.getJCRName(selector.getNodeTypeQName())));
            terms.add(t);
        }
        if (base != null) {
            NodeTypeIterator allTypes = ntMgr.getAllNodeTypes();
            while (allTypes.hasNext()) {
                NodeType nt = allTypes.nextNodeType();
                NodeType[] superTypes = nt.getSupertypes();
                if (!Arrays.asList(superTypes).contains(base)) continue;
                Name n = this.session.getQName(nt.getName());
                String ntName = this.nsMappings.translateName(n);
                Term t2 = nt.isMixin() ? new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(mixinTypesField, ntName)) : new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(primaryTypeField, ntName));
                terms.add(t2);
            }
        }
        if (terms.size() == 1) {
            q = new JackrabbitTermQuery((Term)terms.get(0));
        } else {
            BooleanQuery b = new BooleanQuery();
            for (Term term : terms) {
                b.add(new JackrabbitTermQuery(term), BooleanClause.Occur.SHOULD);
            }
            q = b;
        }
        return q;
    }

    @Override
    public Query create(FullTextSearchImpl fts) throws RepositoryException {
        String fieldname;
        if (fts.getPropertyName() == null) {
            fieldname = FieldNames.FULLTEXT;
        } else {
            Name propName = fts.getPropertyQName();
            StringBuffer tmp = new StringBuffer();
            tmp.append(this.nsMappings.getPrefix(propName.getNamespaceURI()));
            tmp.append(":").append("FULL:");
            tmp.append(propName.getLocalName());
            fieldname = tmp.toString();
        }
        JackrabbitQueryParser parser = new JackrabbitQueryParser(fieldname, this.analyzer, this.synonymProvider);
        try {
            StaticOperand expr = fts.getFullTextSearchExpression();
            if (expr instanceof Literal) {
                return ((QueryParser)parser).parse(((Literal)expr).getLiteralValue().getString());
            }
            if (expr instanceof BindVariableValueImpl) {
                Value value = this.bindVariables.get(((BindVariableValueImpl)expr).getBindVariableQName());
                if (value == null) {
                    throw new InvalidQueryException("Bind variable not bound");
                }
                return ((QueryParser)parser).parse(value.getString());
            }
            throw new RepositoryException("Unknown static operand type: " + expr);
        }
        catch (ParseException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public Query create(PropertyExistenceImpl prop) throws RepositoryException {
        String propName = this.npResolver.getJCRName(prop.getPropertyQName());
        return Util.createMatchAllQuery(propName, this.version);
    }

    @Override
    public MultiColumnQuery create(SourceImpl source) throws RepositoryException {
        try {
            return (MultiColumnQuery)source.accept(new DefaultQOMTreeVisitor(){

                public Object visit(JoinImpl node, Object data) throws Exception {
                    return LuceneQueryFactoryImpl.this.create(node);
                }

                public Object visit(SelectorImpl node, Object data) throws Exception {
                    return MultiColumnQueryAdapter.adapt(LuceneQueryFactoryImpl.this.create(node), node.getSelectorQName());
                }
            }, null);
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public MultiColumnQuery create(JoinImpl join) throws RepositoryException {
        MultiColumnQuery left = this.create((SourceImpl)join.getLeft());
        MultiColumnQuery right = this.create((SourceImpl)join.getRight());
        return new JoinQuery(left, right, join.getJoinTypeInstance(), (JoinConditionImpl)join.getJoinCondition(), this.scs, this.hmgr);
    }
}

