/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.util.LinkedHashMap;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.qom.QueryObjectModelFactory;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.query.PropertyTypeRegistry;
import org.apache.jackrabbit.core.query.lucene.AbstractQueryImpl;
import org.apache.jackrabbit.core.query.lucene.LuceneQueryBuilder;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.query.lucene.SingleColumnQueryResult;
import org.apache.jackrabbit.core.query.lucene.SpellSuggestion;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.nodetype.PropertyDefinitionImpl;
import org.apache.jackrabbit.spi.commons.query.AndQueryNode;
import org.apache.jackrabbit.spi.commons.query.DefaultQueryNodeVisitor;
import org.apache.jackrabbit.spi.commons.query.LocationStepQueryNode;
import org.apache.jackrabbit.spi.commons.query.NodeTypeQueryNode;
import org.apache.jackrabbit.spi.commons.query.OrderQueryNode;
import org.apache.jackrabbit.spi.commons.query.QueryNodeFactory;
import org.apache.jackrabbit.spi.commons.query.QueryParser;
import org.apache.jackrabbit.spi.commons.query.QueryRootNode;
import org.apache.jackrabbit.spi.commons.query.qom.ColumnImpl;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryImpl
extends AbstractQueryImpl {
    private static final Logger log = LoggerFactory.getLogger(QueryImpl.class);
    public static final Name DEFAULT_SELECTOR_NAME = NameFactoryImpl.getInstance().create("", "s");
    protected final QueryRootNode root;

    public QueryImpl(SessionImpl session, ItemManager itemMgr, SearchIndex index, PropertyTypeRegistry propReg, String statement, String language, QueryNodeFactory factory) throws InvalidQueryException {
        super(session, itemMgr, index, propReg);
        this.root = QueryParser.parse(statement, language, session, factory);
    }

    public QueryResult execute(long offset, long limit) throws RepositoryException {
        if (log.isDebugEnabled()) {
            log.debug("Executing query: \n" + this.root.dump());
        }
        Query query = LuceneQueryBuilder.createQuery(this.root, this.session, this.index.getContext().getItemStateManager(), this.index.getNamespaceMappings(), this.index.getTextAnalyzer(), this.propReg, this.index.getSynonymProvider(), this.index.getIndexFormatVersion());
        OrderQueryNode orderNode = this.root.getOrderNode();
        OrderQueryNode.OrderSpec[] orderSpecs = orderNode != null ? orderNode.getOrderSpecs() : new OrderQueryNode.OrderSpec[]{};
        Path[] orderProperties = new Path[orderSpecs.length];
        boolean[] ascSpecs = new boolean[orderSpecs.length];
        for (int i = 0; i < orderSpecs.length; ++i) {
            orderProperties[i] = orderSpecs[i].getPropertyPath();
            ascSpecs[i] = orderSpecs[i].isAscending();
        }
        return new SingleColumnQueryResult(this.index, this.itemMgr, this.session, this.session.getAccessManager(), this, query, new SpellSuggestion(this.index.getSpellChecker(), this.root), this.getColumns(), orderProperties, ascSpecs, orderProperties.length == 0 && this.getRespectDocumentOrder(), offset, limit);
    }

    protected ColumnImpl[] getColumns() throws RepositoryException {
        QueryObjectModelFactory qomFactory = this.session.getWorkspace().getQueryManager().getQOMFactory();
        LinkedHashMap<Name, ColumnImpl> columns = new LinkedHashMap<Name, ColumnImpl>();
        for (Name name : this.root.getSelectProperties()) {
            String pn = this.session.getJCRName(name);
            ColumnImpl col = (ColumnImpl)qomFactory.column(this.session.getJCRName(DEFAULT_SELECTOR_NAME), pn, pn);
            columns.put(name, col);
        }
        if (columns.size() == 0) {
            PropertyDefinition[] propDefs;
            LocationStepQueryNode[] steps = this.root.getLocationNode().getPathSteps();
            final Name[] ntName = new Name[1];
            steps[steps.length - 1].acceptOperands(new DefaultQueryNodeVisitor(){

                public Object visit(AndQueryNode node, Object data) throws RepositoryException {
                    return node.acceptOperands(this, data);
                }

                public Object visit(NodeTypeQueryNode node, Object data) {
                    ntName[0] = node.getValue();
                    return data;
                }
            }, null);
            if (ntName[0] == null) {
                ntName[0] = NameConstants.NT_BASE;
            }
            NodeTypeImpl nt = this.session.getNodeTypeManager().getNodeType(ntName[0]);
            for (PropertyDefinition pd : propDefs = nt.getPropertyDefinitions()) {
                QPropertyDefinition propDef = ((PropertyDefinitionImpl)pd).unwrap();
                if (propDef.definesResidual() || propDef.isMultiple()) continue;
                columns.put(propDef.getName(), this.columnForName(propDef.getName()));
            }
        }
        if (!columns.containsKey(NameConstants.JCR_PATH)) {
            columns.put(NameConstants.JCR_PATH, this.columnForName(NameConstants.JCR_PATH));
        }
        if (!columns.containsKey(NameConstants.JCR_SCORE)) {
            columns.put(NameConstants.JCR_SCORE, this.columnForName(NameConstants.JCR_SCORE));
        }
        return columns.values().toArray(new ColumnImpl[columns.size()]);
    }

    public boolean needsSystemTree() {
        return this.root.needsSystemTree();
    }

    protected ColumnImpl columnForName(Name propertyName) throws RepositoryException {
        QueryObjectModelFactory qomFactory = this.session.getWorkspace().getQueryManager().getQOMFactory();
        String name = this.session.getJCRName(propertyName);
        return (ColumnImpl)qomFactory.column(this.session.getJCRName(DEFAULT_SELECTOR_NAME), name, name);
    }
}

