/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.apache.jackrabbit.value.ValueHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AccessControlEntryImpl
implements JackrabbitAccessControlEntry {
    private final Privilege[] privileges;
    private final int privilegeBits;
    private final Principal principal;
    private final boolean allow;
    private final Map<String, Value> restrictions;
    private final ValueFactory valueFactory;
    private int hashCode = -1;

    protected AccessControlEntryImpl(Principal principal, Privilege[] privileges) throws AccessControlException {
        this(principal, privileges, true, null, null);
    }

    protected AccessControlEntryImpl(Principal principal, Privilege[] privileges, boolean isAllow, Map<String, Value> restrictions, ValueFactory valueFactory) throws AccessControlException {
        if (principal == null) {
            throw new IllegalArgumentException();
        }
        for (Privilege privilege : privileges) {
            if (!privilege.isAbstract()) continue;
            throw new AccessControlException("Privilege " + privilege + " is abstract.");
        }
        this.principal = principal;
        this.privileges = privileges;
        this.privilegeBits = PrivilegeRegistry.getBits(privileges);
        this.allow = isAllow;
        this.valueFactory = valueFactory;
        if (restrictions == null) {
            this.restrictions = Collections.emptyMap();
        } else {
            this.restrictions = new HashMap<String, Value>(restrictions.size());
            for (String key : restrictions.keySet()) {
                Value value = restrictions.get(key);
                value = ValueHelper.copy(value, valueFactory);
                this.restrictions.put(key, value);
            }
        }
    }

    public int getPrivilegeBits() {
        return this.privilegeBits;
    }

    protected int buildHashCode() {
        int h = 17;
        h = 37 * h + this.principal.getName().hashCode();
        h = 37 * h + this.privilegeBits;
        h = 37 * h + Boolean.valueOf(this.allow).hashCode();
        h = 37 * h + ((Object)this.restrictions).hashCode();
        return h;
    }

    @Override
    public Principal getPrincipal() {
        return this.principal;
    }

    @Override
    public Privilege[] getPrivileges() {
        return this.privileges;
    }

    @Override
    public boolean isAllow() {
        return this.allow;
    }

    @Override
    public String[] getRestrictionNames() {
        return this.restrictions.keySet().toArray(new String[this.restrictions.size()]);
    }

    @Override
    public Value getRestriction(String restrictionName) {
        if (this.restrictions.containsKey(restrictionName)) {
            return ValueHelper.copy(this.restrictions.get(restrictionName), this.valueFactory);
        }
        return null;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.buildHashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AccessControlEntryImpl) {
            AccessControlEntryImpl tmpl = (AccessControlEntryImpl)obj;
            return this.principal.getName().equals(tmpl.principal.getName()) && this.privilegeBits == tmpl.privilegeBits && this.allow == tmpl.allow && ((Object)this.restrictions).equals(tmpl.restrictions);
        }
        return false;
    }
}

