/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnmodifiableAccessControlList
implements JackrabbitAccessControlList {
    private final AccessControlEntry[] accessControlEntries;
    private final Map<String, Integer> restrictions;
    private final String path;

    public UnmodifiableAccessControlList(AccessControlList acl) throws RepositoryException {
        if (acl instanceof JackrabbitAccessControlList) {
            JackrabbitAccessControlList jAcl = (JackrabbitAccessControlList)acl;
            this.accessControlEntries = acl.getAccessControlEntries();
            this.path = jAcl.getPath();
            HashMap<String, Integer> r = new HashMap<String, Integer>();
            for (String name : jAcl.getRestrictionNames()) {
                r.put(name, jAcl.getRestrictionType(name));
            }
            this.restrictions = Collections.unmodifiableMap(r);
        } else {
            this.accessControlEntries = acl.getAccessControlEntries();
            this.path = null;
            this.restrictions = Collections.emptyMap();
        }
    }

    public UnmodifiableAccessControlList(List<AccessControlEntry> accessControlEntries) {
        this.accessControlEntries = accessControlEntries.toArray(new AccessControlEntry[accessControlEntries.size()]);
        this.path = null;
        this.restrictions = Collections.emptyMap();
    }

    @Override
    public AccessControlEntry[] getAccessControlEntries() throws RepositoryException {
        return this.accessControlEntries;
    }

    @Override
    public boolean addAccessControlEntry(Principal principal, Privilege[] privileges) throws AccessControlException, RepositoryException {
        throw new AccessControlException("Unmodifiable ACL. Use AccessControlManager#getApplicablePolicies in order to obtain an modifiable ACL.");
    }

    @Override
    public void removeAccessControlEntry(AccessControlEntry ace) throws AccessControlException, RepositoryException {
        throw new AccessControlException("Unmodifiable ACL. Use AccessControlManager#getApplicablePolicies in order to obtain an modifiable ACL.");
    }

    @Override
    public String[] getRestrictionNames() {
        return this.restrictions.keySet().toArray(new String[this.restrictions.size()]);
    }

    @Override
    public int getRestrictionType(String restrictionName) {
        if (this.restrictions.containsKey(restrictionName)) {
            return this.restrictions.get(restrictionName);
        }
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return this.accessControlEntries.length == 0;
    }

    @Override
    public int size() {
        return this.accessControlEntries.length;
    }

    @Override
    public boolean addEntry(Principal principal, Privilege[] privileges, boolean isAllow) throws AccessControlException {
        throw new AccessControlException("Unmodifiable ACL. Use AccessControlManager#getPolicy or #getApplicablePolicies in order to obtain an modifiable ACL.");
    }

    @Override
    public boolean addEntry(Principal principal, Privilege[] privileges, boolean isAllow, Map<String, Value> restrictions) throws AccessControlException {
        throw new AccessControlException("Unmodifiable ACL. Use AccessControlManager#getPolicy or #getApplicablePolicies in order to obtain an modifiable ACL.");
    }

    @Override
    public void orderBefore(AccessControlEntry srcEntry, AccessControlEntry destEntry) throws AccessControlException {
        throw new AccessControlException("Unmodifiable ACL. Use AccessControlManager#getPolicy or #getApplicablePolicy in order to obtain a modifiable ACL.");
    }

    @Override
    public String getPath() {
        return this.path;
    }
}

