/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.principalbased;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.observation.SynchronousEventListener;
import org.apache.jackrabbit.core.security.authorization.AbstractAccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.AbstractCompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.AccessControlConstants;
import org.apache.jackrabbit.core.security.authorization.AccessControlEditor;
import org.apache.jackrabbit.core.security.authorization.CompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.Permission;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.apache.jackrabbit.core.security.authorization.principalbased.ACLEditor;
import org.apache.jackrabbit.core.security.authorization.principalbased.ACLTemplate;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACLProvider
extends AbstractAccessControlProvider
implements AccessControlConstants {
    private static Logger log = LoggerFactory.getLogger(ACLProvider.class);
    private static final AccessControlPolicy effectivePolicy = EffectivePrincipalBasedPolicy.access$000();
    private ACLEditor editor;
    private NodeImpl acRoot;

    @Override
    public boolean isAcItem(Path absPath) throws RepositoryException {
        Path.Element[] elems;
        for (Path.Element elem : elems = absPath.getElements()) {
            if (!N_POLICY.equals(elem.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAcItem(ItemImpl item) throws RepositoryException {
        NodeImpl n = item.isNode() ? (NodeImpl)item : (NodeImpl)item.getParent();
        return n.isNodeType(NT_REP_ACL) || n.isNodeType(NT_REP_ACE);
    }

    @Override
    public void init(Session systemSession, Map configuration) throws RepositoryException {
        super.init(systemSession, configuration);
        NodeImpl root = (NodeImpl)this.session.getRootNode();
        if (root.hasNode(N_ACCESSCONTROL)) {
            this.acRoot = root.getNode(N_ACCESSCONTROL);
            if (!this.acRoot.isNodeType(NT_REP_ACCESS_CONTROL)) {
                throw new RepositoryException("Error while initializing Access Control Provider: Found ac-root to be wrong node type " + this.acRoot.getPrimaryNodeType().getName());
            }
        } else {
            this.acRoot = root.addNode(N_ACCESSCONTROL, NT_REP_ACCESS_CONTROL, null);
        }
        this.editor = new ACLEditor(this.session, this.resolver.getQPath(this.acRoot.getPath()));
        if (!configuration.containsKey("omit-default-permission")) {
            try {
                log.debug("Install initial permissions: ...");
                ValueFactory vf = this.session.getValueFactory();
                HashMap<String, Value> restrictions = new HashMap<String, Value>();
                restrictions.put(this.session.getJCRName(ACLTemplate.P_NODE_PATH), vf.createValue(root.getPath(), 8));
                restrictions.put(this.session.getJCRName(ACLTemplate.P_GLOB), vf.createValue("*"));
                PrincipalManager pMgr = this.session.getPrincipalManager();
                AccessControlManager acMgr = this.session.getAccessControlManager();
                String pName = "administrators";
                if (pMgr.hasPrincipal(pName)) {
                    Principal administrators = pMgr.getPrincipal(pName);
                    ACLProvider.installDefaultPermissions(administrators, new Privilege[]{acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}all")}, restrictions, this.editor);
                } else {
                    log.info("Administrators principal group is missing -> Not adding default permissions.");
                }
                ACLProvider.installDefaultPermissions(pMgr.getEveryone(), new Privilege[]{acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}read")}, restrictions, this.editor);
                this.session.save();
            }
            catch (RepositoryException e) {
                log.error("Failed to set-up minimal access control for root node of workspace " + this.session.getWorkspace().getName());
                this.session.getRootNode().refresh(false);
            }
        }
    }

    private static void installDefaultPermissions(Principal principal, Privilege[] privs, Map<String, Value> restrictions, AccessControlEditor editor) throws RepositoryException, AccessControlException {
        JackrabbitAccessControlPolicy[] acls = editor.editAccessControlPolicies(principal);
        if (acls.length > 0) {
            ACLTemplate acl = (ACLTemplate)acls[0];
            if (acl.isEmpty()) {
                acl.addEntry(principal, privs, true, restrictions);
                editor.setPolicy(acl.getPath(), acl);
            } else {
                log.debug("... policy for principal '" + principal.getName() + "' already present.");
            }
        } else {
            log.debug("... policy for principal  '" + principal.getName() + "'  already present.");
        }
    }

    @Override
    public AccessControlPolicy[] getEffectivePolicies(Path absPath) throws ItemNotFoundException, RepositoryException {
        return new AccessControlPolicy[]{effectivePolicy};
    }

    @Override
    public AccessControlEditor getEditor(Session editingSession) {
        this.checkInitialized();
        if (editingSession instanceof SessionImpl) {
            try {
                return new ACLEditor((SessionImpl)editingSession, this.session.getQPath(this.acRoot.getPath()));
            }
            catch (RepositoryException e) {
                log.error("Internal error: ", (Object)e.getMessage());
            }
        }
        log.debug("Unable to build access control editor " + ACLEditor.class.getName() + ".");
        return null;
    }

    @Override
    public CompiledPermissions compilePermissions(Set<Principal> principals) throws RepositoryException {
        this.checkInitialized();
        if (this.isAdminOrSystem(principals)) {
            return this.getAdminPermissions();
        }
        if (this.isReadOnly(principals)) {
            return this.getReadOnlyPermissions();
        }
        return new CompiledPermissionImpl(principals);
    }

    @Override
    public boolean canAccessRoot(Set<Principal> principals) throws RepositoryException {
        this.checkInitialized();
        if (this.isAdminOrSystem(principals)) {
            return true;
        }
        CompiledPermissionImpl cp = new CompiledPermissionImpl(principals, false);
        return cp.grants(PathFactoryImpl.getInstance().getRootPath(), 1);
    }

    private static final class EffectivePrincipalBasedPolicy
    implements AccessControlPolicy {
        private static EffectivePrincipalBasedPolicy INSTANCE = new EffectivePrincipalBasedPolicy();

        private EffectivePrincipalBasedPolicy() {
        }

        private static EffectivePrincipalBasedPolicy getInstance() {
            return INSTANCE;
        }

        static /* synthetic */ EffectivePrincipalBasedPolicy access$000() {
            return EffectivePrincipalBasedPolicy.getInstance();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompiledPermissionImpl
    extends AbstractCompiledPermissions
    implements SynchronousEventListener {
        private final Set<Principal> principals;
        private final Set<String> acPaths;
        private List<AccessControlEntry> entries;

        private CompiledPermissionImpl(Set<Principal> principals) throws RepositoryException {
            this(principals, true);
        }

        private CompiledPermissionImpl(Set<Principal> principals, boolean listenToEvents) throws RepositoryException {
            this.principals = principals;
            this.acPaths = new HashSet<String>(principals.size());
            this.entries = this.reload();
            if (listenToEvents) {
                int events = 31;
                String[] ntNames = new String[]{ACLProvider.this.session.getJCRName(AccessControlConstants.NT_REP_ACE)};
                ACLProvider.this.observationMgr.addEventListener(this, events, ACLProvider.this.acRoot.getPath(), true, null, ntNames, false);
            }
        }

        @Override
        protected synchronized AbstractCompiledPermissions.Result buildResult(Path absPath) throws RepositoryException {
            AbstractCompiledPermissions.Result result;
            if (!absPath.isAbsolute()) {
                throw new RepositoryException("Absolute path expected.");
            }
            boolean isAcItem = ACLProvider.this.isAcItem(absPath);
            String jcrPath = ACLProvider.this.session.getJCRPath(absPath);
            if (ACLProvider.this.session.itemExists(jcrPath)) {
                Item item = ACLProvider.this.session.getItem(jcrPath);
                result = this.getResult(item, item.getPath(), isAcItem);
            } else {
                result = this.getResult(null, jcrPath, isAcItem);
            }
            return result;
        }

        private AbstractCompiledPermissions.Result getResult(Item target, String targetPath, boolean isAcItem) throws RepositoryException {
            int allows = 0;
            int denies = 0;
            int allowPrivileges = 0;
            int denyPrivileges = 0;
            int parentAllows = 0;
            int parentDenies = 0;
            String parentPath = Text.getRelativeParent(targetPath, 1);
            for (AccessControlEntry entry : this.entries) {
                int permissions;
                boolean matches;
                if (!(entry instanceof ACLTemplate.Entry)) {
                    log.warn("Unexpected AccessControlEntry instance -> ignore");
                    continue;
                }
                ACLTemplate.Entry entr = (ACLTemplate.Entry)entry;
                int privs = entr.getPrivilegeBits();
                if (!"".equals(parentPath) && entr.matches(parentPath)) {
                    if (entr.isAllow()) {
                        parentAllows |= Permission.diff(privs, parentDenies);
                    } else {
                        parentDenies |= Permission.diff(privs, parentAllows);
                    }
                }
                if (!(matches = target != null ? entr.matches(target) : entr.matches(targetPath))) continue;
                if (entr.isAllow()) {
                    permissions = PrivilegeRegistry.calculatePermissions(allowPrivileges |= Permission.diff(privs, denyPrivileges), parentAllows, true, isAcItem);
                    allows |= Permission.diff(permissions, denies);
                    continue;
                }
                permissions = PrivilegeRegistry.calculatePermissions(denyPrivileges |= Permission.diff(privs, allowPrivileges), parentDenies, false, isAcItem);
                denies |= Permission.diff(permissions, allows);
            }
            return new AbstractCompiledPermissions.Result(allows, denies, allowPrivileges, denyPrivileges);
        }

        @Override
        public void close() {
            try {
                ACLProvider.this.observationMgr.removeEventListener(this);
            }
            catch (RepositoryException e) {
                log.debug("Unable to unregister listener: ", (Object)e.getMessage());
            }
            super.close();
        }

        @Override
        public synchronized void onEvent(EventIterator events) {
            try {
                boolean reload = false;
                while (events.hasNext() && !reload) {
                    Event ev = events.nextEvent();
                    String path = ev.getPath();
                    switch (ev.getType()) {
                        case 1: 
                        case 2: 
                        case 32: {
                            reload = this.acPaths.contains(Text.getRelativeParent(path, 2));
                            break;
                        }
                        case 4: 
                        case 8: 
                        case 16: {
                            reload = this.acPaths.contains(Text.getRelativeParent(path, 3));
                            break;
                        }
                    }
                }
                if (reload) {
                    this.clearCache();
                    this.entries = this.reload();
                }
            }
            catch (RepositoryException e) {
                log.warn("Internal error: ", (Object)e.getMessage());
            }
        }

        private List<AccessControlEntry> reload() throws RepositoryException {
            this.acPaths.clear();
            ArrayList<AccessControlEntry> allACEs = new ArrayList<AccessControlEntry>();
            for (Principal p : this.principals) {
                ACLTemplate acl = ACLProvider.this.editor.getACL(p);
                if (acl == null || acl.isEmpty()) {
                    this.acPaths.add(ACLProvider.this.editor.getPathToAcNode(p));
                    continue;
                }
                AccessControlEntry[] aces = acl.getAccessControlEntries();
                allACEs.addAll(Arrays.asList(aces));
                this.acPaths.add(acl.getPath());
            }
            return allACEs;
        }
    }
}

