/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.security.user.AuthorizableImpl;
import org.apache.jackrabbit.core.security.user.UserManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GroupImpl
extends AuthorizableImpl
implements org.apache.jackrabbit.api.security.user.Group {
    private static final Logger log = LoggerFactory.getLogger(GroupImpl.class);
    private Principal principal;

    protected GroupImpl(NodeImpl node, UserManagerImpl userManager) throws RepositoryException {
        super(node, userManager);
    }

    @Override
    public boolean isGroup() {
        return true;
    }

    @Override
    public Principal getPrincipal() throws RepositoryException {
        if (this.principal == null) {
            this.principal = new NodeBasedGroup(this.getPrincipalName());
        }
        return this.principal;
    }

    @Override
    public Iterator<Authorizable> getDeclaredMembers() throws RepositoryException {
        return this.getMembers(false, 3).iterator();
    }

    @Override
    public Iterator<Authorizable> getMembers() throws RepositoryException {
        return this.getMembers(true, 3).iterator();
    }

    @Override
    public boolean isMember(Authorizable authorizable) throws RepositoryException {
        if (authorizable == null || !(authorizable instanceof AuthorizableImpl) || this.getNode().isSame(((AuthorizableImpl)authorizable).getNode())) {
            return false;
        }
        String thisID = this.getID();
        AuthorizableImpl impl = (AuthorizableImpl)authorizable;
        Iterator<org.apache.jackrabbit.api.security.user.Group> it = impl.memberOf();
        while (it.hasNext()) {
            if (!thisID.equals(it.next().getID())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addMember(Authorizable authorizable) throws RepositoryException {
        Value[] values;
        if (authorizable == null || !(authorizable instanceof AuthorizableImpl)) {
            return false;
        }
        AuthorizableImpl authImpl = (AuthorizableImpl)authorizable;
        NodeImpl memberNode = authImpl.getNode();
        if (memberNode.isSame(this.getNode())) {
            String msg = "Attempt to add a Group as member of itself (" + this.getID() + ").";
            log.warn(msg);
            return false;
        }
        if (this.isCyclicMembership(authImpl)) {
            log.warn("Attempt to create circular group membership.");
            return false;
        }
        Value toAdd = this.getSession().getValueFactory().createValue(memberNode, true);
        NodeImpl node = this.getNode();
        if (node.hasProperty(P_MEMBERS)) {
            Value[] old;
            for (Value v : old = node.getProperty(P_MEMBERS).getValues()) {
                if (!v.equals(toAdd)) continue;
                log.debug("Authorizable " + authImpl + " is already member of " + this);
                return false;
            }
            values = new Value[old.length + 1];
            System.arraycopy(old, 0, values, 0, old.length);
        } else {
            values = new Value[1];
        }
        values[values.length - 1] = toAdd;
        this.userManager.setProtectedProperty(node, P_MEMBERS, values, 10);
        return true;
    }

    @Override
    public boolean removeMember(Authorizable authorizable) throws RepositoryException {
        if (!(authorizable instanceof AuthorizableImpl)) {
            return false;
        }
        NodeImpl node = this.getNode();
        if (!node.hasProperty(P_MEMBERS)) {
            log.debug("Group has no members -> cannot remove member " + authorizable.getID());
            return false;
        }
        Value toRemove = this.getSession().getValueFactory().createValue(((AuthorizableImpl)authorizable).getNode(), true);
        PropertyImpl property = node.getProperty(P_MEMBERS);
        ArrayList<Value> valList = new ArrayList<Value>(Arrays.asList(property.getValues()));
        if (valList.remove(toRemove)) {
            try {
                if (valList.isEmpty()) {
                    this.userManager.removeProtectedItem(property, node);
                } else {
                    Value[] values = valList.toArray(new Value[valList.size()]);
                    this.userManager.setProtectedProperty(node, P_MEMBERS, values);
                }
                return true;
            }
            catch (RepositoryException e) {
                node.refresh(false);
                throw e;
            }
        }
        log.debug("Authorizable " + authorizable.getID() + " was not member of " + this.getID());
        return false;
    }

    private Collection<Authorizable> getMembers(boolean includeIndirect, int type) throws RepositoryException {
        HashSet<Authorizable> members = new HashSet<Authorizable>();
        if (this.getNode().hasProperty(P_MEMBERS)) {
            Value[] vs;
            for (Value v : vs = this.getNode().getProperty(P_MEMBERS).getValues()) {
                try {
                    NodeImpl n = (NodeImpl)this.getSession().getNodeByIdentifier(v.getString());
                    if (n.isNodeType(NT_REP_GROUP)) {
                        org.apache.jackrabbit.api.security.user.Group group;
                        if (type == 1 || !members.add(group = this.userManager.createGroup(n)) || !includeIndirect) continue;
                        members.addAll(((GroupImpl)group).getMembers(true, type));
                        continue;
                    }
                    if (n.isNodeType(NT_REP_USER)) {
                        if (type == 2) continue;
                        User user = this.userManager.createUser(n);
                        members.add(user);
                        continue;
                    }
                    log.debug("Group member entry with invalid node type " + n.getPrimaryNodeType().getName() + " -> Not included in member set.");
                }
                catch (ItemNotFoundException e) {
                    log.debug("Authorizable node referenced by " + this.getID() + " doesn't exist any more -> Ignored from member list.");
                }
            }
        }
        return members;
    }

    private boolean isCyclicMembership(AuthorizableImpl newMember) throws RepositoryException {
        if (newMember.isGroup()) {
            GroupImpl gr = (GroupImpl)newMember;
            for (Authorizable member : gr.getMembers(true, 2)) {
                GroupImpl grMemberImpl = (GroupImpl)member;
                if (!this.getNode().getUUID().equals(grMemberImpl.getNode().getUUID())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeBasedGroup
    extends AuthorizableImpl.NodeBasedPrincipal
    implements Group {
        private Set<Principal> members;

        private NodeBasedGroup(String name) {
            super(name);
        }

        public boolean addMember(Principal user) {
            return false;
        }

        public boolean isMember(Principal member) {
            Collection<Principal> members = this.getMembers();
            if (members.contains(member)) {
                return true;
            }
            for (Principal p : members) {
                if (!(p instanceof Group) || !((Group)p).isMember(member)) continue;
                return true;
            }
            return false;
        }

        public boolean removeMember(Principal user) {
            return false;
        }

        public Enumeration<? extends Principal> members() {
            return Collections.enumeration(this.getMembers());
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            this.getMembers();
            stream.defaultWriteObject();
        }

        private Collection<Principal> getMembers() {
            if (this.members == null) {
                this.members = new HashSet<Principal>();
                try {
                    Iterator<Authorizable> it = GroupImpl.this.getMembers();
                    while (it.hasNext()) {
                        this.members.add(it.next().getPrincipal());
                    }
                }
                catch (RepositoryException e) {
                    log.error("Unable to retrieve Group members.");
                }
            }
            return this.members;
        }
    }
}

