/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.Impersonation;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.core.security.user.AuthorizableImpl;
import org.apache.jackrabbit.core.security.user.UserConstants;
import org.apache.jackrabbit.core.security.user.UserPerWorkspaceUserManager;
import org.apache.jackrabbit.core.util.ReferenceChangeTracker;
import org.apache.jackrabbit.core.xml.DefaultProtectedPropertyImporter;
import org.apache.jackrabbit.core.xml.PropInfo;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserImporter
extends DefaultProtectedPropertyImporter {
    private static final Logger log = LoggerFactory.getLogger(UserImporter.class);
    public static final String PARAM_IMPORT_BEHAVIOR = "importBehavior";
    private UserPerWorkspaceUserManager userManager;
    private boolean initialized = false;
    private boolean resetAutoSave = false;
    private int importBehavior = 1;

    public boolean init(JackrabbitSession session, NamePathResolver resolver, boolean isWorkspaceImport, int uuidBehavior, ReferenceChangeTracker referenceTracker) {
        if (super.init(session, resolver, isWorkspaceImport, uuidBehavior, referenceTracker)) {
            if (this.initialized) {
                throw new IllegalStateException("Already initialized");
            }
            if (uuidBehavior == 0) {
                log.debug("ImportUUIDBehavior.IMPORT_UUID_CREATE_NEW isn't supported when importing users or groups.");
                return false;
            }
            if (isWorkspaceImport) {
                log.debug("Only Session-Import is supported when importing users or groups.");
                return false;
            }
            try {
                UserManager uMgr = session.getUserManager();
                if (uMgr instanceof UserPerWorkspaceUserManager) {
                    if (uMgr.isAutoSave()) {
                        uMgr.autoSave(false);
                        this.resetAutoSave = true;
                        log.debug("Changed autosave behavior of UserManager to 'false'.");
                    }
                    this.userManager = (UserPerWorkspaceUserManager)uMgr;
                    this.initialized = true;
                } else {
                    log.debug("Failed to initialize UserImporter: UserManager isn't instance of UserPerWorkspaceUserManager or does implicit save call.");
                }
            }
            catch (RepositoryException e) {
                log.error("Failed to initialize UserImporter: ", e);
            }
        }
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handlePropInfo(NodeImpl parent, PropInfo protectedPropInfo, QPropertyDefinition def) throws RepositoryException {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized");
        }
        Authorizable a = this.userManager.getAuthorizable(parent);
        if (a == null) {
            log.debug("Cannot handle protected PropInfo " + protectedPropInfo + ". Node " + parent + " doesn't represent a valid Authorizable.");
            return false;
        }
        if (this.userManager.isAutoSave()) {
            this.userManager.autoSave(false);
        }
        try {
            Name propName = protectedPropInfo.getName();
            if (UserConstants.P_PRINCIPAL_NAME.equals(propName)) {
                if (def.isMultiple() || !UserConstants.NT_REP_AUTHORIZABLE.equals(def.getDeclaringNodeType())) {
                    log.warn("Unexpected definition for property rep:principalName");
                    boolean bl = false;
                    return bl;
                }
                Value v = protectedPropInfo.getValues(1, this.resolver)[0];
                String princName = v.getString();
                this.userManager.setPrincipal(parent, new PrincipalImpl(princName));
                boolean bl = true;
                return bl;
            }
            if (UserConstants.P_PASSWORD.equals(propName)) {
                if (a.isGroup()) {
                    log.warn("Expected parent node of type rep:User.");
                    boolean v = false;
                    return v;
                }
                if (def.isMultiple() || !UserConstants.NT_REP_USER.equals(def.getDeclaringNodeType())) {
                    log.warn("Unexpected definition for property rep:password");
                    boolean v = false;
                    return v;
                }
                Value v = protectedPropInfo.getValues(1, this.resolver)[0];
                ((User)a).changePassword(v.getString());
                boolean princName = true;
                return princName;
            }
            if (UserConstants.P_IMPERSONATORS.equals(propName)) {
                if (a.isGroup()) {
                    log.warn("Expected parent node of type rep:User.");
                    boolean v = false;
                    return v;
                }
                if (!def.isMultiple() || !UserConstants.MIX_REP_IMPERSONATABLE.equals(def.getDeclaringNodeType())) {
                    log.warn("Unexpected definition for property rep:impersonators");
                    boolean v = false;
                    return v;
                }
                Value[] vs = protectedPropInfo.getValues(1, this.resolver);
                this.referenceTracker.processedReference(new Impersonators(a.getID(), vs));
                boolean princName = true;
                return princName;
            }
            if (UserConstants.P_MEMBERS.equals(propName)) {
                if (!a.isGroup()) {
                    log.warn("Expected parent node of type rep:Group.");
                    boolean vs = false;
                    return vs;
                }
                if (!def.isMultiple() || !UserConstants.NT_REP_GROUP.equals(def.getDeclaringNodeType())) {
                    log.warn("Unexpected definition for property rep:members");
                    boolean vs = false;
                    return vs;
                }
                Value[] vs = protectedPropInfo.getValues(10, this.resolver);
                NodeId[] ids = new NodeId[vs.length];
                for (int i = 0; i < vs.length; ++i) {
                    ids[i] = new NodeId(vs[i].getString());
                }
                this.referenceTracker.processedReference(new Membership(a.getID(), ids));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.resetAutoSave) {
                this.userManager.autoSave(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    public void processReferences() throws RepositoryException {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.userManager.isAutoSave()) {
            this.userManager.autoSave(false);
        }
        try {
            ArrayList<Object> processed = new ArrayList<Object>();
            Iterator<Object> it = this.referenceTracker.getProcessedReferences();
            while (it.hasNext()) {
                ArrayList<Object> toAdd;
                HashMap<String, Object> toRemove;
                Authorizable a;
                Object reference = it.next();
                if (reference instanceof Membership) {
                    a = this.userManager.getAuthorizable(((Membership)reference).groupId);
                    if (a == null || !a.isGroup()) {
                        throw new RepositoryException(((Membership)reference).groupId + " does not represent a valid group.");
                    }
                    Group gr = (Group)a;
                    toRemove = new HashMap<String, Object>();
                    Iterator<Authorizable> declMembers = gr.getDeclaredMembers();
                    while (declMembers.hasNext()) {
                        Authorizable dm = declMembers.next();
                        toRemove.put(dm.getID(), dm);
                    }
                    toAdd = new ArrayList<Object>();
                    ArrayList<Value> nonExisting = new ArrayList<Value>();
                    for (NodeId originalId : ((Membership)reference).ids) {
                        NodeId remapped = this.referenceTracker.getMappedId(originalId);
                        NodeId id = remapped == null ? originalId : remapped;
                        Authorizable authorz = null;
                        try {
                            NodeImpl n = ((SessionImpl)this.session).getNodeById(id);
                            authorz = this.userManager.getAuthorizable(n);
                        }
                        catch (RepositoryException e) {
                            // empty catch block
                        }
                        if (authorz != null) {
                            if (toRemove.remove(authorz.getID()) != null) continue;
                            toAdd.add(authorz);
                            continue;
                        }
                        this.handleFailure("New member of " + gr + ": No such authorizable (NodeID = " + id + ")");
                        if (this.importBehavior != 2) continue;
                        log.info("ImportBehavior.BESTEFFORT: Remember non-existing member for processing.");
                        nonExisting.add(this.session.getValueFactory().createValue(id.toString(), 10));
                    }
                    for (Authorizable m : toRemove.values()) {
                        if (gr.removeMember(m)) continue;
                        this.handleFailure("Failed remove existing member (" + m + ") from " + gr);
                    }
                    for (Authorizable m : toAdd) {
                        if (gr.addMember(m)) continue;
                        this.handleFailure("Failed add member (" + m + ") to " + gr);
                    }
                    if (!nonExisting.isEmpty()) {
                        log.info("ImportBehavior.BESTEFFORT: Found " + nonExisting.size() + " entries of rep:members pointing to non-existing authorizables. Adding to rep:members.");
                        NodeImpl groupNode = ((AuthorizableImpl)((Object)gr)).getNode();
                        ArrayList<Value> memberValues = new ArrayList<Value>();
                        if (groupNode.hasProperty(UserConstants.P_MEMBERS)) {
                            Value[] vls = groupNode.getProperty(UserConstants.P_MEMBERS).getValues();
                            memberValues.addAll(Arrays.asList(vls));
                        }
                        memberValues.addAll(nonExisting);
                        this.userManager.setProtectedProperty(groupNode, UserConstants.P_MEMBERS, memberValues.toArray(new Value[memberValues.size()]), 10);
                    }
                    processed.add(reference);
                    continue;
                }
                if (!(reference instanceof Impersonators)) continue;
                a = this.userManager.getAuthorizable(((Impersonators)reference).userId);
                if (a == null || a.isGroup()) {
                    throw new RepositoryException(((Impersonators)reference).userId + " does not represent a valid user.");
                }
                Impersonation imp = ((User)a).getImpersonation();
                toRemove = new HashMap();
                PrincipalIterator pit = imp.getImpersonators();
                while (pit.hasNext()) {
                    Principal princ = pit.nextPrincipal();
                    toRemove.put(princ.getName(), princ);
                }
                toAdd = new ArrayList();
                Value[] vs = ((Impersonators)reference).values;
                for (Value v : vs) {
                    String princName = v.getString();
                    if (toRemove.remove(princName) != null) continue;
                    toAdd.add(new PrincipalImpl(princName));
                }
                for (Principal princ : toRemove.values()) {
                    if (imp.revokeImpersonation(princ)) continue;
                    this.handleFailure("Failed to revoke impersonation for " + princ.getName() + " on " + a);
                }
                for (Principal princ : toAdd) {
                    if (imp.grantImpersonation(princ)) continue;
                    this.handleFailure("Failed to grant impersonation for " + princ.getName() + " on " + a);
                }
                processed.add(reference);
            }
            this.referenceTracker.removeReferences(processed);
        }
        finally {
            if (this.resetAutoSave) {
                this.userManager.autoSave(true);
            }
        }
    }

    private void handleFailure(String msg) throws RepositoryException {
        switch (this.importBehavior) {
            case 1: 
            case 2: {
                log.warn(msg);
                break;
            }
            case 3: {
                throw new ConstraintViolationException(msg);
            }
        }
    }

    public String getImportBehavior() {
        return ImportBehavior.nameFromValue(this.importBehavior);
    }

    public void setImportBehavior(String importBehaviorStr) {
        this.importBehavior = ImportBehavior.valueFromName(importBehaviorStr);
    }

    public static final class ImportBehavior {
        public static final int IGNORE = 1;
        public static final int BESTEFFORT = 2;
        public static final int ABORT = 3;
        public static final String NAME_IGNORE = "ignore";
        public static final String NAME_BESTEFFORT = "besteffort";
        public static final String NAME_ABORT = "abort";

        public static int valueFromName(String behaviorString) {
            if (NAME_IGNORE.equalsIgnoreCase(behaviorString)) {
                return 1;
            }
            if (NAME_BESTEFFORT.equalsIgnoreCase(behaviorString)) {
                return 2;
            }
            if (NAME_ABORT.equalsIgnoreCase(behaviorString)) {
                return 3;
            }
            log.error("Invalid behavior " + behaviorString + " -> Using default: ABORT.");
            return 3;
        }

        public static String nameFromValue(int importBehavior) {
            switch (importBehavior) {
                case 1: {
                    return NAME_IGNORE;
                }
                case 3: {
                    return NAME_ABORT;
                }
                case 2: {
                    return NAME_BESTEFFORT;
                }
            }
            throw new IllegalArgumentException("Invalid import behavior: " + importBehavior);
        }
    }

    private final class Impersonators {
        private final String userId;
        private final Value[] values;

        private Impersonators(String userId, Value[] values) {
            this.userId = userId;
            this.values = values;
        }
    }

    private final class Membership {
        private final String groupId;
        private final NodeId[] ids;

        private Membership(String groupId, NodeId[] ids) {
            this.groupId = groupId;
            this.ids = ids;
        }
    }
}

