/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.api.security.principal.ItemBasedPrincipal;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.AuthorizableExistsException;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.ProtectedItemModifier;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.SessionListener;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.security.SystemPrincipal;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.core.security.user.AuthorizableImpl;
import org.apache.jackrabbit.core.security.user.GroupImpl;
import org.apache.jackrabbit.core.security.user.IndexNodeResolver;
import org.apache.jackrabbit.core.security.user.NodeResolver;
import org.apache.jackrabbit.core.security.user.TraversingNodeResolver;
import org.apache.jackrabbit.core.security.user.UserConstants;
import org.apache.jackrabbit.core.security.user.UserImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserManagerImpl
extends ProtectedItemModifier
implements UserManager,
UserConstants,
SessionListener {
    public static final String PARAM_USERS_PATH = "usersPath";
    public static final String PARAM_GROUPS_PATH = "groupsPath";
    public static final String PARAM_COMPATIBILE_JR16 = "compatibleJR16";
    public static final String PARAM_DEFAULT_DEPTH = "defaultDepth";
    public static final String PARAM_AUTO_EXPAND_TREE = "autoExpandTree";
    public static final String PARAM_AUTO_EXPAND_SIZE = "autoExpandSize";
    private static final Logger log = LoggerFactory.getLogger(UserManagerImpl.class);
    private final SessionImpl session;
    private final String adminId;
    private final NodeResolver authResolver;
    private final NodeCreator nodeCreator;
    private final String usersPath;
    private final String groupsPath;
    private final boolean compatibleJR16;
    private final boolean isSystemUserManager;

    public UserManagerImpl(SessionImpl session, String adminId) {
        this(session, adminId, null);
    }

    public UserManagerImpl(SessionImpl session, String adminId, Properties config) {
        NodeResolver nr;
        this.session = session;
        this.adminId = adminId;
        this.nodeCreator = new NodeCreator(config);
        Object param = config != null ? config.get(PARAM_USERS_PATH) : null;
        this.usersPath = param != null ? param.toString() : "/rep:security/rep:authorizables/rep:users";
        param = config != null ? config.get(PARAM_GROUPS_PATH) : null;
        this.groupsPath = param != null ? param.toString() : "/rep:security/rep:authorizables/rep:groups";
        param = config != null ? config.get(PARAM_COMPATIBILE_JR16) : null;
        this.compatibleJR16 = param != null && Boolean.parseBoolean(param.toString());
        try {
            nr = new IndexNodeResolver(session, session);
        }
        catch (RepositoryException e) {
            log.debug("UserManager: no QueryManager available for workspace '" + session.getWorkspace().getName() + "' -> Use traversing node resolver.");
            nr = new TraversingNodeResolver(session, session);
        }
        this.authResolver = nr;
        this.authResolver.setSearchRoots(this.usersPath, this.groupsPath);
        this.isSystemUserManager = "org.apache.jackrabbit.core.SystemSession".equals(session.getClass().getName()) && !session.getSubject().getPrincipals(SystemPrincipal.class).isEmpty();
    }

    public String getUsersPath() {
        return this.usersPath;
    }

    public String getGroupsPath() {
        return this.groupsPath;
    }

    @Override
    public Authorizable getAuthorizable(String id) throws RepositoryException {
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException("Invalid authorizable name '" + id + "'");
        }
        Authorizable a = this.internalGetAuthorizable(id);
        if (a == null && this.adminId.equals(id) && this.isSystemUserManager) {
            log.info("Admin user does not exist.");
            a = this.createAdmin();
        }
        return a;
    }

    @Override
    public Authorizable getAuthorizable(Principal principal) throws RepositoryException {
        NodeImpl n = null;
        if (principal instanceof ItemBasedPrincipal) {
            Item authItem;
            String authPath = ((ItemBasedPrincipal)principal).getPath();
            if (this.session.itemExists(authPath) && (authItem = this.session.getItem(authPath)).isNode()) {
                n = (NodeImpl)authItem;
            }
        } else {
            String name = principal.getName();
            try {
                Authorizable a = this.internalGetAuthorizable(name);
                if (a != null && name.equals(a.getPrincipal().getName())) {
                    return a;
                }
            }
            catch (RepositoryException e) {
                // empty catch block
            }
            n = (NodeImpl)this.authResolver.findNode(P_PRINCIPAL_NAME, name, NT_REP_AUTHORIZABLE);
        }
        return this.getAuthorizable(n);
    }

    @Override
    public Iterator<Authorizable> findAuthorizables(String propertyName, String value) throws RepositoryException {
        return this.findAuthorizables(propertyName, value, 3);
    }

    @Override
    public Iterator<Authorizable> findAuthorizables(String propertyName, String value, int searchType) throws RepositoryException {
        Name ntName;
        Name name = this.session.getQName(propertyName);
        switch (searchType) {
            case 3: {
                ntName = NT_REP_AUTHORIZABLE;
                break;
            }
            case 2: {
                ntName = NT_REP_GROUP;
                break;
            }
            case 1: {
                ntName = NT_REP_USER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid search type " + searchType);
            }
        }
        NodeIterator nodes = this.authResolver.findNodes(name, value, ntName, true);
        return new AuthorizableIterator(nodes);
    }

    @Override
    public User createUser(String userID, String password) throws RepositoryException {
        return this.createUser(userID, password, new PrincipalImpl(userID), null);
    }

    @Override
    public User createUser(String userID, String password, Principal principal, String intermediatePath) throws AuthorizableExistsException, RepositoryException {
        if (userID == null || userID.length() == 0) {
            throw new IllegalArgumentException("Cannot create user: UserID can neither be null nor empty String.");
        }
        if (password == null) {
            throw new IllegalArgumentException("Cannot create user: null password.");
        }
        if (this.internalGetAuthorizable(userID) != null) {
            throw new AuthorizableExistsException("User for '" + userID + "' already exists");
        }
        try {
            NodeImpl userNode = (NodeImpl)this.nodeCreator.createUserNode(userID, intermediatePath);
            this.setPrincipal(userNode, principal);
            this.setProperty(userNode, P_PASSWORD, this.getValue(UserImpl.buildPasswordValue(password)), true);
            User user = this.createUser(userNode);
            if (this.isAutoSave()) {
                this.session.save();
            }
            log.debug("User created: " + userID + "; " + userNode.getPath());
            return user;
        }
        catch (RepositoryException e) {
            this.session.refresh(false);
            log.debug("Failed to create new User, reverting changes.");
            throw e;
        }
    }

    @Override
    public Group createGroup(Principal principal) throws RepositoryException {
        return this.createGroup(principal, null);
    }

    @Override
    public Group createGroup(Principal principal, String intermediatePath) throws AuthorizableExistsException, RepositoryException {
        if (!UserManagerImpl.isValidPrincipal(principal)) {
            throw new IllegalArgumentException("Cannot create group: Principal may not be null and must have a valid name.");
        }
        try {
            String groupID = this.getGroupId(principal.getName());
            NodeImpl groupNode = (NodeImpl)this.nodeCreator.createGroupNode(groupID, intermediatePath);
            this.setPrincipal(groupNode, principal);
            Group group = this.createGroup(groupNode);
            if (this.isAutoSave()) {
                this.session.save();
            }
            log.debug("Group created: " + groupID + "; " + groupNode.getPath());
            return group;
        }
        catch (RepositoryException e) {
            this.session.refresh(false);
            log.debug("newInstance new Group failed, revert changes on parent");
            throw e;
        }
    }

    @Override
    public boolean isAutoSave() {
        return true;
    }

    @Override
    public void autoSave(boolean enable) throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException("Cannot change autosave behavior.");
    }

    void setPrincipal(NodeImpl node, Principal principal) throws AuthorizableExistsException, RepositoryException {
        if (!UserManagerImpl.isValidPrincipal(principal)) {
            throw new IllegalArgumentException("Cannot create Authorizable: Principal may not be null and must have a valid name.");
        }
        Authorizable existing = this.getAuthorizable(principal);
        if (existing != null && !((AuthorizableImpl)existing).getNode().isSame(node)) {
            throw new AuthorizableExistsException("Authorizable for '" + principal.getName() + "' already exists: ");
        }
        if (!node.isNew() || node.hasProperty(P_PRINCIPAL_NAME)) {
            throw new RepositoryException("rep:principalName can only be set once on a new node.");
        }
        this.setProperty(node, P_PRINCIPAL_NAME, this.getValue(principal.getName()), true);
    }

    void setProtectedProperty(NodeImpl node, Name propName, Value value) throws RepositoryException, LockException, ConstraintViolationException, ItemExistsException, VersionException {
        this.setProperty(node, propName, value);
        if (this.isAutoSave()) {
            node.save();
        }
    }

    void setProtectedProperty(NodeImpl node, Name propName, Value[] values) throws RepositoryException, LockException, ConstraintViolationException, ItemExistsException, VersionException {
        this.setProperty(node, propName, values);
        if (this.isAutoSave()) {
            node.save();
        }
    }

    void setProtectedProperty(NodeImpl node, Name propName, Value[] values, int type) throws RepositoryException, LockException, ConstraintViolationException, ItemExistsException, VersionException {
        this.setProperty(node, propName, values, type);
        if (this.isAutoSave()) {
            node.save();
        }
    }

    void removeProtectedItem(ItemImpl item, Node parent) throws RepositoryException, AccessDeniedException, VersionException {
        this.removeItem(item);
        if (this.isAutoSave()) {
            parent.save();
        }
    }

    Authorizable getAuthorizable(NodeImpl n) throws RepositoryException {
        Authorizable authorz = null;
        if (n != null) {
            String path = n.getPath();
            if (n.isNodeType(NT_REP_USER) && Text.isDescendant(this.usersPath, path)) {
                authorz = this.createUser(n);
            } else if (n.isNodeType(NT_REP_GROUP) && Text.isDescendant(this.groupsPath, path)) {
                authorz = this.createGroup(n);
            } else {
                log.debug("Unexpected user nodetype " + n.getPrimaryNodeType().getName());
            }
        }
        return authorz;
    }

    private String getGroupId(String principalName) throws RepositoryException {
        String groupID = principalName;
        int i = 0;
        while (this.internalGetAuthorizable(groupID) != null) {
            groupID = principalName + "_" + i;
            ++i;
        }
        return groupID;
    }

    private Authorizable internalGetAuthorizable(String id) throws RepositoryException {
        NodeImpl n;
        block2: {
            NodeId nodeId = this.buildNodeId(id);
            n = null;
            try {
                n = this.session.getNodeById(nodeId);
            }
            catch (ItemNotFoundException e) {
                if (!this.compatibleJR16 || (n = (NodeImpl)this.authResolver.findNode(P_USERID, id, NT_REP_USER)) != null) break block2;
                Name nodeName = this.session.getQName(Text.escapeIllegalJcrChars(id));
                n = (NodeImpl)this.authResolver.findNode(nodeName, NT_REP_GROUP);
            }
        }
        return this.getAuthorizable(n);
    }

    private Value getValue(String strValue) {
        return this.session.getValueFactory().createValue(strValue);
    }

    boolean isAdminId(String userID) {
        return this.adminId != null && this.adminId.equals(userID);
    }

    User createUser(NodeImpl userNode) throws RepositoryException {
        if (userNode == null || !userNode.isNodeType(NT_REP_USER)) {
            throw new IllegalArgumentException();
        }
        if (!Text.isDescendant(this.usersPath, userNode.getPath())) {
            throw new RepositoryException("User has to be within the User Path");
        }
        return this.doCreateUser(userNode);
    }

    protected User doCreateUser(NodeImpl node) throws RepositoryException {
        return new UserImpl(node, this);
    }

    Group createGroup(NodeImpl groupNode) throws RepositoryException {
        if (groupNode == null || !groupNode.isNodeType(NT_REP_GROUP)) {
            throw new IllegalArgumentException();
        }
        if (!Text.isDescendant(this.groupsPath, groupNode.getPath())) {
            throw new RepositoryException("Group has to be within the Group Path");
        }
        return this.doCreateGroup(groupNode);
    }

    protected Group doCreateGroup(NodeImpl node) throws RepositoryException {
        return new GroupImpl(node, this);
    }

    private User createAdmin() throws RepositoryException {
        User admin;
        try {
            admin = this.createUser(this.adminId, this.adminId);
            if (!this.isAutoSave()) {
                this.session.save();
            }
            log.info("... created admin user with id '" + this.adminId + "' and default pw.");
        }
        catch (ItemExistsException e) {
            NodeImpl conflictingNode = this.session.getNodeById(this.buildNodeId(this.adminId));
            String conflictPath = conflictingNode.getPath();
            log.error("Detected conflicting node " + conflictPath + " of node type " + conflictingNode.getPrimaryNodeType().getName() + ".");
            conflictingNode.remove();
            log.info("Removed conflicting node at " + conflictPath);
            admin = this.createUser(this.adminId, this.adminId);
            if (!this.isAutoSave()) {
                this.session.save();
            }
            log.info("Resolved conflict and (re)created admin user with id '" + this.adminId + "' and default pw.");
        }
        return admin;
    }

    private NodeId buildNodeId(String id) throws RepositoryException {
        try {
            UUID uuid = UUID.nameUUIDFromBytes(id.toLowerCase().getBytes("UTF-8"));
            return new NodeId(uuid);
        }
        catch (UnsupportedEncodingException e) {
            throw new RepositoryException("Unexpected error while build ID hash", e);
        }
    }

    private static boolean isValidPrincipal(Principal principal) {
        return principal != null && principal.getName() != null && principal.getName().length() > 0;
    }

    @Override
    public void loggingOut(SessionImpl session) {
    }

    @Override
    public void loggedOut(SessionImpl session) {
        if (session != this.session) {
            this.session.logout();
        }
    }

    private class NodeCreator {
        private static final String DELIMITER = "/";
        private static final int DEFAULT_DEPTH = 2;
        private static final long DEFAULT_SIZE = 1000L;
        private final int defaultDepth;
        private final boolean autoExpandTree;
        private final long autoExpandSize;

        private NodeCreator(Properties config) {
            int d = 2;
            boolean expand = false;
            long size = 1000L;
            if (config != null) {
                if (config.containsKey(UserManagerImpl.PARAM_DEFAULT_DEPTH)) {
                    try {
                        d = Integer.parseInt(config.get(UserManagerImpl.PARAM_DEFAULT_DEPTH).toString());
                        if (d <= 0) {
                            log.warn("Invalid defaultDepth '" + d + "' -> using default.");
                            d = 2;
                        }
                    }
                    catch (NumberFormatException e) {
                        log.warn("Unable to parse defaultDepth config parameter -> using default.", e);
                    }
                }
                if (config.containsKey(UserManagerImpl.PARAM_AUTO_EXPAND_TREE)) {
                    expand = Boolean.parseBoolean(config.get(UserManagerImpl.PARAM_AUTO_EXPAND_TREE).toString());
                }
                if (config.containsKey(UserManagerImpl.PARAM_AUTO_EXPAND_SIZE)) {
                    try {
                        size = Integer.parseInt(config.get(UserManagerImpl.PARAM_AUTO_EXPAND_SIZE).toString());
                        if (expand && size <= 0L) {
                            log.warn("Invalid autoExpandSize '" + size + "' -> using default.");
                            size = 1000L;
                        }
                    }
                    catch (NumberFormatException e) {
                        log.warn("Unable to parse autoExpandSize config parameter -> using default.", e);
                    }
                }
            }
            this.defaultDepth = d;
            this.autoExpandTree = expand;
            this.autoExpandSize = size;
        }

        public Node createUserNode(String userID, String intermediatePath) throws RepositoryException {
            return this.createAuthorizableNode(userID, false, intermediatePath);
        }

        public Node createGroupNode(String groupID, String intermediatePath) throws RepositoryException {
            return this.createAuthorizableNode(groupID, true, intermediatePath);
        }

        private Node createAuthorizableNode(String id, boolean isGroup, String intermediatePath) throws RepositoryException {
            String escapedId = Text.escapeIllegalJcrChars(id);
            Node folder = this.createDefaultFolderNodes(id, escapedId, isGroup, intermediatePath);
            if (intermediatePath == null) {
                folder = this.createIntermediateFolderNodes(id, escapedId, folder);
            }
            Name nodeName = UserManagerImpl.this.session.getQName(escapedId);
            Name ntName = isGroup ? UserConstants.NT_REP_GROUP : UserConstants.NT_REP_USER;
            NodeId nid = UserManagerImpl.this.buildNodeId(id);
            while (((NodeImpl)folder).hasNode(nodeName)) {
                NodeImpl colliding = ((NodeImpl)folder).getNode(nodeName);
                if (colliding.isNodeType(UserConstants.NT_REP_AUTHORIZABLE_FOLDER)) {
                    log.warn("Existing folder node collides with user/group to be created. Expanding path: " + colliding.getPath());
                    folder = colliding;
                    continue;
                }
                String msg = "Failed to create authorizable with id '" + id + "' : Detected conflicting node of unexpected nodetype '" + colliding.getPrimaryNodeType().getName() + "'.";
                log.error(msg);
                throw new ConstraintViolationException(msg);
            }
            if (UserManagerImpl.this.session.getItemManager().itemExists(nid)) {
                String msg = "Failed to create authorizable with id '" + id + "' : Detected conflict with existing node (NodeID: " + nid + ")";
                log.error(msg);
                throw new ItemExistsException(msg);
            }
            return UserManagerImpl.this.addNode((NodeImpl)folder, nodeName, ntName, nid);
        }

        private Node createDefaultFolderNodes(String id, String escapedId, boolean isGroup, String intermediatePath) throws RepositoryException {
            String defaultPath = this.getDefaultFolderPath(id, isGroup, intermediatePath);
            String[] segmts = defaultPath.split(DELIMITER);
            NodeImpl folder = (NodeImpl)UserManagerImpl.this.session.getRootNode();
            String authRoot = isGroup ? UserManagerImpl.this.groupsPath : UserManagerImpl.this.usersPath;
            for (String segment : segmts) {
                if (segment.length() < 1) continue;
                if (folder.hasNode(segment)) {
                    if (!Text.isDescendantOrEqual(authRoot, (folder = (NodeImpl)folder.getNode(segment)).getPath()) || folder.isNodeType(UserConstants.NT_REP_AUTHORIZABLE_FOLDER)) continue;
                    throw new ConstraintViolationException("Invalid intermediate path. Must be of type rep:AuthorizableFolder.");
                }
                folder = UserManagerImpl.this.addNode(folder, UserManagerImpl.this.session.getQName(segment), UserConstants.NT_REP_AUTHORIZABLE_FOLDER);
            }
            this.checkAuthorizableNodeExists(escapedId, folder);
            return folder;
        }

        private String getDefaultFolderPath(String id, boolean isGroup, String intermediatePath) {
            StringBuilder bld = new StringBuilder();
            if (isGroup) {
                bld.append(UserManagerImpl.this.groupsPath);
            } else {
                bld.append(UserManagerImpl.this.usersPath);
            }
            if (intermediatePath == null) {
                StringBuilder lastSegment = new StringBuilder(this.defaultDepth);
                int idLength = id.length();
                for (int i = 0; i < this.defaultDepth; ++i) {
                    if (idLength > i) {
                        lastSegment.append(id.charAt(i));
                    } else {
                        lastSegment.append(id.charAt(idLength - 1));
                    }
                    bld.append(DELIMITER).append(Text.escapeIllegalJcrChars(lastSegment.toString()));
                }
            } else {
                if (intermediatePath.startsWith(bld.toString())) {
                    intermediatePath = intermediatePath.substring(bld.toString().length());
                }
                if (intermediatePath.length() > 0 && !DELIMITER.equals(intermediatePath)) {
                    if (!intermediatePath.startsWith(DELIMITER)) {
                        bld.append(DELIMITER);
                    }
                    bld.append(intermediatePath);
                }
            }
            return bld.toString();
        }

        /*
         * Enabled aggressive block sorting
         */
        private Node createIntermediateFolderNodes(String id, String escapedId, Node folder) throws RepositoryException {
            if (!this.autoExpandTree) {
                return folder;
            }
            int segmLength = this.defaultDepth + 1;
            while (this.intermediateFolderNeeded(escapedId, folder)) {
                block6: {
                    String folderName = Text.escapeIllegalJcrChars(id.substring(0, segmLength));
                    if (folder.hasNode(folderName)) {
                        NodeImpl n = (NodeImpl)folder.getNode(folderName);
                        if (n.isNodeType(UserConstants.NT_REP_AUTHORIZABLE_FOLDER)) {
                            folder = n;
                            break block6;
                        } else {
                            if (!n.isNodeType(UserConstants.NT_REP_AUTHORIZABLE)) {
                                String msg = "Failed to create authorizable node: Detected conflict with node of unexpected nodetype '" + n.getPrimaryNodeType().getName() + "'.";
                                log.error(msg);
                                throw new ConstraintViolationException(msg);
                            }
                            log.warn("Auto-expanding aborted. An existing authorizable node '" + n.getName() + "'conflicts with intermediate folder to be created.");
                            break;
                        }
                    }
                    folder = UserManagerImpl.this.addNode((NodeImpl)folder, UserManagerImpl.this.session.getQName(folderName), UserConstants.NT_REP_AUTHORIZABLE_FOLDER);
                }
                ++segmLength;
            }
            this.checkAuthorizableNodeExists(escapedId, folder);
            return folder;
        }

        private void checkAuthorizableNodeExists(String nodeName, Node folder) throws AuthorizableExistsException, RepositoryException {
            if (folder.hasNode(nodeName) && ((NodeImpl)folder.getNode(nodeName)).isNodeType(UserConstants.NT_REP_AUTHORIZABLE)) {
                throw new AuthorizableExistsException("Unable to create Group/User: Collision with existing authorizable.");
            }
        }

        private boolean intermediateFolderNeeded(String nodeName, Node folder) throws RepositoryException {
            if (nodeName.length() <= folder.getName().length()) {
                return false;
            }
            if (nodeName.length() == folder.getName().length() + 1) {
                return true;
            }
            return folder.getNodes().getSize() >= this.autoExpandSize;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AuthorizableIterator
    implements Iterator<Authorizable> {
        private final Set<String> served = new HashSet<String>();
        private Authorizable next;
        private NodeIterator authNodeIter;

        private AuthorizableIterator(NodeIterator authNodeIter) {
            this.authNodeIter = authNodeIter;
            this.next = this.seekNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Authorizable next() {
            Authorizable authr = this.next;
            if (authr == null) {
                throw new NoSuchElementException();
            }
            this.next = this.seekNext();
            return authr;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Authorizable seekNext() {
            while (this.authNodeIter.hasNext()) {
                NodeImpl node = (NodeImpl)this.authNodeIter.nextNode();
                try {
                    if (this.served.contains(node.getUUID())) continue;
                    Authorizable authr = UserManagerImpl.this.getAuthorizable(node);
                    this.served.add(node.getUUID());
                    if (authr == null) continue;
                    return authr;
                }
                catch (RepositoryException e) {
                    log.debug(e.getMessage());
                }
            }
            return null;
        }
    }
}

