/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.util.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DbUtility {
    private static final Logger LOG = LoggerFactory.getLogger(DbUtility.class);

    private DbUtility() {
    }

    public static void close(ResultSet rs) {
        DbUtility.close(null, null, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void close(Connection con, Statement stmt, ResultSet rs) {
        try {
            if (rs == null) return;
            rs.close();
            return;
        }
        catch (SQLException e) {
            DbUtility.logException("failed to close ResultSet", e);
            return;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                DbUtility.logException("failed to close Statement", e);
            }
            finally {
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException e) {
                    DbUtility.logException("failed to close Connection", e);
                }
            }
        }
    }

    public static void logException(String message, SQLException e) {
        if (message != null) {
            LOG.error(message);
        }
        LOG.error("       Reason: " + e.getMessage());
        LOG.error("   State/Code: " + e.getSQLState() + "/" + e.getErrorCode());
        LOG.debug("   dump:", e);
    }
}

