/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.UpdatableItemStateManager;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.version.DateVersionSelector;
import org.apache.jackrabbit.core.version.InternalBaseline;
import org.apache.jackrabbit.core.version.InternalFrozenNode;
import org.apache.jackrabbit.core.version.InternalFrozenVersionHistory;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.LabelVersionSelector;
import org.apache.jackrabbit.core.version.NodeStateEx;
import org.apache.jackrabbit.core.version.VersionManagerImplBase;
import org.apache.jackrabbit.core.version.VersionSelector;
import org.apache.jackrabbit.core.version.VersionSet;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VersionManagerImplRestore
extends VersionManagerImplBase {
    private static final Logger log = LoggerFactory.getLogger(VersionManagerImplRestore.class);

    protected VersionManagerImplRestore(SessionImpl session, UpdatableItemStateManager stateMgr, HierarchyManager hierMgr) {
        super(session, stateMgr, hierMgr);
    }

    protected void restore(NodeStateEx state, InternalVersion v, boolean removeExisting) throws RepositoryException {
        this.checkVersionable(state);
        if (!v.getVersionHistory().equals(this.getVersionHistory(state))) {
            String msg = "Unable to restore version. Not same version history.";
            log.error(msg);
            throw new VersionException(msg);
        }
        VersionManagerImplBase.WriteOperation ops = this.startWriteOperation();
        try {
            this.internalRestore(state, v, new DateVersionSelector(v.getCreated()), removeExisting);
            ops.save();
        }
        catch (ItemStateException e) {
            throw new RepositoryException(e);
        }
        finally {
            ops.close();
        }
    }

    protected void restore(NodeStateEx state, Name versionName, boolean removeExisting) throws RepositoryException {
        this.checkVersionable(state);
        InternalVersion v = this.getVersionHistory(state).getVersion(versionName);
        DateVersionSelector gvs = new DateVersionSelector(v.getCreated());
        VersionManagerImplBase.WriteOperation ops = this.startWriteOperation();
        try {
            this.internalRestore(state, v, gvs, removeExisting);
            ops.save();
        }
        catch (ItemStateException e) {
            throw new RepositoryException(e);
        }
        finally {
            ops.close();
        }
    }

    protected void restoreByLabel(NodeStateEx state, Name versionLabel, boolean removeExisting) throws RepositoryException {
        this.checkVersionable(state);
        InternalVersion v = this.getVersionHistory(state).getVersionByLabel(versionLabel);
        if (v == null) {
            String msg = "No version for label " + versionLabel + " found.";
            log.error(msg);
            throw new VersionException(msg);
        }
        VersionManagerImplBase.WriteOperation ops = this.startWriteOperation();
        try {
            this.internalRestore(state, v, new LabelVersionSelector(versionLabel), removeExisting);
            ops.save();
        }
        catch (ItemStateException e) {
            throw new RepositoryException(e);
        }
        finally {
            ops.close();
        }
    }

    protected void restore(NodeStateEx parent, Name name, InternalVersion v, boolean removeExisting) throws RepositoryException {
        InternalFrozenNode fn = v.getFrozenNode();
        if (this.stateMgr.hasItemState(fn.getFrozenId())) {
            if (removeExisting) {
                NodeStateEx existing = parent.getNode(fn.getFrozenId());
                this.checkVersionable(existing);
                VersionManagerImplBase.WriteOperation ops = this.startWriteOperation();
                try {
                    NodeStateEx exParent = existing.getParent();
                    NodeStateEx state = parent.moveFrom(existing, name, false);
                    exParent.store();
                    parent.store();
                    this.internalRestore(state, v, new DateVersionSelector(v.getCreated()), removeExisting);
                    ops.save();
                }
                catch (ItemStateException e) {
                    throw new RepositoryException(e);
                }
                finally {
                    ops.close();
                }
            }
            String msg = "Unable to restore version. Versionable node already exists.";
            log.error(msg);
            throw new ItemExistsException(msg);
        }
        VersionManagerImplBase.WriteOperation ops = this.startWriteOperation();
        try {
            NodeStateEx state = parent.addNode(name, fn.getFrozenPrimaryType(), fn.getFrozenId());
            state.setMixins(fn.getFrozenMixinTypes());
            this.internalRestore(state, v, new DateVersionSelector(v.getCreated()), removeExisting);
            parent.store();
            ops.save();
        }
        catch (ItemStateException e) {
            throw new RepositoryException(e);
        }
        finally {
            ops.close();
        }
    }

    protected void internalRestore(VersionSet versions, boolean removeExisting) throws RepositoryException, ItemStateException {
        int numRestored = 0;
        while (versions.versions().size() > 0) {
            Set<InternalVersion> restored = null;
            for (InternalVersion v : versions.versions().values()) {
                NodeStateEx state = this.getNodeStateEx(v.getFrozenNode().getFrozenId());
                if (state == null) continue;
                int options = 130;
                this.checkModify(state, options, 0);
                restored = this.internalRestore(state, v, versions, removeExisting);
                for (InternalVersion r : restored) {
                    versions.versions().remove(r.getVersionHistory().getId());
                }
                numRestored += restored.size();
                break;
            }
            if (restored != null) continue;
            String msg = numRestored == 0 ? "Unable to restore. At least one version needs existing versionable node in workspace." : "Unable to restore. All versions with non existing versionable nodes need parent.";
            log.error(msg);
            throw new VersionException(msg);
        }
    }

    protected Set<InternalVersion> internalRestore(NodeStateEx state, InternalVersion version, VersionSelector vsel, boolean removeExisting) throws RepositoryException, ItemStateException {
        if (version.isRootVersion()) {
            String msg = "Restore of root version not allowed.";
            log.error(msg);
            throw new VersionException(msg);
        }
        boolean isFull = this.checkVersionable(state);
        Path path = this.hierMgr.getPath(state.getNodeId());
        this.session.getAccessManager().checkPermission(path, 256);
        HashSet<InternalVersion> restored = new HashSet<InternalVersion>();
        this.internalRestoreFrozen(state, version.getFrozenNode(), vsel, restored, removeExisting, false);
        restored.add(version);
        if (isFull) {
            state.setPropertyValue(NameConstants.JCR_BASEVERSION, InternalValue.create(version.getId()));
            state.setPropertyValues(NameConstants.JCR_PREDECESSORS, 9, InternalValue.EMPTY_ARRAY);
            state.setPropertyValue(NameConstants.JCR_VERSIONHISTORY, InternalValue.create(version.getVersionHistory().getId()));
            state.removeProperty(NameConstants.JCR_MERGEFAILED);
        } else {
            this.vMgr.checkin(this.session, state, null);
        }
        state.setPropertyValue(NameConstants.JCR_ISCHECKEDOUT, InternalValue.create(false));
        state.store();
        if (version instanceof InternalBaseline) {
            InternalBaseline baseline = (InternalBaseline)version;
            this.internalRestore(baseline.getBaseVersions(), true);
            NodeId configId = baseline.getConfigurationId();
            NodeId rootId = baseline.getConfigurationRootId();
            NodeStateEx rootNode = state.getNode(rootId);
            rootNode.setPropertyValue(NameConstants.JCR_CONFIGURATION, InternalValue.create(configId));
            rootNode.store();
        }
        return restored;
    }

    protected void internalRestoreFrozen(NodeStateEx state, InternalFrozenNode freeze, VersionSelector vsel, Set<InternalVersion> restored, boolean removeExisting, boolean copy) throws RepositoryException, ItemStateException {
        Object child;
        if (state.getEffectiveNodeType().includesNodeType(NameConstants.MIX_REFERENCEABLE) && !state.getNodeId().equals(freeze.getFrozenId())) {
            String msg = "Unable to restore version of " + this.safeGetJCRPath(state) + ". UUID changed.";
            log.error(msg);
            throw new ItemExistsException(msg);
        }
        if (!freeze.getFrozenPrimaryType().equals(state.getState().getNodeTypeName())) {
            String msg = "Unable to restore version of " + this.safeGetJCRPath(state) + ". PrimaryType change not supported yet.";
            log.error(msg);
            throw new UnsupportedRepositoryOperationException(msg);
        }
        state.setMixins(freeze.getFrozenMixinTypes());
        HashSet<Name> propNames = new HashSet<Name>();
        PropertyState[] props = freeze.getFrozenProperties();
        for (PropertyState prop : props) {
            Name name = prop.getName();
            if (name.equals(NameConstants.JCR_ACTIVITY)) continue;
            state.copyFrom(prop);
            propNames.add(name);
        }
        for (PropertyState prop : state.getProperties()) {
            InternalValue[] values;
            Name propName = prop.getName();
            if (propNames.contains(propName)) continue;
            int opv = state.getDefinition(prop).getOnParentVersion();
            if (opv == 1 || opv == 2 || opv == 6) {
                state.removeProperty(propName);
                continue;
            }
            if (opv == 3) {
                values = this.computeAutoValues(state, state.getDefinition(prop), true);
                if (values == null) continue;
                state.setPropertyValues(propName, prop.getType(), values, prop.isMultiValued());
                continue;
            }
            if (opv != 4 || (values = this.computeAutoValues(state, state.getDefinition(prop), false)) == null) continue;
            state.setPropertyValues(propName, prop.getType(), values, prop.isMultiValued());
        }
        for (QPropertyDefinition def : state.getEffectiveNodeType().getAutoCreatePropDefs()) {
            InternalValue[] values;
            if (state.hasProperty(def.getName()) || (values = this.computeAutoValues(state, def, true)) == null) continue;
            state.setPropertyValues(def.getName(), def.getRequiredType(), values, def.isMultiple());
        }
        LinkedList<ChildNodeEntry> toDelete = new LinkedList<ChildNodeEntry>();
        for (ChildNodeEntry entry : state.getState().getChildNodeEntries()) {
            if (freeze.hasFrozenChildNode(entry.getName(), entry.getIndex())) continue;
            child = state.getNode(entry.getName(), entry.getIndex());
            int opv = ((NodeStateEx)child).getDefinition().getOnParentVersion();
            if (copy || opv == 1 || opv == 2 || opv == 6) {
                toDelete.addFirst(entry);
                continue;
            }
            if (opv == 3) {
                log.warn("OPV.INITIALIZE not supported yet on restore of existing child nodes: " + this.safeGetJCRPath((NodeStateEx)child));
                continue;
            }
            if (opv != 4) continue;
            log.warn("OPV.COMPUTE not supported yet on restore of existing child nodes: " + this.safeGetJCRPath((NodeStateEx)child));
        }
        for (ChildNodeEntry entry : toDelete) {
            state.removeNode(entry.getName(), entry.getIndex());
        }
        state.store();
        for (ChildNodeEntry entry : freeze.getFrozenChildNodes()) {
            child = freeze.getFrozenChildNode(entry.getName(), entry.getIndex());
            NodeStateEx restoredChild = null;
            if (child instanceof InternalFrozenNode) {
                InternalFrozenNode f = (InternalFrozenNode)child;
                state.removeNode(entry.getName(), entry.getIndex());
                if (f.getFrozenId() != null && this.stateMgr.hasItemState(f.getFrozenId())) {
                    NodeStateEx existing = state.getNode(f.getFrozenId());
                    if (removeExisting) {
                        NodeStateEx parent = existing.getParent();
                        parent.removeNode(existing);
                        parent.store();
                    } else if (existing.getState().isShareable()) {
                        restoredChild = state.moveFrom(existing, existing.getName(), true);
                    } else if (!existing.hasAncestor(state.getNodeId())) {
                        String msg = "Unable to restore node, item already exists outside of restored tree: " + this.safeGetJCRPath(existing);
                        log.error(msg);
                        throw new ItemExistsException(msg);
                    }
                }
                if (restoredChild == null) {
                    restoredChild = state.addNode(f.getName(), f.getFrozenPrimaryType(), f.getFrozenId());
                    restoredChild.setMixins(f.getFrozenMixinTypes());
                }
                this.internalRestoreFrozen(restoredChild, f, vsel, restored, removeExisting, true);
            } else if (child instanceof InternalFrozenVersionHistory) {
                InternalFrozenVersionHistory fh = (InternalFrozenVersionHistory)child;
                InternalVersionHistory vh = this.vMgr.getVersionHistory(fh.getVersionHistoryId());
                InternalVersion v = vsel.select(vh);
                Name oldVersion = null;
                NodeId nodeId = vh.getVersionableId();
                if (this.stateMgr.hasItemState(nodeId) && (restoredChild = state.getNode(nodeId)).getParentId() != state.getNodeId()) {
                    if (removeExisting) {
                        NodeStateEx parent = restoredChild.getNode(restoredChild.getParentId());
                        state.moveFrom(restoredChild, fh.getName(), false);
                        parent.store();
                        oldVersion = this.getBaseVersion(restoredChild).getName();
                    } else {
                        String msg = "Unable to restore node, item already exists outside of restored tree: " + this.safeGetJCRPath(restoredChild);
                        log.error(msg);
                        throw new ItemExistsException(msg);
                    }
                }
                if (restoredChild == null) {
                    if (v == null) {
                        InternalVersion[] vs = vh.getRootVersion().getSuccessors();
                        if (vs.length == 0) {
                            String msg = "Unable to select appropariate version for " + child.getName() + " using " + vsel;
                            log.error(msg);
                            throw new VersionException(msg);
                        }
                        v = vs[0];
                    }
                    InternalFrozenNode f = v.getFrozenNode();
                    restoredChild = state.addNode(fh.getName(), f.getFrozenPrimaryType(), f.getFrozenId());
                    restoredChild.setMixins(f.getFrozenMixinTypes());
                } else if (v == null || oldVersion == null || v.getName().equals(oldVersion)) {
                    v = null;
                }
                if (v != null) {
                    try {
                        this.internalRestore(restoredChild, v, vsel, removeExisting);
                    }
                    catch (RepositoryException e) {
                        log.error("Error while restoring node: " + e);
                        log.error("  child path: " + restoredChild);
                        log.error("  selected version: " + v.getName());
                        StringBuffer avail = new StringBuffer();
                        for (Name name : vh.getVersionNames()) {
                            avail.append(name);
                            avail.append(", ");
                        }
                        log.error("  available versions: " + avail);
                        log.error("  versionselector: " + vsel);
                        throw e;
                    }
                    restored.add(v);
                }
            }
            if (restoredChild == null || !state.getEffectiveNodeType().hasOrderableChildNodes()) continue;
            ArrayList<ChildNodeEntry> list = new ArrayList<ChildNodeEntry>(state.getState().getChildNodeEntries());
            ChildNodeEntry toReorder = null;
            boolean isLast = true;
            for (ChildNodeEntry e : list) {
                if (e.getId().equals(restoredChild.getNodeId())) {
                    toReorder = e;
                    continue;
                }
                if (toReorder == null) continue;
                isLast = false;
            }
            if (toReorder == null || isLast) continue;
            list.remove(toReorder);
            list.add(toReorder);
            state.getState().setChildNodeEntries(list);
        }
    }

    private InternalValue[] computeAutoValues(NodeStateEx state, QPropertyDefinition def, boolean useDefaultValues) throws RepositoryException {
        InternalValue[] values = this.session.getNodeTypeInstanceHandler().computeSystemGeneratedPropertyValues(state.getState(), def);
        if (values == null && useDefaultValues) {
            values = InternalValue.create(def.getDefaultValues());
        }
        if (values != null && values.length == 0 && !def.isMultiple()) {
            values = null;
        }
        return values;
    }
}

