/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.xml;

import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.core.xml.Importer;
import org.apache.jackrabbit.core.xml.NamespaceContext;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

abstract class TargetImportHandler
extends DefaultHandler {
    protected final Importer importer;
    protected final ValueFactory valueFactory;
    protected NamespaceContext nsContext;
    protected NamePathResolver resolver;

    protected TargetImportHandler(Importer importer, ValueFactory valueFactory) {
        this.importer = importer;
        this.valueFactory = valueFactory;
    }

    public void startDocument() throws SAXException {
        try {
            this.importer.start();
            this.nsContext = null;
        }
        catch (RepositoryException re) {
            throw new SAXException(re);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.importer.end();
        }
        catch (RepositoryException re) {
            throw new SAXException(re);
        }
    }

    public final void startNamespaceContext(Map mappings) {
        this.nsContext = new NamespaceContext(this.nsContext, mappings);
        this.resolver = new DefaultNamePathResolver(this.nsContext);
    }

    public final void endNamespaceContext() {
        this.nsContext = this.nsContext.getParent();
    }
}

