/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2dav;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.RepositoryFactory;
import org.apache.jackrabbit.jcr2spi.Jcr2spiRepositoryFactory;
import org.apache.jackrabbit.jcr2spi.RepositoryImpl;
import org.apache.jackrabbit.spi.RepositoryServiceFactory;
import org.apache.jackrabbit.spi2dav.Spi2davRepositoryServiceFactory;
import org.apache.jackrabbit.spi2davex.Spi2davexRepositoryServiceFactory;

public class Jcr2davRepositoryFactory
implements RepositoryFactory {
    private static final String DAV_URI = "org.apache.jackrabbit.spi2dav.uri";
    private static final String DAVEX_URI = "org.apache.jackrabbit.spi2davex.uri";

    public Repository getRepository(Map parameters) throws RepositoryException {
        if (parameters == null) {
            return null;
        }
        if (parameters.containsKey(DAV_URI)) {
            return this.getRepository(new Spi2davRepositoryServiceFactory(), parameters);
        }
        if (parameters.containsKey(DAVEX_URI)) {
            return this.getRepository(new Spi2davexRepositoryServiceFactory(), parameters);
        }
        if (parameters.containsKey("org.apache.jackrabbit.repository.uri")) {
            HashMap copy = new HashMap(parameters);
            Object parameter = copy.remove("org.apache.jackrabbit.repository.uri");
            try {
                URI uri = new URI(parameter.toString().trim());
                String scheme = uri.getScheme();
                if ("http".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme)) {
                    copy.put(DAVEX_URI, parameter);
                    return this.getRepository(new Spi2davexRepositoryServiceFactory(), copy);
                }
                return null;
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        return null;
    }

    private Repository getRepository(RepositoryServiceFactory factory, Map parameters) throws RepositoryException {
        try {
            return RepositoryImpl.create(new Jcr2spiRepositoryFactory.RepositoryConfigImpl(factory, parameters));
        }
        catch (RepositoryException e) {
            return null;
        }
    }
}

