/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import java.util.Collection;
import java.util.Set;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.jackrabbit.jcr2spi.NamespaceStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceRegistryImpl
implements NamespaceRegistry {
    private static Logger log = LoggerFactory.getLogger(NamespaceRegistryImpl.class);
    private final NamespaceStorage storage;

    public NamespaceRegistryImpl(NamespaceStorage storage) {
        this.storage = storage;
    }

    public void registerNamespace(String prefix, String uri) throws NamespaceException, UnsupportedRepositoryOperationException, RepositoryException {
        this.storage.registerNamespace(prefix, uri);
    }

    public void unregisterNamespace(String prefix) throws NamespaceException, UnsupportedRepositoryOperationException, RepositoryException {
        this.storage.unregisterNamespace(prefix);
    }

    public String[] getPrefixes() throws RepositoryException {
        Set<String> prefixes = this.storage.getRegisteredNamespaces().keySet();
        return prefixes.toArray(new String[prefixes.size()]);
    }

    public String[] getURIs() throws RepositoryException {
        Collection<String> uris = this.storage.getRegisteredNamespaces().values();
        return uris.toArray(new String[uris.size()]);
    }

    public String getURI(String prefix) throws NamespaceException {
        try {
            return this.storage.getURI(prefix);
        }
        catch (RepositoryException ex) {
            log.debug("Internal error while loading registered namespaces.");
            throw new NamespaceException(prefix + ": is not a registered namespace prefix.");
        }
    }

    public String getPrefix(String uri) throws NamespaceException {
        try {
            return this.storage.getPrefix(uri);
        }
        catch (RepositoryException ex) {
            log.debug("Internal error while loading registered namespaces.");
            throw new NamespaceException(uri + ": is not a registered namespace uri.");
        }
    }
}

