/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NamespaceException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.apache.jackrabbit.commons.AbstractRepository;
import org.apache.jackrabbit.jcr2spi.SessionImpl;
import org.apache.jackrabbit.jcr2spi.XASessionImpl;
import org.apache.jackrabbit.jcr2spi.config.RepositoryConfig;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.SessionInfo;
import org.apache.jackrabbit.spi.XASessionInfo;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.jackrabbit.value.ValueFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryImpl
extends AbstractRepository
implements Referenceable {
    private static Logger log = LoggerFactory.getLogger(RepositoryImpl.class);
    private final RepositoryConfig config;
    private final Map<String, Value[]> descriptors;
    private Reference reference = null;

    private RepositoryImpl(RepositoryConfig config) throws RepositoryException {
        this.config = config;
        ValueFactory vf = ValueFactoryImpl.getInstance();
        DefaultNamePathResolver resolver = new DefaultNamePathResolver(new NamespaceResolver(){

            public String getURI(String prefix) throws NamespaceException {
                return prefix;
            }

            public String getPrefix(String uri) throws NamespaceException {
                return uri;
            }
        });
        Map<String, QValue[]> descr = config.getRepositoryService().getRepositoryDescriptors();
        this.descriptors = new HashMap<String, Value[]>(descr.size());
        for (String key : descr.keySet()) {
            QValue[] qvs = descr.get(key);
            Value[] vs = new Value[qvs.length];
            for (int i = 0; i < qvs.length; ++i) {
                vs[i] = ValueFormat.getJCRValue(qvs[i], resolver, vf);
            }
            this.descriptors.put(key, vs);
        }
    }

    public static Repository create(RepositoryConfig config) throws RepositoryException {
        return new RepositoryImpl(config);
    }

    public String[] getDescriptorKeys() {
        return this.descriptors.keySet().toArray(new String[this.descriptors.keySet().size()]);
    }

    public String getDescriptor(String key) {
        Value v = this.getDescriptorValue(key);
        try {
            return v == null ? null : v.getString();
        }
        catch (RepositoryException e) {
            log.error("corrupt descriptor value: " + key, e);
            return null;
        }
    }

    public Value getDescriptorValue(String key) {
        Value[] vs = this.getDescriptorValues(key);
        return vs == null || vs.length != 1 ? null : vs[0];
    }

    public Value[] getDescriptorValues(String key) {
        if (!this.descriptors.containsKey(key)) {
            return null;
        }
        return this.descriptors.get(key);
    }

    public boolean isSingleValueDescriptor(String key) {
        Value[] vs = this.descriptors.get(key);
        return vs != null && vs.length == 1;
    }

    public Session login(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        SessionInfo info = this.config.getRepositoryService().obtain(credentials, workspaceName);
        try {
            if (info instanceof XASessionInfo) {
                return new XASessionImpl((XASessionInfo)info, (Repository)this, this.config);
            }
            return new SessionImpl(info, this, this.config);
        }
        catch (RepositoryException ex) {
            this.config.getRepositoryService().dispose(info);
            throw ex;
        }
    }

    public Reference getReference() throws NamingException {
        if (this.config instanceof Referenceable) {
            Referenceable confref = (Referenceable)((Object)this.config);
            if (this.reference == null) {
                this.reference = new Reference(RepositoryImpl.class.getName(), Factory.class.getName(), null);
                Enumeration<RefAddr> en = confref.getReference().getAll();
                while (en.hasMoreElements()) {
                    this.reference.add(en.nextElement());
                }
                this.reference.add(new StringRefAddr(Factory.RCF, confref.getReference().getFactoryClassName()));
                this.reference.add(new StringRefAddr(Factory.RCC, this.config.getClass().getName()));
            }
            return this.reference;
        }
        throw new OperationNotSupportedException("Contained RepositoryConfig needs to implement javax.naming.Referenceable");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements ObjectFactory {
        public static final String RCF = RepositoryImpl.class.getName() + ".factory";
        public static final String RCC = RepositoryImpl.class.getName() + ".class";

        @Override
        public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
            Object res = null;
            if (obj instanceof Reference) {
                Reference ref = (Reference)obj;
                String classname = ref.getClassName();
                if (RepositoryImpl.class.getName().equals(classname)) {
                    RefAddr rfac = ref.get(RCF);
                    if (rfac == null || !(rfac instanceof StringRefAddr)) {
                        throw new Exception("Address type " + RCF + " missing or of wrong class: " + rfac);
                    }
                    String configFactoryClassName = (String)((StringRefAddr)rfac).getContent();
                    RefAddr rclas = ref.get(RCC);
                    if (rclas == null || !(rclas instanceof StringRefAddr)) {
                        throw new Exception("Address type " + RCC + " missing or of wrong class: " + rclas);
                    }
                    String repositoryConfigClassName = (String)((StringRefAddr)rclas).getContent();
                    Object rof = Class.forName(configFactoryClassName).newInstance();
                    if (!(rof instanceof ObjectFactory)) {
                        throw new Exception(rof + " must implement ObjectFactory");
                    }
                    ObjectFactory of = (ObjectFactory)rof;
                    Reference newref = new Reference(repositoryConfigClassName, configFactoryClassName, null);
                    Enumeration<RefAddr> en = ref.getAll();
                    while (en.hasMoreElements()) {
                        RefAddr ra = en.nextElement();
                        String type = ra.getType();
                        if (RCF.equals(type) || RCC.equals(type)) continue;
                        newref.add(ra);
                    }
                    Object config = of.getObjectInstance(newref, name, nameCtx, environment);
                    if (!(config instanceof RepositoryConfig)) {
                        throw new Exception(config + " must implement RepositoryConfig");
                    }
                    return RepositoryImpl.create((RepositoryConfig)config);
                }
                throw new Exception("Unexpected class: " + classname);
            }
            return res;
        }
    }
}

