/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.nodetype;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.NamespaceRegistry;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.InvalidNodeTypeDefinitionException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeTypeExistsException;
import javax.jcr.version.OnParentVersionAction;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.jcr2spi.nodetype.BitsetENTCacheImpl;
import org.apache.jackrabbit.jcr2spi.nodetype.DefinitionValidator;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeTypeCache;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeTypeImpl;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeTypeProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeRegistryListener;
import org.apache.jackrabbit.jcr2spi.util.Dumpable;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QItemDefinition;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueConstraint;
import org.apache.jackrabbit.spi.commons.nodetype.NodeTypeStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTypeRegistryImpl
implements Dumpable,
NodeTypeRegistry,
EffectiveNodeTypeProvider {
    private static Logger log = LoggerFactory.getLogger(NodeTypeRegistryImpl.class);
    private final EffectiveNodeTypeCache entCache;
    private final NodeTypeDefinitionMap registeredNTDefs;
    private final Set<QPropertyDefinition> propDefs;
    private final Set<QNodeDefinition> nodeDefs;
    private final NodeTypeStorage storage;
    private final DefinitionValidator validator;
    private final Map<NodeTypeRegistryListener, NodeTypeRegistryListener> listeners = Collections.synchronizedMap(new ReferenceMap(2, 2));

    public static NodeTypeRegistryImpl create(NodeTypeStorage storage, NamespaceRegistry nsRegistry) {
        NodeTypeRegistryImpl ntRegistry = new NodeTypeRegistryImpl(storage, nsRegistry);
        return ntRegistry;
    }

    public synchronized void dispose() {
        this.entCache.clear();
        this.registeredNTDefs.clear();
        this.propDefs.clear();
        this.nodeDefs.clear();
        this.listeners.clear();
    }

    private NodeTypeRegistryImpl(NodeTypeStorage storage, NamespaceRegistry nsRegistry) {
        this.storage = storage;
        this.validator = new DefinitionValidator(this, nsRegistry);
        this.entCache = new BitsetENTCacheImpl();
        this.registeredNTDefs = new NodeTypeDefinitionMap();
        this.propDefs = new HashSet<QPropertyDefinition>();
        this.nodeDefs = new HashSet<QNodeDefinition>();
    }

    @Override
    public void addListener(NodeTypeRegistryListener listener) {
        if (!this.listeners.containsKey(listener)) {
            this.listeners.put(listener, listener);
        }
    }

    @Override
    public void removeListener(NodeTypeRegistryListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Name[] getRegisteredNodeTypes() throws RepositoryException {
        Set<Name> qNames = this.registeredNTDefs.keySet();
        return qNames.toArray(new Name[this.registeredNTDefs.size()]);
    }

    @Override
    public boolean isRegistered(Name nodeTypeName) {
        return this.registeredNTDefs.containsKey(nodeTypeName);
    }

    @Override
    public synchronized void registerNodeTypes(Collection<QNodeTypeDefinition> ntDefs, boolean allowUpdate) throws NodeTypeExistsException, InvalidNodeTypeDefinitionException, RepositoryException {
        ArrayList<Name> added = new ArrayList<Name>();
        ArrayList<Name> modified = new ArrayList<Name>();
        for (QNodeTypeDefinition def : ntDefs) {
            Name name = def.getName();
            if (this.isRegistered(name)) {
                modified.add(name);
                continue;
            }
            added.add(name);
        }
        Map<QNodeTypeDefinition, EffectiveNodeType> defMap = this.validator.validateNodeTypeDefs(ntDefs, this.registeredNTDefs);
        this.storage.registerNodeTypes(ntDefs.toArray(new QNodeTypeDefinition[ntDefs.size()]), allowUpdate);
        this.internalUnregister(modified);
        this.internalRegister(defMap);
        for (Name ntName : added) {
            this.notifyRegistered(ntName);
        }
        for (Name ntName : modified) {
            this.notifyReRegistered(ntName);
        }
    }

    @Override
    public synchronized void unregisterNodeTypes(Collection<Name> nodeTypeNames) throws NoSuchNodeTypeException, RepositoryException {
        for (Name ntName : nodeTypeNames) {
            Set dependents = this.registeredNTDefs.getDependentNodeTypes(ntName);
            dependents.removeAll(nodeTypeNames);
            if (dependents.size() <= 0) continue;
            StringBuffer msg = new StringBuffer();
            msg.append(ntName).append(" can not be removed because the following node types depend on it: ");
            for (Name name : dependents) {
                msg.append(name);
                msg.append(" ");
            }
            throw new RepositoryException(msg.toString());
        }
        this.storage.unregisterNodeTypes(nodeTypeNames.toArray(new Name[nodeTypeNames.size()]));
        this.internalUnregister(nodeTypeNames);
        for (Name ntName : nodeTypeNames) {
            this.notifyUnregistered(ntName);
        }
    }

    @Override
    public QNodeTypeDefinition getNodeTypeDefinition(Name nodeTypeName) throws NoSuchNodeTypeException {
        QNodeTypeDefinition def = this.registeredNTDefs.get(nodeTypeName);
        if (def == null) {
            throw new NoSuchNodeTypeException("Nodetype " + nodeTypeName + " doesn't exist");
        }
        return def;
    }

    @Override
    public synchronized EffectiveNodeType getEffectiveNodeType(Name ntName) throws NoSuchNodeTypeException {
        return this.getEffectiveNodeType(ntName, this.entCache, (Map<Name, QNodeTypeDefinition>)this.registeredNTDefs);
    }

    @Override
    public synchronized EffectiveNodeType getEffectiveNodeType(Name[] ntNames) throws ConstraintViolationException, NoSuchNodeTypeException {
        return this.getEffectiveNodeType(ntNames, this.entCache, (Map<Name, QNodeTypeDefinition>)this.registeredNTDefs);
    }

    @Override
    public EffectiveNodeType getEffectiveNodeType(Name[] ntNames, Map<Name, QNodeTypeDefinition> ntdMap) throws ConstraintViolationException, NoSuchNodeTypeException {
        return this.getEffectiveNodeType(ntNames, this.entCache, ntdMap);
    }

    @Override
    public EffectiveNodeType getEffectiveNodeType(QNodeTypeDefinition ntd, Map<Name, QNodeTypeDefinition> ntdMap) throws ConstraintViolationException, NoSuchNodeTypeException {
        TreeSet<Name> mergedNodeTypes = new TreeSet<Name>();
        TreeSet<Name> inheritedNodeTypes = new TreeSet<Name>();
        TreeSet<Name> allNodeTypes = new TreeSet<Name>();
        HashMap<Name, List<QItemDefinition>> namedItemDefs = new HashMap<Name, List<QItemDefinition>>();
        ArrayList<QItemDefinition> unnamedItemDefs = new ArrayList<QItemDefinition>();
        HashSet<Name> supportedMixins = null;
        Name ntName = ntd.getName();
        mergedNodeTypes.add(ntName);
        allNodeTypes.add(ntName);
        Name[] smixins = ntd.getSupportedMixinTypes();
        if (smixins != null) {
            supportedMixins = new HashSet<Name>();
            for (int i = 0; i < smixins.length; ++i) {
                supportedMixins.add(smixins[i]);
            }
        }
        HashSet<QItemDefinition> itemDefIds = new HashSet<QItemDefinition>();
        QNodeDefinition[] cnda = ntd.getChildNodeDefs();
        for (int i = 0; i < cnda.length; ++i) {
            if (itemDefIds.contains(cnda[i])) {
                String msg = cnda[i].definesResidual() ? ntName + " contains ambiguous residual child node definitions" : ntName + " contains ambiguous definitions for child node named " + cnda[i].getName();
                log.debug(msg);
                throw new ConstraintViolationException(msg);
            }
            itemDefIds.add(cnda[i]);
            if (cnda[i].definesResidual()) {
                unnamedItemDefs.add(cnda[i]);
                continue;
            }
            Name name = cnda[i].getName();
            ArrayList<QNodeDefinition> defs = (ArrayList<QNodeDefinition>)namedItemDefs.get(name);
            if (defs == null) {
                defs = new ArrayList<QNodeDefinition>();
                namedItemDefs.put(name, defs);
            }
            if (defs.size() > 0) {
                for (int j = 0; j < defs.size(); ++j) {
                    QItemDefinition qDef = (QItemDefinition)defs.get(j);
                    if (!cnda[i].isAutoCreated() && !qDef.isAutoCreated()) continue;
                    String msg = "There are more than one 'auto-create' item definitions for '" + name + "' in node type '" + ntName + "'";
                    log.debug(msg);
                    throw new ConstraintViolationException(msg);
                }
            }
            defs.add(cnda[i]);
        }
        QPropertyDefinition[] pda = ntd.getPropertyDefs();
        for (int i = 0; i < pda.length; ++i) {
            if (itemDefIds.contains(pda[i])) {
                String msg = pda[i].definesResidual() ? ntName + " contains ambiguous residual property definitions" : ntName + " contains ambiguous definitions for property named " + pda[i].getName();
                log.debug(msg);
                throw new ConstraintViolationException(msg);
            }
            itemDefIds.add(pda[i]);
            if (pda[i].definesResidual()) {
                unnamedItemDefs.add(pda[i]);
                continue;
            }
            Name name = pda[i].getName();
            ArrayList<QPropertyDefinition> defs = (ArrayList<QPropertyDefinition>)namedItemDefs.get(name);
            if (defs == null) {
                defs = new ArrayList<QPropertyDefinition>();
                namedItemDefs.put(name, defs);
            }
            if (defs.size() > 0) {
                for (int j = 0; j < defs.size(); ++j) {
                    QItemDefinition qDef = (QItemDefinition)defs.get(j);
                    if (!pda[i].isAutoCreated() && !qDef.isAutoCreated()) continue;
                    String msg = "There are more than one 'auto-create' item definitions for '" + name + "' in node type '" + ntName + "'";
                    log.debug(msg);
                    throw new ConstraintViolationException(msg);
                }
            }
            defs.add(pda[i]);
        }
        EffectiveNodeTypeImpl ent = new EffectiveNodeTypeImpl(mergedNodeTypes, inheritedNodeTypes, allNodeTypes, namedItemDefs, unnamedItemDefs, supportedMixins);
        Name[] supertypes = ntd.getSupertypes();
        if (supertypes.length > 0) {
            EffectiveNodeTypeImpl effSuperType = (EffectiveNodeTypeImpl)this.getEffectiveNodeType(supertypes, ntdMap);
            ent.internalMerge(effSuperType, true);
        }
        return ent;
    }

    private EffectiveNodeType getEffectiveNodeType(Name ntName, EffectiveNodeTypeCache entCache, Map<Name, QNodeTypeDefinition> ntdCache) throws NoSuchNodeTypeException {
        EffectiveNodeTypeCache.Key key = entCache.getKey(new Name[]{ntName});
        EffectiveNodeType ent = entCache.get(key);
        if (ent != null) {
            return ent;
        }
        QNodeTypeDefinition ntd = ntdCache.get(ntName);
        if (ntd == null) {
            throw new NoSuchNodeTypeException(ntName.toString());
        }
        EffectiveNodeTypeCache effectiveNodeTypeCache = entCache;
        synchronized (effectiveNodeTypeCache) {
            try {
                ent = this.getEffectiveNodeType(ntd, ntdCache);
                entCache.put(ent);
                return ent;
            }
            catch (ConstraintViolationException e) {
                String msg = "Internal error: encountered invalid registered node type " + ntName;
                log.debug(msg);
                throw new NoSuchNodeTypeException(msg, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EffectiveNodeType getEffectiveNodeType(Name[] ntNames, EffectiveNodeTypeCache entCache, Map<Name, QNodeTypeDefinition> ntdCache) throws ConstraintViolationException, NoSuchNodeTypeException {
        EffectiveNodeTypeCache.Key key = entCache.getKey(ntNames);
        if (entCache.contains(key)) {
            return entCache.get(key);
        }
        for (int i = 0; i < ntNames.length; ++i) {
            if (ntdCache.containsKey(ntNames[i])) continue;
            throw new NoSuchNodeTypeException(ntNames[i].toString());
        }
        EffectiveNodeTypeCache.Key requested = key;
        EffectiveNodeTypeImpl result = null;
        EffectiveNodeTypeCache effectiveNodeTypeCache = entCache;
        synchronized (effectiveNodeTypeCache) {
            while (key.getNames().length > 0) {
                EffectiveNodeTypeCache.Key subKey = entCache.findBest(key);
                if (subKey != null) {
                    EffectiveNodeTypeImpl ent = (EffectiveNodeTypeImpl)entCache.get(subKey);
                    if (result == null) {
                        result = ent;
                    } else {
                        result = result.merge(ent);
                        entCache.put(result);
                    }
                    key = key.subtract(subKey);
                    continue;
                }
                Name[] remainder = key.getNames();
                for (int i = 0; i < remainder.length; ++i) {
                    QNodeTypeDefinition ntd = ntdCache.get(remainder[i]);
                    EffectiveNodeType ent = this.getEffectiveNodeType(ntd, ntdCache);
                    entCache.put(ent);
                    if (result == null) {
                        result = (EffectiveNodeTypeImpl)ent;
                        continue;
                    }
                    result = result.merge((EffectiveNodeTypeImpl)ent);
                    entCache.put(result);
                }
            }
        }
        if (!entCache.contains(requested)) {
            entCache.put(requested, result);
        }
        return result;
    }

    private void notifyRegistered(Name ntName) {
        NodeTypeRegistryListener[] la = new NodeTypeRegistryListener[this.listeners.size()];
        int cnt = 0;
        for (NodeTypeRegistryListener ntrl : this.listeners.values()) {
            la[cnt++] = ntrl;
        }
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].nodeTypeRegistered(ntName);
        }
    }

    private void notifyReRegistered(Name ntName) {
        NodeTypeRegistryListener[] la = new NodeTypeRegistryListener[this.listeners.size()];
        int cnt = 0;
        for (NodeTypeRegistryListener ntrl : this.listeners.values()) {
            la[cnt++] = ntrl;
        }
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].nodeTypeReRegistered(ntName);
        }
    }

    private void notifyUnregistered(Name ntName) {
        NodeTypeRegistryListener[] la = new NodeTypeRegistryListener[this.listeners.size()];
        int cnt = 0;
        for (NodeTypeRegistryListener ntrl : this.listeners.values()) {
            la[cnt++] = ntrl;
        }
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].nodeTypeUnregistered(ntName);
        }
    }

    private void internalRegister(Map<QNodeTypeDefinition, EffectiveNodeType> defMap) {
        for (Map.Entry<QNodeTypeDefinition, EffectiveNodeType> entry : defMap.entrySet()) {
            QNodeTypeDefinition ntd = entry.getKey();
            this.internalRegister(ntd, entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRegister(QNodeTypeDefinition ntd, EffectiveNodeType ent) {
        if (ent != null) {
            this.entCache.put(ent);
        } else {
            log.debug("Effective node type for " + ntd + " not yet built.");
        }
        this.registeredNTDefs.put(ntd.getName(), ntd);
        QPropertyDefinition[] pda = ntd.getPropertyDefs();
        Set<QPropertyDefinition> set = this.propDefs;
        synchronized (set) {
            for (int i = 0; i < pda.length; ++i) {
                this.propDefs.add(pda[i]);
            }
        }
        QNodeDefinition[] nda = ntd.getChildNodeDefs();
        Set<QNodeDefinition> set2 = this.nodeDefs;
        synchronized (set2) {
            for (int i = 0; i < nda.length; ++i) {
                this.nodeDefs.add(nda[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalUnregister(Name name) {
        QNodeTypeDefinition ntd = this.registeredNTDefs.remove(name);
        this.entCache.invalidate(name);
        if (ntd != null) {
            QPropertyDefinition[] pda = ntd.getPropertyDefs();
            Set<QItemDefinition> set = this.propDefs;
            synchronized (set) {
                for (int i = 0; i < pda.length; ++i) {
                    this.propDefs.remove(pda[i]);
                }
            }
            set = this.nodeDefs;
            synchronized (set) {
                QNodeDefinition[] nda = ntd.getChildNodeDefs();
                for (int i = 0; i < nda.length; ++i) {
                    this.nodeDefs.remove(nda[i]);
                }
            }
        }
    }

    private void internalUnregister(Collection<Name> ntNames) {
        for (Name name : ntNames) {
            this.internalUnregister(name);
        }
    }

    @Override
    public void dump(PrintStream ps) {
        ps.println("NodeTypeRegistry (" + this + ")");
        ps.println();
        ps.println("Known NodeTypes:");
        ps.println();
        this.registeredNTDefs.dump(ps);
        ps.println();
        this.entCache.dump(ps);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeTypeDefinitionMap
    implements Map<Name, QNodeTypeDefinition>,
    Dumpable {
        private final ConcurrentHashMap<Name, QNodeTypeDefinition> nodetypeDefinitions = new ConcurrentHashMap();

        private NodeTypeDefinitionMap() {
        }

        private Collection<QNodeTypeDefinition> getValues() {
            return this.nodetypeDefinitions.values();
        }

        private Set<Name> getKeySet() {
            return this.nodetypeDefinitions.keySet();
        }

        private Set<Name> getDependentNodeTypes(Name nodeTypeName) throws NoSuchNodeTypeException {
            if (!this.nodetypeDefinitions.containsKey(nodeTypeName)) {
                throw new NoSuchNodeTypeException(nodeTypeName.toString());
            }
            HashSet<Name> names = new HashSet<Name>();
            for (QNodeTypeDefinition ntd : this.getValues()) {
                if (!ntd.getDependencies().contains(nodeTypeName)) continue;
                names.add(ntd.getName());
            }
            return names;
        }

        private void updateInternalMap(Iterator<QNodeTypeDefinition> definitions) {
            while (definitions.hasNext()) {
                NodeTypeRegistryImpl.this.internalRegister(definitions.next(), null);
            }
        }

        @Override
        public int size() {
            return this.nodetypeDefinitions.size();
        }

        @Override
        public void clear() {
            this.nodetypeDefinitions.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.nodetypeDefinitions.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            if (!(key instanceof Name)) {
                return false;
            }
            return this.get(key) != null;
        }

        @Override
        public boolean containsValue(Object value) {
            if (!(value instanceof QNodeTypeDefinition)) {
                return false;
            }
            return this.get(((QNodeTypeDefinition)value).getName()) != null;
        }

        @Override
        public Set<Name> keySet() {
            try {
                Iterator<QNodeTypeDefinition> it = NodeTypeRegistryImpl.this.storage.getAllDefinitions();
                this.updateInternalMap(it);
            }
            catch (RepositoryException e) {
                log.error(e.getMessage());
            }
            return this.getKeySet();
        }

        @Override
        public Collection<QNodeTypeDefinition> values() {
            this.keySet();
            return this.getValues();
        }

        @Override
        public QNodeTypeDefinition put(Name key, QNodeTypeDefinition value) {
            return this.nodetypeDefinitions.put(key, value);
        }

        @Override
        public void putAll(Map<? extends Name, ? extends QNodeTypeDefinition> t) {
            throw new UnsupportedOperationException("Implementation missing");
        }

        @Override
        public Set<Map.Entry<Name, QNodeTypeDefinition>> entrySet() {
            this.keySet();
            return this.nodetypeDefinitions.entrySet();
        }

        @Override
        public QNodeTypeDefinition get(Object key) {
            if (!(key instanceof Name)) {
                throw new IllegalArgumentException();
            }
            QNodeTypeDefinition def = this.nodetypeDefinitions.get(key);
            if (def == null) {
                try {
                    Iterator<QNodeTypeDefinition> it = NodeTypeRegistryImpl.this.storage.getDefinitions(new Name[]{(Name)key});
                    this.updateInternalMap(it);
                }
                catch (RepositoryException e) {
                    log.debug(e.getMessage());
                }
            }
            def = this.nodetypeDefinitions.get(key);
            return def;
        }

        @Override
        public QNodeTypeDefinition remove(Object key) {
            return this.nodetypeDefinitions.remove(key);
        }

        @Override
        public void dump(PrintStream ps) {
            for (QNodeTypeDefinition ntd : this.getValues()) {
                QNodeDefinition[] nd;
                ps.println(ntd.getName());
                Name[] supertypes = ntd.getSupertypes();
                ps.println("\tSupertypes");
                for (int i = 0; i < supertypes.length; ++i) {
                    ps.println("\t\t" + supertypes[i]);
                }
                ps.println("\tMixin\t" + ntd.isMixin());
                ps.println("\tOrderableChildNodes\t" + ntd.hasOrderableChildNodes());
                ps.println("\tPrimaryItemName\t" + (ntd.getPrimaryItemName() == null ? "<null>" : ntd.getPrimaryItemName().toString()));
                QPropertyDefinition[] pd = ntd.getPropertyDefs();
                for (int i = 0; i < pd.length; ++i) {
                    ps.print("\tPropertyDefinition");
                    ps.println(" (declared in " + pd[i].getDeclaringNodeType() + ") ");
                    ps.println("\t\tName\t\t" + (pd[i].definesResidual() ? "*" : pd[i].getName().toString()));
                    String type = pd[i].getRequiredType() == 0 ? "null" : PropertyType.nameFromValue(pd[i].getRequiredType());
                    ps.println("\t\tRequiredType\t" + type);
                    QValueConstraint[] vca = pd[i].getValueConstraints();
                    StringBuffer constraints = new StringBuffer();
                    if (vca == null) {
                        constraints.append("<null>");
                    } else {
                        for (int n = 0; n < vca.length; ++n) {
                            if (constraints.length() > 0) {
                                constraints.append(", ");
                            }
                            constraints.append(vca[n].getString());
                        }
                    }
                    ps.println("\t\tValueConstraints\t" + constraints.toString());
                    QValue[] defVals = pd[i].getDefaultValues();
                    StringBuffer defaultValues = new StringBuffer();
                    if (defVals == null) {
                        defaultValues.append("<null>");
                    } else {
                        for (QValue defVal : defVals) {
                            if (defaultValues.length() > 0) {
                                defaultValues.append(", ");
                            }
                            try {
                                defaultValues.append(defVal.getString());
                            }
                            catch (RepositoryException e) {
                                defaultValues.append(defVal.toString());
                            }
                        }
                    }
                    ps.println("\t\tDefaultValue\t" + defaultValues.toString());
                    ps.println("\t\tAutoCreated\t" + pd[i].isAutoCreated());
                    ps.println("\t\tMandatory\t" + pd[i].isMandatory());
                    ps.println("\t\tOnVersion\t" + OnParentVersionAction.nameFromValue(pd[i].getOnParentVersion()));
                    ps.println("\t\tProtected\t" + pd[i].isProtected());
                    ps.println("\t\tMultiple\t" + pd[i].isMultiple());
                }
                for (QNodeDefinition aNd : nd = ntd.getChildNodeDefs()) {
                    Name defPrimaryType;
                    ps.print("\tNodeDefinition");
                    ps.println(" (declared in " + aNd.getDeclaringNodeType() + ") ");
                    ps.println("\t\tName\t\t" + (aNd.definesResidual() ? "*" : aNd.getName().toString()));
                    Name[] reqPrimaryTypes = aNd.getRequiredPrimaryTypes();
                    if (reqPrimaryTypes != null && reqPrimaryTypes.length > 0) {
                        for (int n = 0; n < reqPrimaryTypes.length; ++n) {
                            ps.print("\t\tRequiredPrimaryType\t" + reqPrimaryTypes[n]);
                        }
                    }
                    if ((defPrimaryType = aNd.getDefaultPrimaryType()) != null) {
                        ps.print("\n\t\tDefaultPrimaryType\t" + defPrimaryType);
                    }
                    ps.println("\n\t\tAutoCreated\t" + aNd.isAutoCreated());
                    ps.println("\t\tMandatory\t" + aNd.isMandatory());
                    ps.println("\t\tOnVersion\t" + OnParentVersionAction.nameFromValue(aNd.getOnParentVersion()));
                    ps.println("\t\tProtected\t" + aNd.isProtected());
                    ps.println("\t\tAllowsSameNameSiblings\t" + aNd.allowsSameNameSiblings());
                }
            }
        }
    }
}

