/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.state.PropertyState;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceChangeTracker {
    private static Logger log = LoggerFactory.getLogger(ReferenceChangeTracker.class);
    private final Map<String, String> uuidMap = new HashMap<String, String>();
    private final List<PropertyState> references = new ArrayList<PropertyState>();

    public void clear() {
        this.uuidMap.clear();
        this.references.clear();
    }

    public void mappedUUIDs(String oldUUID, String newUUID) {
        if (oldUUID == null || oldUUID.equals(newUUID)) {
            return;
        }
        this.uuidMap.put(oldUUID, newUUID);
    }

    public QValue getMappedReference(QValue oldReference, QValueFactory factory) {
        QValue remapped = null;
        if (oldReference.getType() == 9) {
            try {
                String oldValue = oldReference.getString();
                if (this.uuidMap.containsKey(oldValue)) {
                    String newValue = this.uuidMap.get(oldValue);
                    remapped = factory.create(newValue, 9);
                }
            }
            catch (RepositoryException e) {
                log.error("Unexpected error while creating internal value.", e);
            }
        }
        return remapped;
    }

    public void processedReference(PropertyState refPropertyState) {
        if (refPropertyState != null && refPropertyState.getType() == 9) {
            this.references.add(refPropertyState);
        }
    }

    public Iterator<PropertyState> getReferences() {
        return this.references.iterator();
    }
}

