/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.version;

import java.util.Calendar;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.apache.jackrabbit.jcr2spi.ItemLifeCycleListener;
import org.apache.jackrabbit.jcr2spi.NodeImpl;
import org.apache.jackrabbit.jcr2spi.SessionImpl;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionImpl
extends NodeImpl
implements Version {
    private static Logger log = LoggerFactory.getLogger(VersionImpl.class);

    public VersionImpl(SessionImpl session, NodeState state, ItemLifeCycleListener[] listeners) {
        super(session, state, listeners);
    }

    public VersionHistory getContainingHistory() throws RepositoryException {
        return (VersionHistory)this.getParent();
    }

    public Calendar getCreated() throws RepositoryException {
        return this.getProperty(NameConstants.JCR_CREATED).getDate();
    }

    public Version[] getSuccessors() throws RepositoryException {
        return this.getVersions(NameConstants.JCR_SUCCESSORS);
    }

    public Version getLinearSuccessor() throws RepositoryException {
        VersionHistory vh = this.getContainingHistory();
        VersionIterator it = vh.getAllLinearVersions();
        while (it.hasNext()) {
            Version v = it.nextVersion();
            if (!this.isSame(v.getLinearPredecessor())) continue;
            return v;
        }
        return null;
    }

    public Version[] getPredecessors() throws RepositoryException {
        return this.getVersions(NameConstants.JCR_PREDECESSORS);
    }

    public Version getLinearPredecessor() throws RepositoryException {
        Value[] values = this.getProperty(NameConstants.JCR_PREDECESSORS).getValues();
        if (values != null && values.length > 0) {
            Node n = this.session.getNodeByUUID(values[0].getString());
            if (n instanceof Version) {
                return (Version)n;
            }
            throw new RepositoryException("Version property contains invalid value not pointing to a 'Version'");
        }
        return null;
    }

    public Node getFrozenNode() throws RepositoryException {
        return this.getNode(NameConstants.JCR_FROZENNODE, 1);
    }

    public boolean isSame(Item otherItem) throws RepositoryException {
        this.checkStatus();
        if (otherItem instanceof VersionImpl) {
            VersionImpl other = (VersionImpl)otherItem;
            try {
                return this.getUUID().equals(other.getUUID());
            }
            catch (RepositoryException e) {
                log.error("Internal error while retrieving UUID of version.", e);
            }
        }
        return false;
    }

    protected void checkIsWritable() throws UnsupportedRepositoryOperationException, ConstraintViolationException, RepositoryException {
        super.checkIsWritable();
        throw new ConstraintViolationException("Version is protected");
    }

    protected boolean isWritable() throws RepositoryException {
        super.isWritable();
        return false;
    }

    private Version[] getVersions(Name propertyName) throws RepositoryException {
        Version[] versions;
        Value[] values = this.getProperty(propertyName).getValues();
        if (values != null) {
            versions = new Version[values.length];
            for (int i = 0; i < values.length; ++i) {
                Node n = this.session.getNodeByUUID(values[i].getString());
                if (!(n instanceof Version)) {
                    throw new RepositoryException("Version property contains invalid value not pointing to a 'Version'");
                }
                versions[i] = (Version)n;
            }
        } else {
            versions = new Version[]{};
        }
        return versions;
    }
}

