/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.xml;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Stack;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.xml.Importer;
import org.apache.jackrabbit.jcr2spi.xml.TargetImportHandler;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.util.ISO9075;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class DocViewImportHandler
extends TargetImportHandler {
    private static Logger log = LoggerFactory.getLogger(DocViewImportHandler.class);
    private final NameFactory nameFactory;
    private final Stack<Importer.NodeInfo> stack = new Stack();
    private TargetImportHandler.BufferedStringValue textHandler = new TargetImportHandler.BufferedStringValue(this);

    DocViewImportHandler(Importer importer, NamePathResolver resolver, NameFactory nameFactory) {
        super(importer, resolver);
        this.nameFactory = nameFactory;
    }

    private void appendCharacters(char[] ch, int start, int length) throws SAXException {
        if (this.textHandler == null) {
            this.textHandler = new TargetImportHandler.BufferedStringValue(this);
        }
        try {
            this.textHandler.append(ch, start, length);
        }
        catch (IOException ioe) {
            String msg = "internal error while processing internal buffer data";
            log.error(msg, ioe);
            throw new SAXException(msg, ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCharacters() throws SAXException {
        block8: {
            try {
                if (this.textHandler == null || this.textHandler.length() <= 0L) break block8;
                Reader reader = this.textHandler.reader();
                try {
                    int ch;
                    while ((ch = reader.read()) != -1 && ch <= 32) {
                    }
                    if (ch == -1) {
                        log.debug("ignoring pure whitespace character data...");
                        this.textHandler.dispose();
                        this.textHandler = null;
                        return;
                    }
                }
                finally {
                    reader.close();
                }
                Importer.NodeInfo node = new Importer.NodeInfo(NameConstants.JCR_XMLTEXT, null, null, null);
                Importer.TextValue[] values = new Importer.TextValue[]{this.textHandler};
                ArrayList<Importer.PropInfo> props = new ArrayList<Importer.PropInfo>();
                Importer.PropInfo prop = new Importer.PropInfo(NameConstants.JCR_XMLCHARACTERS, 1, values);
                props.add(prop);
                this.importer.startNode(node, props, this.resolver);
                this.importer.endNode(node);
                this.textHandler.dispose();
                this.textHandler = null;
            }
            catch (IOException ioe) {
                String msg = "internal error while processing internal buffer data";
                log.error(msg, ioe);
                throw new SAXException(msg, ioe);
            }
            catch (RepositoryException re) {
                throw new SAXException(re);
            }
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.processCharacters();
        try {
            String dcdLocalName = ISO9075.decode(localName);
            Name nodeName = this.nameFactory.create(namespaceURI, dcdLocalName);
            String uuid = null;
            Name nodeTypeName = null;
            Name[] mixinTypes = null;
            ArrayList<Importer.PropInfo> props = new ArrayList<Importer.PropInfo>(atts.getLength());
            for (int i = 0; i < atts.getLength(); ++i) {
                if (atts.getURI(i).equals("http://www.w3.org/2000/xmlns/")) continue;
                dcdLocalName = ISO9075.decode(atts.getLocalName(i));
                Name propName = this.nameFactory.create(atts.getURI(i), dcdLocalName);
                String attrValue = atts.getValue(i);
                if (propName.equals(NameConstants.JCR_PRIMARYTYPE)) {
                    if (attrValue.length() <= 0) continue;
                    try {
                        nodeTypeName = this.resolver.getQName(attrValue);
                        continue;
                    }
                    catch (NameException ne) {
                        throw new SAXException("illegal jcr:primaryType value: " + attrValue, ne);
                    }
                }
                if (propName.equals(NameConstants.JCR_MIXINTYPES)) {
                    mixinTypes = this.parseNames(attrValue);
                    continue;
                }
                if (propName.equals(NameConstants.JCR_UUID)) {
                    if (attrValue.length() <= 0) continue;
                    uuid = attrValue;
                    continue;
                }
                Importer.TextValue[] propValues = new Importer.TextValue[]{new TargetImportHandler.StringValue(this, attrValue)};
                props.add(new Importer.PropInfo(propName, 0, propValues));
            }
            Importer.NodeInfo node = new Importer.NodeInfo(nodeName, nodeTypeName, mixinTypes, uuid);
            this.importer.startNode(node, props, this.resolver);
            this.stack.push(node);
        }
        catch (RepositoryException re) {
            throw new SAXException(re);
        }
    }

    private Name[] parseNames(String value) throws SAXException {
        String[] names = value.split("\\p{Space}+");
        Name[] qnames = new Name[names.length];
        for (int i = 0; i < names.length; ++i) {
            try {
                qnames[i] = this.resolver.getQName(names[i]);
                continue;
            }
            catch (NameException ne) {
                throw new SAXException("Invalid name: " + names[i], ne);
            }
            catch (NamespaceException e) {
                throw new SAXException("Invalid name: " + names[i], e);
            }
        }
        return qnames;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.appendCharacters(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.appendCharacters(ch, start, length);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.processCharacters();
        Importer.NodeInfo node = this.stack.peek();
        try {
            this.importer.endNode(node);
        }
        catch (RepositoryException re) {
            throw new SAXException(re);
        }
        this.stack.pop();
    }
}

