/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.repository;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Map;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.RepositoryFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.jackrabbit.rmi.client.ClientAdapterFactory;
import org.apache.jackrabbit.rmi.remote.RemoteRepository;

public class RmiRepositoryFactory
implements RepositoryFactory {
    private static final String REPOSITORY_URI = "org.apache.jackrabbit.repository.uri";

    public Repository getRepository(Map parameters) throws RepositoryException {
        if (parameters != null && parameters.containsKey(REPOSITORY_URI)) {
            URI uri;
            try {
                uri = new URI(parameters.get(REPOSITORY_URI).toString().trim());
            }
            catch (URISyntaxException e) {
                return null;
            }
            String scheme = uri.getScheme();
            if ("rmi".equalsIgnoreCase(scheme)) {
                return this.getRmiRepository(uri.getSchemeSpecificPart());
            }
            if ("jndi".equalsIgnoreCase(scheme)) {
                Hashtable environment = new Hashtable(parameters);
                environment.remove(REPOSITORY_URI);
                return this.getJndiRepository(uri.getSchemeSpecificPart(), environment);
            }
            try {
                return this.getUrlRepository(uri.toURL());
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Repository getUrlRepository(URL url) throws RepositoryException {
        try {
            InputStream stream = url.openStream();
            try {
                Object remote = new ObjectInputStream(stream).readObject();
                if (!(remote instanceof RemoteRepository)) throw new RepositoryException("The resource at URL " + url + " is not a remote repository stub: " + remote);
                Repository repository = this.getRepository((RemoteRepository)remote);
                return repository;
            }
            finally {
                stream.close();
            }
        }
        catch (ClassNotFoundException e) {
            throw new RepositoryException("The resource at URL " + url + " requires a class that is not available", e);
        }
        catch (IOException e) {
            throw new RepositoryException("Failed to read the resource at URL " + url, e);
        }
    }

    private Repository getJndiRepository(String name, Hashtable environment) throws RepositoryException {
        try {
            Object value = new InitialContext(environment).lookup(name);
            if (value instanceof RemoteRepository) {
                return this.getRepository((RemoteRepository)value);
            }
            throw new RepositoryException("The JNDI resource " + name + " is not a remote repository stub: " + value);
        }
        catch (NamingException e) {
            throw new RepositoryException("Failed to look up the JNDI resource " + name, e);
        }
    }

    private Repository getRmiRepository(String name) throws RepositoryException {
        try {
            Remote value = Naming.lookup(name);
            if (value instanceof RemoteRepository) {
                return this.getRepository((RemoteRepository)value);
            }
            throw new RepositoryException("The RMI resource " + name + " is not a remote repository stub: " + value);
        }
        catch (NotBoundException e) {
            throw new RepositoryException("RMI resource " + name + " not found", e);
        }
        catch (MalformedURLException e) {
            throw new RepositoryException("Invalid RMI name: " + name, e);
        }
        catch (RemoteException e) {
            throw new RepositoryException("Failed to look up the RMI resource " + name, e);
        }
    }

    private Repository getRepository(RemoteRepository remote) {
        return new ClientAdapterFactory().getRepository(remote);
    }
}

