/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.servlet;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.jcr.Repository;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.jackrabbit.servlet.ServletRepository;

public class JNDIBindingServlet
extends HttpServlet {
    private static final long serialVersionUID = -9033906248473370936L;
    private Context context;
    private String location = Repository.class.getName().replace('.', '/');

    public void init() throws ServletException {
        try {
            Hashtable<String, String> environment = new Hashtable<String, String>();
            Enumeration names = this.getInitParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (name.equals("location")) {
                    this.location = this.getInitParameter(name);
                    continue;
                }
                if (name.equals(Repository.class.getName())) continue;
                environment.put(name, this.getInitParameter(name));
            }
            this.context = new InitialContext(environment);
            this.context.bind(this.location, (Object)new ServletRepository(this));
        }
        catch (NamingException e) {
            throw new ServletException("Failed to bind repository to JNDI: " + this.location, e);
        }
    }

    public void destroy() {
        try {
            this.context.unbind(this.location);
        }
        catch (NamingException e) {
            this.log("Failed to unbind repository from JNDI: " + this.location, e);
        }
    }
}

