/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import java.lang.reflect.Constructor;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavMethods;
import org.apache.jackrabbit.webdav.client.methods.DavMethod;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.w3c.dom.Element;

public class ExceptionConverter {
    private ExceptionConverter() {
    }

    public static RepositoryException generate(DavException davExc) {
        return ExceptionConverter.generate(davExc, null);
    }

    public static RepositoryException generate(DavException davExc, DavMethod method) {
        String name = method == null ? "_undefined_" : method.getName();
        int code = DavMethods.getMethodCode(name);
        return ExceptionConverter.generate(davExc, code, name);
    }

    public static RepositoryException generate(DavException davExc, int methodCode, String name) {
        String msg = davExc.getMessage();
        if (davExc.hasErrorCondition()) {
            try {
                Element error = davExc.toXml(DomUtil.BUILDER_FACTORY.newDocumentBuilder().newDocument());
                if (DomUtil.matches(error, "error", DavConstants.NAMESPACE) && DomUtil.hasChildElement(error, "exception", null)) {
                    Class<?> cl;
                    Constructor<?> excConstr;
                    Element exc = DomUtil.getChildElement(error, "exception", null);
                    if (DomUtil.hasChildElement(exc, "message", null)) {
                        msg = DomUtil.getChildText(exc, "message", null);
                    }
                    if (DomUtil.hasChildElement(exc, "class", null) && (excConstr = (cl = Class.forName(DomUtil.getChildText(exc, "class", null))).getConstructor(String.class)) != null) {
                        Object o = excConstr.newInstance(msg);
                        if (o instanceof PathNotFoundException && methodCode == 4) {
                            return new InvalidItemStateException(msg);
                        }
                        if (o instanceof RepositoryException) {
                            return (RepositoryException)o;
                        }
                        if (o instanceof Exception) {
                            return new RepositoryException(msg, (Exception)o);
                        }
                    }
                }
            }
            catch (Exception e) {
                return new RepositoryException(e);
            }
        }
        switch (davExc.getErrorCode()) {
            case 404: {
                switch (methodCode) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 9: {
                        return new InvalidItemStateException(msg, davExc);
                    }
                }
                return new ItemNotFoundException(msg, davExc);
            }
            case 423: {
                return new LockException(msg, davExc);
            }
            case 405: {
                return new ConstraintViolationException(msg, davExc);
            }
            case 409: {
                return new InvalidItemStateException(msg, davExc);
            }
            case 412: {
                return new LockException(msg, davExc);
            }
            case 501: {
                if (methodCode > 0 && name != null) {
                    return new UnsupportedRepositoryOperationException("Missing implementation: Method " + name + " could not be executed", davExc);
                }
                return new UnsupportedRepositoryOperationException("Missing implementation", davExc);
            }
        }
        return new RepositoryException(msg, davExc);
    }
}

