/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.commons.iterator.RangeIteratorAdapter;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.QueryInfo;
import org.apache.jackrabbit.spi.QueryResultRow;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi2dav.QueryResultRowImpl;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryInfoImpl
implements QueryInfo {
    private static final Logger log = LoggerFactory.getLogger(QueryInfoImpl.class);
    private final String[] columnNames;
    private final List<QueryResultRow> results = new ArrayList<QueryResultRow>();

    public QueryInfoImpl(MultiStatus ms, IdFactory idFactory, NamePathResolver resolver, ValueFactory valueFactory, QValueFactory qValueFactory) throws RepositoryException {
        String responseDescription = ms.getResponseDescription();
        if (responseDescription != null) {
            String[] cn = responseDescription.split(" ");
            this.columnNames = new String[cn.length];
            for (int i = 0; i < cn.length; ++i) {
                this.columnNames[i] = ISO9075.decode(cn[i]);
            }
        } else {
            throw new RepositoryException("Missing column infos: Unable to build QueryInfo object.");
        }
        for (MultiStatusResponse response : ms.getResponses()) {
            this.results.add(new QueryResultRowImpl(response, this.columnNames, resolver, qValueFactory, valueFactory, idFactory));
        }
    }

    public RangeIterator getRows() {
        return new RangeIteratorAdapter(this.results);
    }

    public String[] getColumnNames() {
        String[] names = new String[this.columnNames.length];
        System.arraycopy(this.columnNames, 0, names, 0, this.columnNames.length);
        return names;
    }

    public Name[] getSelectorNames() {
        if (this.results.isEmpty()) {
            return new Name[0];
        }
        HashSet<Name> uniqueNames = new HashSet<Name>();
        QueryResultRowImpl row = (QueryResultRowImpl)this.results.get(0);
        for (Name n : row.getSelectorNames()) {
            if (n == null) continue;
            uniqueNames.add(n);
        }
        return uniqueNames.toArray(new Name[uniqueNames.size()]);
    }
}

