/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.MergeException;
import javax.jcr.NamespaceException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.InvalidNodeTypeDefinitionException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeTypeExistsException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.version.VersionException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.jackrabbit.spi.Batch;
import org.apache.jackrabbit.spi.ChildInfo;
import org.apache.jackrabbit.spi.Event;
import org.apache.jackrabbit.spi.EventBundle;
import org.apache.jackrabbit.spi.EventFilter;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.ItemInfo;
import org.apache.jackrabbit.spi.ItemInfoCache;
import org.apache.jackrabbit.spi.LockInfo;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.NodeInfo;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.PropertyInfo;
import org.apache.jackrabbit.spi.QItemDefinition;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.QueryInfo;
import org.apache.jackrabbit.spi.RepositoryService;
import org.apache.jackrabbit.spi.SessionInfo;
import org.apache.jackrabbit.spi.Subscription;
import org.apache.jackrabbit.spi.commons.ChildInfoImpl;
import org.apache.jackrabbit.spi.commons.EventBundleImpl;
import org.apache.jackrabbit.spi.commons.EventFilterImpl;
import org.apache.jackrabbit.spi.commons.ItemInfoCacheImpl;
import org.apache.jackrabbit.spi.commons.conversion.IdentifierResolver;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.conversion.ParsingNameResolver;
import org.apache.jackrabbit.spi.commons.conversion.ParsingPathResolver;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.namespace.AbstractNamespaceResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.spi.commons.value.QValueValue;
import org.apache.jackrabbit.spi.commons.value.ValueFactoryQImpl;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.jackrabbit.spi2dav.CredentialsWrapper;
import org.apache.jackrabbit.spi2dav.DefinitionUtil;
import org.apache.jackrabbit.spi2dav.EventImpl;
import org.apache.jackrabbit.spi2dav.EventSubscriptionImpl;
import org.apache.jackrabbit.spi2dav.ExceptionConverter;
import org.apache.jackrabbit.spi2dav.LockInfoImpl;
import org.apache.jackrabbit.spi2dav.NodeInfoImpl;
import org.apache.jackrabbit.spi2dav.PropertyInfoImpl;
import org.apache.jackrabbit.spi2dav.QueryInfoImpl;
import org.apache.jackrabbit.spi2dav.SessionInfoImpl;
import org.apache.jackrabbit.spi2dav.URIResolverImpl;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavMethods;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.CheckinMethod;
import org.apache.jackrabbit.webdav.client.methods.CheckoutMethod;
import org.apache.jackrabbit.webdav.client.methods.CopyMethod;
import org.apache.jackrabbit.webdav.client.methods.DavMethod;
import org.apache.jackrabbit.webdav.client.methods.DavMethodBase;
import org.apache.jackrabbit.webdav.client.methods.DeleteMethod;
import org.apache.jackrabbit.webdav.client.methods.LabelMethod;
import org.apache.jackrabbit.webdav.client.methods.LockMethod;
import org.apache.jackrabbit.webdav.client.methods.MergeMethod;
import org.apache.jackrabbit.webdav.client.methods.MkColMethod;
import org.apache.jackrabbit.webdav.client.methods.MoveMethod;
import org.apache.jackrabbit.webdav.client.methods.OptionsMethod;
import org.apache.jackrabbit.webdav.client.methods.OrderPatchMethod;
import org.apache.jackrabbit.webdav.client.methods.PollMethod;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.client.methods.PropPatchMethod;
import org.apache.jackrabbit.webdav.client.methods.PutMethod;
import org.apache.jackrabbit.webdav.client.methods.ReportMethod;
import org.apache.jackrabbit.webdav.client.methods.SearchMethod;
import org.apache.jackrabbit.webdav.client.methods.SubscribeMethod;
import org.apache.jackrabbit.webdav.client.methods.UnLockMethod;
import org.apache.jackrabbit.webdav.client.methods.UnSubscribeMethod;
import org.apache.jackrabbit.webdav.client.methods.UpdateMethod;
import org.apache.jackrabbit.webdav.header.CodedUrlHeader;
import org.apache.jackrabbit.webdav.header.IfHeader;
import org.apache.jackrabbit.webdav.jcr.ItemResourceConstants;
import org.apache.jackrabbit.webdav.jcr.JcrValueType;
import org.apache.jackrabbit.webdav.jcr.nodetype.NodeTypeConstants;
import org.apache.jackrabbit.webdav.jcr.nodetype.NodeTypeProperty;
import org.apache.jackrabbit.webdav.jcr.observation.SubscriptionImpl;
import org.apache.jackrabbit.webdav.jcr.property.NamespacesProperty;
import org.apache.jackrabbit.webdav.jcr.property.ValuesProperty;
import org.apache.jackrabbit.webdav.jcr.version.report.JcrPrivilegeReport;
import org.apache.jackrabbit.webdav.jcr.version.report.NodeTypesReport;
import org.apache.jackrabbit.webdav.jcr.version.report.RegisteredNamespacesReport;
import org.apache.jackrabbit.webdav.jcr.version.report.RepositoryDescriptorsReport;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.LockDiscovery;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;
import org.apache.jackrabbit.webdav.observation.DefaultEventType;
import org.apache.jackrabbit.webdav.observation.EventDiscovery;
import org.apache.jackrabbit.webdav.observation.EventType;
import org.apache.jackrabbit.webdav.observation.ObservationConstants;
import org.apache.jackrabbit.webdav.observation.SubscriptionInfo;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.HrefProperty;
import org.apache.jackrabbit.webdav.search.SearchInfo;
import org.apache.jackrabbit.webdav.security.CurrentUserPrivilegeSetProperty;
import org.apache.jackrabbit.webdav.security.Privilege;
import org.apache.jackrabbit.webdav.security.SecurityConstants;
import org.apache.jackrabbit.webdav.transaction.TransactionConstants;
import org.apache.jackrabbit.webdav.transaction.TransactionInfo;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.version.MergeInfo;
import org.apache.jackrabbit.webdav.version.UpdateInfo;
import org.apache.jackrabbit.webdav.version.VersionControlledResource;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryServiceImpl
implements RepositoryService,
DavConstants {
    private static Logger log = LoggerFactory.getLogger(RepositoryServiceImpl.class);
    private static final SubscriptionInfo S_INFO = new SubscriptionInfo(SubscriptionImpl.getAllEventTypes(), true, Integer.MAX_VALUE);
    private final IdFactory idFactory;
    private final NameFactory nameFactory;
    private final PathFactory pathFactory;
    private final QValueFactory qValueFactory;
    private final ValueFactory valueFactory;
    private final int itemInfoCacheSize;
    private final Document domFactory;
    private final NamespaceCache nsCache;
    private final URIResolverImpl uriResolver;
    private final HostConfiguration hostConfig;
    private final Map<SessionInfo, HttpClient> clients = new HashMap<SessionInfo, HttpClient>();
    private final HttpConnectionManager connectionManager;
    private final Map<Name, QNodeTypeDefinition> nodeTypeDefinitions = new HashMap<Name, QNodeTypeDefinition>();
    private Map<String, QValue[]> descriptors;
    private static final Namespace SV_NAMESPACE = Namespace.getNamespace("sv", "http://www.jcp.org/jcr/sv/1.0");
    private static final String NODE_ELEMENT = "node";
    private static final String PROPERTY_ELEMENT = "property";
    private static final String VALUE_ELEMENT = "value";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String TYPE_ATTRIBUTE = "type";

    public RepositoryServiceImpl(String uri, IdFactory idFactory, NameFactory nameFactory, PathFactory pathFactory, QValueFactory qValueFactory) throws RepositoryException {
        this(uri, idFactory, nameFactory, pathFactory, qValueFactory, 5000);
    }

    public RepositoryServiceImpl(String uri, IdFactory idFactory, NameFactory nameFactory, PathFactory pathFactory, QValueFactory qValueFactory, int itemInfoCacheSize) throws RepositoryException {
        if (uri == null || "".equals(uri)) {
            throw new RepositoryException("Invalid repository uri '" + uri + "'.");
        }
        if (idFactory == null || qValueFactory == null) {
            throw new RepositoryException("IdFactory and QValueFactory may not be null.");
        }
        this.idFactory = idFactory;
        this.nameFactory = nameFactory;
        this.pathFactory = pathFactory;
        this.qValueFactory = qValueFactory;
        this.itemInfoCacheSize = itemInfoCacheSize;
        try {
            this.domFactory = DomUtil.BUILDER_FACTORY.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RepositoryException(e);
        }
        try {
            URI repositoryUri = new URI(uri.endsWith("/") ? uri : uri + "/", true);
            this.hostConfig = new HostConfiguration();
            this.hostConfig.setHost(repositoryUri);
            this.nsCache = new NamespaceCache();
            this.uriResolver = new URIResolverImpl(repositoryUri, this, this.domFactory);
            NamePathResolverImpl resolver = new NamePathResolverImpl(this.nsCache);
            this.valueFactory = new ValueFactoryQImpl(qValueFactory, resolver);
        }
        catch (URIException e) {
            throw new RepositoryException(e);
        }
        this.connectionManager = new MultiThreadedHttpConnectionManager();
    }

    private static void checkSessionInfo(SessionInfo sessionInfo) throws RepositoryException {
        if (!(sessionInfo instanceof SessionInfoImpl)) {
            throw new RepositoryException("Unknown SessionInfo implementation.");
        }
    }

    private static void checkSubscription(Subscription subscription) throws RepositoryException {
        if (!(subscription instanceof EventSubscriptionImpl)) {
            throw new RepositoryException("Unknown Subscription implementation.");
        }
    }

    private static boolean isUnLockMethod(DavMethod method) {
        int code = DavMethods.getMethodCode(method.getName());
        return 13 == code;
    }

    protected static void initMethod(HttpMethod method, SessionInfo sessionInfo, boolean addIfHeader) throws RepositoryException {
        if (addIfHeader) {
            RepositoryServiceImpl.checkSessionInfo(sessionInfo);
            String[] locktokens = ((SessionInfoImpl)sessionInfo).getAllLockTokens();
            if (locktokens != null && locktokens.length > 0) {
                IfHeader ifH = new IfHeader(locktokens);
                method.setRequestHeader(ifH.getHeaderName(), ifH.getHeaderValue());
            }
        }
    }

    private static void initMethod(DavMethod method, BatchImpl batchImpl, boolean addIfHeader) throws RepositoryException {
        RepositoryServiceImpl.initMethod((HttpMethod)method, batchImpl.sessionInfo, addIfHeader);
        CodedUrlHeader ch = new CodedUrlHeader("TransactionId", batchImpl.batchId);
        method.setRequestHeader(ch.getHeaderName(), ch.getHeaderValue());
    }

    private static boolean isSameResource(String requestURI, MultiStatusResponse response) {
        String href = response.getHref();
        if (href.endsWith("/") && !requestURI.endsWith("/")) {
            href = href.substring(0, href.length() - 1);
        }
        return requestURI.equals(href);
    }

    private String saveGetIdString(ItemId id, SessionInfo sessionInfo) {
        NamePathResolver resolver = null;
        try {
            resolver = this.getNamePathResolver(sessionInfo);
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        return this.saveGetIdString(id, resolver);
    }

    private String saveGetIdString(ItemId id, NamePathResolver resolver) {
        Path p;
        StringBuffer bf = new StringBuffer();
        String uid = id.getUniqueID();
        if (uid != null) {
            bf.append(uid);
        }
        if ((p = id.getPath()) != null) {
            if (resolver == null) {
                bf.append(p.toString());
            } else {
                try {
                    bf.append(resolver.getJCRPath(p));
                }
                catch (NamespaceException e) {
                    bf.append(p.toString());
                }
            }
        }
        return bf.toString();
    }

    protected NamePathResolver getNamePathResolver(SessionInfo sessionInfo) throws RepositoryException {
        RepositoryServiceImpl.checkSessionInfo(sessionInfo);
        return this.getNamePathResolver((SessionInfoImpl)sessionInfo);
    }

    private NamePathResolver getNamePathResolver(SessionInfoImpl sessionInfo) {
        NamePathResolver resolver = sessionInfo.getNamePathResolver();
        if (resolver == null) {
            resolver = new NamePathResolverImpl(sessionInfo);
            sessionInfo.setNamePathResolver(resolver);
        }
        return resolver;
    }

    protected HttpClient getClient(SessionInfo sessionInfo) throws RepositoryException {
        HttpClient client = this.clients.get(sessionInfo);
        if (client == null) {
            client = new HttpClient(this.connectionManager);
            client.setHostConfiguration(this.hostConfig);
            org.apache.commons.httpclient.Credentials creds = null;
            if (sessionInfo != null) {
                RepositoryServiceImpl.checkSessionInfo(sessionInfo);
                creds = ((SessionInfoImpl)sessionInfo).getCredentials().getCredentials();
                client.getParams().setAuthenticationPreemptive(true);
            }
            client.getState().setCredentials(AuthScope.ANY, creds);
            this.clients.put(sessionInfo, client);
            log.debug("Created Client " + client + " for SessionInfo " + sessionInfo);
        }
        return client;
    }

    private void removeClient(SessionInfo sessionInfo) {
        HttpClient cl = this.clients.remove(sessionInfo);
        log.debug("Removed Client " + cl + " for SessionInfo " + sessionInfo);
    }

    protected String getItemUri(ItemId itemId, SessionInfo sessionInfo) throws RepositoryException {
        return this.getItemUri(itemId, sessionInfo, sessionInfo.getWorkspaceName());
    }

    protected String getItemUri(ItemId itemId, SessionInfo sessionInfo, String workspaceName) throws RepositoryException {
        return this.uriResolver.getItemUri(itemId, workspaceName, sessionInfo);
    }

    protected void clearItemUriCache(SessionInfo sessionInfo) {
        this.uriResolver.clearCacheEntries(sessionInfo);
    }

    private String getItemUri(NodeId parentId, Name childName, SessionInfo sessionInfo) throws RepositoryException {
        String parentUri = this.uriResolver.getItemUri(parentId, sessionInfo.getWorkspaceName(), sessionInfo);
        NamePathResolver resolver = this.getNamePathResolver(sessionInfo);
        return parentUri + "/" + Text.escape(resolver.getJCRName(childName));
    }

    private NodeId getParentId(DavPropertySet propSet, SessionInfo sessionInfo) throws RepositoryException {
        HrefProperty parentProp;
        String parentHref;
        NodeId parentId = null;
        if (propSet.contains(ItemResourceConstants.JCR_PARENT) && (parentHref = (parentProp = new HrefProperty(propSet.get(ItemResourceConstants.JCR_PARENT))).getHrefs().get(0)) != null && parentHref.length() > 0) {
            parentId = this.uriResolver.getNodeId(parentHref, sessionInfo);
        }
        return parentId;
    }

    String getUniqueID(DavPropertySet propSet) {
        if (propSet.contains(ItemResourceConstants.JCR_UUID)) {
            return propSet.get(ItemResourceConstants.JCR_UUID).getValue().toString();
        }
        return null;
    }

    Name getQName(DavPropertySet propSet, NamePathResolver resolver) throws RepositoryException {
        DavProperty<?> nameProp = propSet.get(ItemResourceConstants.JCR_NAME);
        if (nameProp != null && nameProp.getValue() != null) {
            String jcrName = nameProp.getValue().toString();
            try {
                return resolver.getQName(jcrName);
            }
            catch (NameException e) {
                throw new RepositoryException(e);
            }
        }
        return NameConstants.ROOT;
    }

    int getIndex(DavPropertySet propSet) {
        int index = 0;
        DavProperty<?> indexProp = propSet.get(ItemResourceConstants.JCR_INDEX);
        if (indexProp != null && indexProp.getValue() != null) {
            index = Integer.parseInt(indexProp.getValue().toString());
        }
        return index;
    }

    private void execute(DavMethod method, SessionInfo sessionInfo) throws RepositoryException {
        try {
            RepositoryServiceImpl.initMethod((HttpMethod)method, sessionInfo, !RepositoryServiceImpl.isUnLockMethod(method));
            this.getClient(sessionInfo).executeMethod(method);
            method.checkSuccess();
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e, method);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    @Override
    public IdFactory getIdFactory() {
        return this.idFactory;
    }

    @Override
    public NameFactory getNameFactory() {
        return this.nameFactory;
    }

    @Override
    public PathFactory getPathFactory() {
        return this.pathFactory;
    }

    @Override
    public QValueFactory getQValueFactory() {
        return this.qValueFactory;
    }

    @Override
    public ItemInfoCache getItemInfoCache(SessionInfo sessionInfo) throws RepositoryException {
        return new ItemInfoCacheImpl(this.itemInfoCacheSize);
    }

    @Override
    public Map<String, QValue[]> getRepositoryDescriptors() throws RepositoryException {
        if (this.descriptors == null) {
            ReportInfo info = new ReportInfo(RepositoryDescriptorsReport.REPOSITORY_DESCRIPTORS_REPORT, 0);
            HttpMethodBase method = null;
            try {
                method = new ReportMethod(this.uriResolver.getRepositoryUri(), info);
                this.getClient(null).executeMethod(method);
                ((DavMethodBase)method).checkSuccess();
                Document doc = ((DavMethodBase)method).getResponseBodyAsDocument();
                this.descriptors = new HashMap<String, QValue[]>();
                if (doc != null) {
                    Element rootElement = doc.getDocumentElement();
                    ElementIterator nsElems = DomUtil.getChildren(rootElement, "descriptor", ItemResourceConstants.NAMESPACE);
                    while (nsElems.hasNext()) {
                        Element elem = nsElems.nextElement();
                        String key = DomUtil.getChildText(elem, "descriptorkey", ItemResourceConstants.NAMESPACE);
                        ElementIterator it = DomUtil.getChildren(elem, "descriptorvalue", ItemResourceConstants.NAMESPACE);
                        ArrayList<QValue> vs = new ArrayList<QValue>();
                        while (it.hasNext()) {
                            Element dv = it.nextElement();
                            String descriptor = DomUtil.getText(dv);
                            if (key != null && descriptor != null) {
                                String typeStr = DomUtil.getAttribute(dv, TYPE_ATTRIBUTE, null);
                                int type = typeStr == null ? 1 : PropertyType.valueFromName(typeStr);
                                vs.add(this.getQValueFactory().create(descriptor, type));
                                continue;
                            }
                            log.error("Invalid descriptor key / value pair: " + key + " -> " + descriptor);
                        }
                        this.descriptors.put(key, vs.toArray(new QValue[vs.size()]));
                    }
                }
            }
            catch (IOException e) {
                throw new RepositoryException(e);
            }
            catch (DavException e) {
                throw ExceptionConverter.generate(e);
            }
            finally {
                if (method != null) {
                    method.releaseConnection();
                }
            }
        }
        return this.descriptors;
    }

    @Override
    public SessionInfo obtain(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        CredentialsWrapper dc = new CredentialsWrapper(credentials);
        return this.obtain(dc, workspaceName);
    }

    @Override
    public SessionInfo obtain(SessionInfo sessionInfo, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        RepositoryServiceImpl.checkSessionInfo(sessionInfo);
        return this.obtain(((SessionInfoImpl)sessionInfo).getCredentials(), workspaceName);
    }

    @Override
    public SessionInfo impersonate(SessionInfo sessionInfo, Credentials credentials) throws LoginException, RepositoryException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    private SessionInfo obtain(CredentialsWrapper credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        SessionInfoImpl sessionInfo;
        block17: {
            HttpMethodBase method = null;
            sessionInfo = new SessionInfoImpl(credentials, workspaceName);
            try {
                DavPropertyNameSet nameSet = new DavPropertyNameSet();
                nameSet.add(DeltaVConstants.WORKSPACE);
                nameSet.add(ItemResourceConstants.JCR_WORKSPACE_NAME);
                method = new PropFindMethod(this.uriResolver.getWorkspaceUri(workspaceName), nameSet, 0);
                this.getClient(sessionInfo).executeMethod(method);
                MultiStatusResponse[] responses = ((DavMethodBase)method).getResponseBodyAsMultiStatus().getResponses();
                if (responses.length != 1) {
                    throw new LoginException("Login failed: Unknown workspace '" + workspaceName + "'.");
                }
                DavPropertySet props = responses[0].getProperties(200);
                if (props.contains(ItemResourceConstants.JCR_WORKSPACE_NAME)) {
                    String wspName = props.get(ItemResourceConstants.JCR_WORKSPACE_NAME).getValue().toString();
                    if (workspaceName == null) {
                        sessionInfo = new SessionInfoImpl(credentials, wspName);
                    } else if (!wspName.equals(workspaceName)) {
                        throw new LoginException("Login failed: Invalid workspace name '" + workspaceName + "'.");
                    }
                    break block17;
                }
                if (props.contains(DeltaVConstants.WORKSPACE)) {
                    String wspHref = new HrefProperty(props.get(DeltaVConstants.WORKSPACE)).getHrefs().get(0);
                    String wspName = Text.unescape(Text.getName(wspHref, true));
                    if (!wspName.equals(workspaceName)) {
                        throw new LoginException("Login failed: Invalid workspace name " + workspaceName);
                    }
                    break block17;
                }
                throw new LoginException("Login failed: Unknown workspace '" + workspaceName + "'.");
            }
            catch (IOException e) {
                throw new RepositoryException(e.getMessage());
            }
            catch (DavException e) {
                throw ExceptionConverter.generate(e);
            }
            finally {
                if (method != null) {
                    method.releaseConnection();
                }
            }
        }
        if (this.nsCache.prefixToURI.isEmpty()) {
            try {
                this.getRegisteredNamespaces(sessionInfo);
            }
            catch (RepositoryException e) {
                // empty catch block
            }
        }
        return sessionInfo;
    }

    @Override
    public void dispose(SessionInfo sessionInfo) throws RepositoryException {
        RepositoryServiceImpl.checkSessionInfo(sessionInfo);
        this.removeClient(sessionInfo);
    }

    @Override
    public String[] getWorkspaceNames(SessionInfo sessionInfo) throws RepositoryException {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add(DeltaVConstants.WORKSPACE);
        HttpMethodBase method = null;
        try {
            method = new PropFindMethod(this.uriResolver.getRepositoryUri(), nameSet, 1);
            this.getClient(sessionInfo).executeMethod(method);
            MultiStatusResponse[] responses = ((DavMethodBase)method).getResponseBodyAsMultiStatus().getResponses();
            HashSet<String> wspNames = new HashSet<String>();
            for (MultiStatusResponse response : responses) {
                DavPropertySet props = response.getProperties(200);
                if (!props.contains(DeltaVConstants.WORKSPACE)) continue;
                HrefProperty hp = new HrefProperty(props.get(DeltaVConstants.WORKSPACE));
                String wspHref = hp.getHrefs().get(0);
                String name = Text.unescape(Text.getName(wspHref, true));
                wspNames.add(name);
            }
            String[] stringArray = wspNames.toArray(new String[wspNames.size()]);
            return stringArray;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    @Override
    public boolean isGranted(SessionInfo sessionInfo, ItemId itemId, String[] actions) throws RepositoryException {
        HttpMethodBase method = null;
        try {
            String uri = this.getItemUri(itemId, sessionInfo);
            ReportInfo reportInfo = new ReportInfo(JcrPrivilegeReport.PRIVILEGES_REPORT);
            reportInfo.setContentElement(DomUtil.hrefToXml(uri, this.domFactory));
            method = new ReportMethod(this.uriResolver.getWorkspaceUri(sessionInfo.getWorkspaceName()), reportInfo);
            this.getClient(sessionInfo).executeMethod(method);
            ((DavMethodBase)method).checkSuccess();
            MultiStatusResponse[] responses = ((DavMethodBase)method).getResponseBodyAsMultiStatus().getResponses();
            if (responses.length < 1) {
                throw new ItemNotFoundException("Unable to retrieve permissions for item " + this.saveGetIdString(itemId, sessionInfo));
            }
            DavProperty<?> p = responses[0].getProperties(200).get(SecurityConstants.CURRENT_USER_PRIVILEGE_SET);
            if (p == null) {
                boolean bl = false;
                return bl;
            }
            HashSet<Privilege> requiredPrivileges = new HashSet<Privilege>();
            for (String action : actions) {
                requiredPrivileges.add(Privilege.getPrivilege(action, ItemResourceConstants.NAMESPACE));
            }
            CurrentUserPrivilegeSetProperty privSet = new CurrentUserPrivilegeSetProperty(p);
            Object privileges = privSet.getValue();
            boolean bl = privileges.containsAll(requiredPrivileges);
            return bl;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    @Override
    public QNodeDefinition getNodeDefinition(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        return (QNodeDefinition)this.getItemDefinition(sessionInfo, nodeId);
    }

    @Override
    public QPropertyDefinition getPropertyDefinition(SessionInfo sessionInfo, PropertyId propertyId) throws RepositoryException {
        return (QPropertyDefinition)this.getItemDefinition(sessionInfo, propertyId);
    }

    private QItemDefinition getItemDefinition(SessionInfo sessionInfo, ItemId itemId) throws RepositoryException {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add(ItemResourceConstants.JCR_DEFINITION);
        nameSet.add(DavPropertyName.RESOURCETYPE);
        HttpMethodBase method = null;
        try {
            DavProperty<?> prop;
            Object value;
            String uri = this.getItemUri(itemId, sessionInfo);
            method = new PropFindMethod(uri, nameSet, 0);
            this.getClient(sessionInfo).executeMethod(method);
            MultiStatusResponse[] responses = ((DavMethodBase)method).getResponseBodyAsMultiStatus().getResponses();
            if (responses.length < 1) {
                throw new ItemNotFoundException("Unable to retrieve the item definition for " + this.saveGetIdString(itemId, sessionInfo));
            }
            if (responses.length > 1) {
                throw new RepositoryException("Internal error: ambigous item definition found '" + this.saveGetIdString(itemId, sessionInfo) + "'.");
            }
            DavPropertySet propertySet = responses[0].getProperties(200);
            DavProperty<?> rType = propertySet.get(DavPropertyName.RESOURCETYPE);
            if (rType.getValue() == null && itemId.denotesNode()) {
                throw new RepositoryException("Internal error: requested node definition and got property definition.");
            }
            NamePathResolver resolver = this.getNamePathResolver(sessionInfo);
            QItemDefinition definition = null;
            if (propertySet.contains(ItemResourceConstants.JCR_DEFINITION) && (value = (prop = propertySet.get(ItemResourceConstants.JCR_DEFINITION)).getValue()) != null && value instanceof Element) {
                Element idfElem = (Element)value;
                definition = itemId.denotesNode() ? DefinitionUtil.createQNodeDefinition(null, idfElem, resolver) : DefinitionUtil.createQPropertyDefinition(null, idfElem, resolver, this.getQValueFactory());
            }
            if (definition == null) {
                throw new RepositoryException("Unable to retrieve definition for item with id '" + this.saveGetIdString(itemId, resolver) + "'.");
            }
            QNodeDefinition qNodeDefinition = definition;
            return qNodeDefinition;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    @Override
    public NodeInfo getNodeInfo(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add(ItemResourceConstants.JCR_INDEX);
        nameSet.add(ItemResourceConstants.JCR_PARENT);
        nameSet.add(ItemResourceConstants.JCR_NAME);
        nameSet.add(ItemResourceConstants.JCR_PRIMARYNODETYPE);
        nameSet.add(ItemResourceConstants.JCR_MIXINNODETYPES);
        nameSet.add(ItemResourceConstants.JCR_REFERENCES);
        nameSet.add(ItemResourceConstants.JCR_UUID);
        nameSet.add(ItemResourceConstants.JCR_PATH);
        nameSet.add(DavPropertyName.RESOURCETYPE);
        HttpMethodBase method = null;
        try {
            String uri = this.getItemUri(nodeId, sessionInfo);
            method = new PropFindMethod(uri, nameSet, 1);
            this.getClient(sessionInfo).executeMethod(method);
            ((DavMethodBase)method).checkSuccess();
            MultiStatusResponse[] responses = ((DavMethodBase)method).getResponseBodyAsMultiStatus().getResponses();
            if (responses.length < 1) {
                throw new ItemNotFoundException("Unable to retrieve the node with id " + this.saveGetIdString((ItemId)nodeId, sessionInfo));
            }
            MultiStatusResponse nodeResponse = null;
            ArrayList<MultiStatusResponse> childResponses = new ArrayList<MultiStatusResponse>();
            for (MultiStatusResponse response : responses) {
                if (RepositoryServiceImpl.isSameResource(uri, response)) {
                    nodeResponse = response;
                    continue;
                }
                childResponses.add(response);
            }
            if (nodeResponse == null) {
                throw new ItemNotFoundException("Unable to retrieve the node " + this.saveGetIdString((ItemId)nodeId, sessionInfo));
            }
            DavPropertySet propSet = nodeResponse.getProperties(200);
            Object type = propSet.get(DavPropertyName.RESOURCETYPE).getValue();
            if (type == null) {
                throw new ItemNotFoundException("No node for id " + this.saveGetIdString((ItemId)nodeId, sessionInfo));
            }
            NamePathResolver resolver = this.getNamePathResolver(sessionInfo);
            NodeId parentId = this.getParentId(propSet, sessionInfo);
            NodeInfoImpl nInfo = this.buildNodeInfo(nodeResponse, parentId, propSet, sessionInfo, resolver);
            for (MultiStatusResponse resp : childResponses) {
                DavPropertySet childProps = resp.getProperties(200);
                if (childProps.contains(DavPropertyName.RESOURCETYPE) && childProps.get(DavPropertyName.RESOURCETYPE).getValue() != null) {
                    nInfo.addChildInfo(this.buildChildInfo(childProps, sessionInfo));
                    continue;
                }
                PropertyId childId = this.uriResolver.buildPropertyId(nInfo.getId(), resp, sessionInfo.getWorkspaceName(), this.getNamePathResolver(sessionInfo));
                nInfo.addPropertyId(childId);
            }
            NodeInfoImpl nodeInfoImpl = nInfo;
            return nodeInfoImpl;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        catch (NameException e) {
            throw new RepositoryException(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    @Override
    public Iterator<? extends ItemInfo> getItemInfos(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        ArrayList<ItemInfo> l = new ArrayList<ItemInfo>();
        NodeInfo nInfo = this.getNodeInfo(sessionInfo, nodeId);
        l.add(nInfo);
        l.addAll(this.buildPropertyInfos(nInfo));
        return l.iterator();
    }

    private NodeInfoImpl buildNodeInfo(MultiStatusResponse nodeResponse, NodeId parentId, DavPropertySet propSet, SessionInfo sessionInfo, NamePathResolver resolver) throws NameException, RepositoryException {
        NodeId id = this.uriResolver.buildNodeId(parentId, nodeResponse, sessionInfo.getWorkspaceName(), this.getNamePathResolver(sessionInfo));
        NodeInfoImpl nInfo = new NodeInfoImpl(id, propSet, resolver);
        if (propSet.contains(ItemResourceConstants.JCR_REFERENCES)) {
            HrefProperty refProp = new HrefProperty(propSet.get(ItemResourceConstants.JCR_REFERENCES));
            for (String propertyHref : refProp.getHrefs()) {
                PropertyId propertyId = this.uriResolver.getPropertyId(propertyHref, sessionInfo);
                nInfo.addReference(propertyId);
            }
        }
        return nInfo;
    }

    private List<PropertyInfo> buildPropertyInfos(NodeInfo nInfo) throws RepositoryException {
        QValue[] vs;
        ArrayList<PropertyInfo> l = new ArrayList<PropertyInfo>(3);
        NodeId nid = nInfo.getId();
        Path nPath = nInfo.getPath();
        if (nid.getPath() == null) {
            PropertyId id = this.getIdFactory().createPropertyId(nid, NameConstants.JCR_UUID);
            vs = new QValue[]{this.getQValueFactory().create(nid.getUniqueID(), 1)};
            Path p = this.getPathFactory().create(nPath, NameConstants.JCR_UUID, true);
            PropertyInfoImpl pi = new PropertyInfoImpl(id, p, 1, false, vs);
            l.add(pi);
        }
        Name pName = NameConstants.JCR_PRIMARYTYPE;
        vs = new QValue[]{this.getQValueFactory().create(nInfo.getNodetype())};
        PropertyInfoImpl pi = new PropertyInfoImpl(this.getIdFactory().createPropertyId(nid, pName), this.getPathFactory().create(nPath, pName, true), 7, false, vs);
        l.add(pi);
        Name[] mixins = nInfo.getMixins();
        if (mixins.length > 0) {
            pName = NameConstants.JCR_MIXINTYPES;
            vs = new QValue[mixins.length];
            for (int i = 0; i < mixins.length; ++i) {
                vs[i] = this.getQValueFactory().create(mixins[i]);
            }
            pi = new PropertyInfoImpl(this.getIdFactory().createPropertyId(nid, pName), this.getPathFactory().create(nPath, pName, true), 7, true, vs);
            l.add(pi);
        }
        return l;
    }

    @Override
    public Iterator<ChildInfo> getChildInfos(SessionInfo sessionInfo, NodeId parentId) throws RepositoryException {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add(ItemResourceConstants.JCR_NAME);
        nameSet.add(ItemResourceConstants.JCR_INDEX);
        nameSet.add(ItemResourceConstants.JCR_PARENT);
        nameSet.add(ItemResourceConstants.JCR_UUID);
        nameSet.add(DavPropertyName.RESOURCETYPE);
        HttpMethodBase method = null;
        try {
            String uri = this.getItemUri(parentId, sessionInfo);
            method = new PropFindMethod(uri, nameSet, 1);
            this.getClient(sessionInfo).executeMethod(method);
            ((DavMethodBase)method).checkSuccess();
            MultiStatusResponse[] responses = ((DavMethodBase)method).getResponseBodyAsMultiStatus().getResponses();
            if (responses.length < 1) {
                throw new ItemNotFoundException("Unable to retrieve the node with id " + this.saveGetIdString((ItemId)parentId, sessionInfo));
            }
            if (responses.length == 1) {
                List childEntries = Collections.emptyList();
                Iterator<ChildInfo> iterator = childEntries.iterator();
                return iterator;
            }
            ArrayList<ChildInfo> childEntries = new ArrayList<ChildInfo>();
            for (MultiStatusResponse resp : responses) {
                DavPropertySet childProps;
                if (RepositoryServiceImpl.isSameResource(uri, resp) || !(childProps = resp.getProperties(200)).contains(DavPropertyName.RESOURCETYPE) || childProps.get(DavPropertyName.RESOURCETYPE).getValue() == null) continue;
                childEntries.add(this.buildChildInfo(childProps, sessionInfo));
            }
            Iterator<ChildInfo> iterator = childEntries.iterator();
            return iterator;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private ChildInfo buildChildInfo(DavPropertySet properties, SessionInfo sessionInfo) throws RepositoryException {
        Name qName = this.getQName(properties, this.getNamePathResolver(sessionInfo));
        int index = this.getIndex(properties);
        String uuid = this.getUniqueID(properties);
        return new ChildInfoImpl(qName, uuid, index);
    }

    @Override
    public Iterator<PropertyId> getReferences(SessionInfo sessionInfo, NodeId nodeId, Name propertyName, boolean weakReferences) throws ItemNotFoundException, RepositoryException {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        if (weakReferences) {
            nameSet.add(ItemResourceConstants.JCR_WEAK_REFERENCES);
        } else {
            nameSet.add(ItemResourceConstants.JCR_REFERENCES);
        }
        HttpMethodBase method = null;
        try {
            String uri = this.getItemUri(nodeId, sessionInfo);
            method = new PropFindMethod(uri, nameSet, 0);
            this.getClient(sessionInfo).executeMethod(method);
            ((DavMethodBase)method).checkSuccess();
            MultiStatusResponse[] responses = ((DavMethodBase)method).getResponseBodyAsMultiStatus().getResponses();
            if (responses.length < 1) {
                throw new ItemNotFoundException("Unable to retrieve the node with id " + this.saveGetIdString((ItemId)nodeId, sessionInfo));
            }
            List refIds = Collections.emptyList();
            for (MultiStatusResponse resp : responses) {
                if (!RepositoryServiceImpl.isSameResource(uri, resp)) continue;
                DavPropertySet props = resp.getProperties(200);
                DavProperty<?> p = weakReferences ? props.get(ItemResourceConstants.JCR_WEAK_REFERENCES) : props.get(ItemResourceConstants.JCR_REFERENCES);
                if (p == null) continue;
                refIds = new ArrayList();
                HrefProperty hp = new HrefProperty(p);
                for (String propHref : hp.getHrefs()) {
                    PropertyId propId = this.uriResolver.getPropertyId(propHref, sessionInfo);
                    if (propertyName != null && !propertyName.equals(propId.getName())) continue;
                    refIds.add(propId);
                }
            }
            Iterator<PropertyId> iterator = refIds.iterator();
            return iterator;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    @Override
    public PropertyInfo getPropertyInfo(SessionInfo sessionInfo, PropertyId propertyId) throws RepositoryException {
        HttpMethodBase method = null;
        try {
            boolean isMultiValued;
            QValue[] values;
            int type;
            String uri = this.getItemUri(propertyId, sessionInfo);
            method = new GetMethod(uri);
            HttpClient client = this.getClient(sessionInfo);
            client.executeMethod(method);
            int status = method.getStatusCode();
            if (status != 200) {
                throw ExceptionConverter.generate(new DavException(status, method.getStatusText()));
            }
            Path path = this.uriResolver.getQPath(uri, sessionInfo);
            String ct = null;
            Header hd = method.getResponseHeader("Content-Type");
            if (hd != null) {
                ct = hd.getValue();
            }
            NamePathResolver resolver = this.getNamePathResolver(sessionInfo);
            if (ct.startsWith("jcr-value")) {
                QValue v;
                type = JcrValueType.typeFromContentType(ct);
                if (type == 2) {
                    v = this.getQValueFactory().create(method.getResponseBodyAsStream());
                } else {
                    int c;
                    InputStreamReader reader = new InputStreamReader(method.getResponseBodyAsStream(), method.getResponseCharSet());
                    StringBuffer sb = new StringBuffer();
                    while ((c = ((Reader)reader).read()) > -1) {
                        sb.append((char)c);
                    }
                    Value jcrValue = this.valueFactory.createValue(sb.toString(), type);
                    v = jcrValue instanceof QValueValue ? ((QValueValue)jcrValue).getQValue() : ValueFormat.getQValue(jcrValue, resolver, this.getQValueFactory());
                }
                values = new QValue[]{v};
                isMultiValued = false;
            } else if (ct.startsWith("text/xml")) {
                values = this.getValues(method.getResponseBodyAsStream(), resolver, propertyId);
                type = values.length > 0 ? values[0].getType() : this.loadType(uri, client, propertyId, resolver);
                isMultiValued = true;
            } else {
                throw new ItemNotFoundException("Unable to retrieve the property with id " + this.saveGetIdString((ItemId)propertyId, resolver));
            }
            PropertyInfoImpl propertyInfoImpl = new PropertyInfoImpl(propertyId, path, type, isMultiValued, values);
            return propertyInfoImpl;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        catch (NameException e) {
            throw new RepositoryException(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private QValue[] getValues(InputStream response, NamePathResolver resolver, ItemId id) throws RepositoryException {
        try {
            DocumentBuilder db = DomUtil.BUILDER_FACTORY.newDocumentBuilder();
            Document doc = db.parse(response);
            Element prop = DomUtil.getChildElement(doc, ItemResourceConstants.JCR_VALUES.getName(), ItemResourceConstants.JCR_VALUES.getNamespace());
            if (prop == null) {
                throw new ItemNotFoundException("No property found at " + this.saveGetIdString(id, resolver));
            }
            DefaultDavProperty<?> p = DefaultDavProperty.createFromXml(prop);
            ValuesProperty vp = new ValuesProperty(p, 1, this.valueFactory);
            Value[] jcrVs = vp.getJcrValues();
            QValue[] qvs = new QValue[jcrVs.length];
            int type = jcrVs.length > 0 ? jcrVs[0].getType() : 1;
            for (int i = 0; i < jcrVs.length; ++i) {
                qvs[i] = jcrVs[i] instanceof QValueValue ? ((QValueValue)jcrVs[i]).getQValue() : (type == 2 ? this.qValueFactory.create(jcrVs[i].getStream()) : ValueFormat.getQValue(jcrVs[i], resolver, this.qValueFactory));
            }
            return qvs;
        }
        catch (SAXException e) {
            log.warn("Internal error: ", (Object)e.getMessage());
            throw new RepositoryException(e);
        }
        catch (IOException e) {
            log.warn("Internal error: ", (Object)e.getMessage());
            throw new RepositoryException(e);
        }
        catch (ParserConfigurationException e) {
            log.warn("Internal error: ", (Object)e.getMessage());
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
    }

    private int loadType(String propertyURI, HttpClient client, PropertyId propertyId, NamePathResolver resolver) throws IOException, DavException, RepositoryException {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add(ItemResourceConstants.JCR_TYPE);
        HttpMethodBase method = null;
        try {
            method = new PropFindMethod(propertyURI, nameSet, 0);
            client.executeMethod(method);
            ((DavMethodBase)method).checkSuccess();
            MultiStatusResponse[] responses = ((DavMethodBase)method).getResponseBodyAsMultiStatus().getResponses();
            if (responses.length == 1) {
                DavPropertySet props = responses[0].getProperties(200);
                DavProperty<?> type = props.get(ItemResourceConstants.JCR_TYPE);
                if (type != null) {
                    int n = PropertyType.valueFromName(type.getValue().toString());
                    return n;
                }
                throw new RepositoryException("Internal error. Cannot retrieve property type at " + this.saveGetIdString((ItemId)propertyId, resolver));
            }
            throw new ItemNotFoundException("Internal error. Cannot retrieve property type at " + this.saveGetIdString((ItemId)propertyId, resolver));
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    @Override
    public Batch createBatch(SessionInfo sessionInfo, ItemId itemId) throws RepositoryException {
        RepositoryServiceImpl.checkSessionInfo(sessionInfo);
        return new BatchImpl(itemId, sessionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(Batch batch) throws RepositoryException {
        if (!(batch instanceof BatchImpl)) {
            throw new RepositoryException("Unknown Batch implementation.");
        }
        BatchImpl batchImpl = (BatchImpl)batch;
        if (batchImpl.isEmpty()) {
            batchImpl.dispose();
            return;
        }
        DavMethod method = null;
        try {
            HttpClient client = batchImpl.start();
            boolean success = false;
            try {
                Iterator it = batchImpl.methods();
                while (it.hasNext()) {
                    method = (DavMethod)it.next();
                    RepositoryServiceImpl.initMethod(method, batchImpl, true);
                    client.executeMethod(method);
                    method.checkSuccess();
                    method.releaseConnection();
                }
                success = true;
            }
            finally {
                batchImpl.end(client, success);
            }
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e, method);
        }
        finally {
            batchImpl.dispose();
        }
    }

    @Override
    public void importXml(SessionInfo sessionInfo, NodeId parentId, InputStream xmlStream, int uuidBehaviour) throws RepositoryException {
        Name nodeName = this.getNameFactory().create("", UUID.randomUUID().toString());
        String uri = this.getItemUri(parentId, nodeName, sessionInfo);
        MkColMethod method = new MkColMethod(uri);
        method.addRequestHeader("ImportUUIDBehavior", Integer.toString(uuidBehaviour));
        method.setRequestEntity(new InputStreamRequestEntity(xmlStream, "text/xml"));
        this.execute(method, sessionInfo);
    }

    @Override
    public void move(SessionInfo sessionInfo, NodeId srcNodeId, NodeId destParentNodeId, Name destName) throws RepositoryException {
        String uri = this.getItemUri(srcNodeId, sessionInfo);
        String destUri = this.getItemUri(destParentNodeId, destName, sessionInfo);
        MoveMethod method = new MoveMethod(uri, destUri, false);
        this.execute(method, sessionInfo);
        this.clearItemUriCache(sessionInfo);
    }

    @Override
    public void copy(SessionInfo sessionInfo, String srcWorkspaceName, NodeId srcNodeId, NodeId destParentNodeId, Name destName) throws RepositoryException {
        String uri = this.uriResolver.getItemUri(srcNodeId, srcWorkspaceName, sessionInfo);
        String destUri = this.getItemUri(destParentNodeId, destName, sessionInfo);
        CopyMethod method = new CopyMethod(uri, destUri, false, false);
        this.execute(method, sessionInfo);
    }

    @Override
    public void update(SessionInfo sessionInfo, NodeId nodeId, String srcWorkspaceName) throws RepositoryException {
        String uri = this.getItemUri(nodeId, sessionInfo);
        String workspUri = this.uriResolver.getWorkspaceUri(srcWorkspaceName);
        this.update(uri, null, new String[]{workspUri}, 2, false, sessionInfo);
    }

    @Override
    public void clone(SessionInfo sessionInfo, String srcWorkspaceName, NodeId srcNodeId, NodeId destParentNodeId, Name destName, boolean removeExisting) throws RepositoryException {
        throw new UnsupportedOperationException("Missing implementation");
    }

    @Override
    public LockInfo getLockInfo(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add(DavPropertyName.LOCKDISCOVERY);
        nameSet.add(ItemResourceConstants.JCR_PARENT);
        HttpMethodBase method = null;
        try {
            String uri = this.getItemUri(nodeId, sessionInfo);
            method = new PropFindMethod(uri, nameSet, 0);
            RepositoryServiceImpl.initMethod(method, sessionInfo, true);
            this.getClient(sessionInfo).executeMethod(method);
            ((DavMethodBase)method).checkSuccess();
            MultiStatusResponse[] responses = ((DavMethodBase)method).getResponseBodyAsMultiStatus().getResponses();
            if (responses.length != 1) {
                throw new ItemNotFoundException("Unable to retrieve the LockInfo. No such node " + this.saveGetIdString((ItemId)nodeId, sessionInfo));
            }
            DavPropertySet ps = responses[0].getProperties(200);
            if (ps.contains(DavPropertyName.LOCKDISCOVERY)) {
                DavProperty<?> p = ps.get(DavPropertyName.LOCKDISCOVERY);
                LockDiscovery ld = LockDiscovery.createFromXml(p.toXml(this.domFactory));
                NodeId parentId = this.getParentId(ps, sessionInfo);
                LockInfo lockInfo = this.retrieveLockInfo(ld, sessionInfo, nodeId, parentId);
                return lockInfo;
            }
            log.debug("No Lock present on node with id " + this.saveGetIdString((ItemId)nodeId, sessionInfo));
            LockInfo lockInfo = null;
            return lockInfo;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    @Override
    public LockInfo lock(SessionInfo sessionInfo, NodeId nodeId, boolean deep, boolean sessionScoped) throws RepositoryException {
        return this.lock(sessionInfo, nodeId, deep, sessionScoped, Long.MAX_VALUE, null);
    }

    @Override
    public LockInfo lock(SessionInfo sessionInfo, NodeId nodeId, boolean deep, boolean sessionScoped, long timeoutHint, String ownerHint) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        try {
            RepositoryServiceImpl.checkSessionInfo(sessionInfo);
            long davTimeout = timeoutHint == Long.MAX_VALUE ? Integer.MAX_VALUE : timeoutHint * 1000L;
            String ownerInfo = ownerHint == null ? sessionInfo.getUserID() : ownerHint;
            String uri = this.getItemUri(nodeId, sessionInfo);
            Scope scope = sessionScoped ? ItemResourceConstants.EXCLUSIVE_SESSION : Scope.EXCLUSIVE;
            LockMethod method = new LockMethod(uri, scope, Type.WRITE, ownerInfo, davTimeout, deep);
            this.execute(method, sessionInfo);
            String lockToken = method.getLockToken();
            ((SessionInfoImpl)sessionInfo).addLockToken(lockToken, sessionScoped);
            LockDiscovery disc = method.getResponseAsLockDiscovery();
            return this.retrieveLockInfo(disc, sessionInfo, nodeId, null);
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
    }

    @Override
    public void refreshLock(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        RepositoryServiceImpl.checkSessionInfo(sessionInfo);
        String uri = this.getItemUri(nodeId, sessionInfo);
        LockMethod method = new LockMethod(uri, Integer.MAX_VALUE, ((SessionInfoImpl)sessionInfo).getAllLockTokens());
        this.execute(method, sessionInfo);
    }

    @Override
    public void unlock(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        RepositoryServiceImpl.checkSessionInfo(sessionInfo);
        String uri = this.getItemUri(nodeId, sessionInfo);
        LockInfoImpl lInfo = (LockInfoImpl)this.getLockInfo(sessionInfo, nodeId);
        if (lInfo == null) {
            throw new LockException("No Lock present on Node with id " + this.saveGetIdString((ItemId)nodeId, sessionInfo));
        }
        String lockToken = lInfo.getActiveLock().getToken();
        boolean isSessionScoped = lInfo.isSessionScoped();
        UnLockMethod method = new UnLockMethod(uri, lockToken);
        this.execute(method, sessionInfo);
        ((SessionInfoImpl)sessionInfo).removeLockToken(lockToken, isSessionScoped);
    }

    private LockInfo retrieveLockInfo(LockDiscovery lockDiscovery, SessionInfo sessionInfo, NodeId nodeId, NodeId parentId) throws RepositoryException {
        LockInfo pLockInfo;
        Object activeLocks = lockDiscovery.getValue();
        ActiveLock activeLock = null;
        Iterator i$ = activeLocks.iterator();
        while (i$.hasNext()) {
            ActiveLock l = (ActiveLock)i$.next();
            Scope sc = l.getScope();
            if (l.getType() != Type.WRITE || sc != Scope.EXCLUSIVE && sc != ItemResourceConstants.EXCLUSIVE_SESSION) continue;
            if (activeLock != null) {
                throw new RepositoryException("Node " + this.saveGetIdString((ItemId)nodeId, sessionInfo) + " contains multiple exclusive write locks.");
            }
            activeLock = l;
        }
        if (activeLock == null) {
            log.debug("No lock present on node " + this.saveGetIdString((ItemId)nodeId, sessionInfo));
            return null;
        }
        if (activeLock.isDeep() && parentId != null && (pLockInfo = this.getLockInfo(sessionInfo, parentId)) != null) {
            return pLockInfo;
        }
        return new LockInfoImpl(activeLock, nodeId);
    }

    @Override
    public NodeId checkin(SessionInfo sessionInfo, NodeId nodeId) throws VersionException, UnsupportedRepositoryOperationException, InvalidItemStateException, LockException, RepositoryException {
        String uri = this.getItemUri(nodeId, sessionInfo);
        CheckinMethod method = new CheckinMethod(uri);
        this.execute(method, sessionInfo);
        Header rh = method.getResponseHeader("Location");
        return this.uriResolver.getNodeId(rh.getValue(), sessionInfo);
    }

    @Override
    public void checkout(SessionInfo sessionInfo, NodeId nodeId) throws UnsupportedRepositoryOperationException, LockException, RepositoryException {
        String uri = this.getItemUri(nodeId, sessionInfo);
        CheckoutMethod method = new CheckoutMethod(uri);
        this.execute(method, sessionInfo);
    }

    @Override
    public void checkout(SessionInfo sessionInfo, NodeId nodeId, NodeId activityId) throws UnsupportedRepositoryOperationException, LockException, RepositoryException {
        if (activityId != null) {
            throw new UnsupportedOperationException("JCR-2104: JSR 283 Versioning. Implementation missing");
        }
        this.checkout(sessionInfo, nodeId);
    }

    @Override
    public NodeId checkpoint(SessionInfo sessionInfo, NodeId nodeId) throws UnsupportedRepositoryOperationException, RepositoryException {
        NodeId vID = this.checkin(sessionInfo, nodeId);
        this.checkout(sessionInfo, nodeId);
        return vID;
    }

    @Override
    public NodeId checkpoint(SessionInfo sessionInfo, NodeId nodeId, NodeId activityId) throws UnsupportedRepositoryOperationException, RepositoryException {
        if (activityId == null) {
            return this.checkpoint(sessionInfo, nodeId);
        }
        throw new UnsupportedOperationException("JCR-2104: JSR 283 Versioning. Implementation missing");
    }

    @Override
    public void removeVersion(SessionInfo sessionInfo, NodeId versionHistoryId, NodeId versionId) throws RepositoryException {
        String uri = this.getItemUri(versionId, sessionInfo);
        DeleteMethod method = new DeleteMethod(uri);
        this.execute(method, sessionInfo);
    }

    @Override
    public void restore(SessionInfo sessionInfo, NodeId nodeId, NodeId versionId, boolean removeExisting) throws RepositoryException {
        String uri = this.getItemUri(nodeId, sessionInfo);
        String vUri = this.getItemUri(versionId, sessionInfo);
        Path relPath = null;
        if (!this.exists(sessionInfo, uri)) {
            Path path = nodeId.getPath();
            if (nodeId.getUniqueID() != null) {
                uri = this.getItemUri(this.idFactory.createNodeId(nodeId.getUniqueID(), null), sessionInfo);
                relPath = path.isAbsolute() ? this.getPathFactory().getRootPath().computeRelativePath(path) : path;
            } else {
                for (int degree = 0; degree < path.getLength(); ++degree) {
                    Path ancestorPath = path.getAncestor(degree);
                    NodeId parentId = this.idFactory.createNodeId(nodeId.getUniqueID(), ancestorPath);
                    if (!this.exists(sessionInfo, this.getItemUri(parentId, sessionInfo))) continue;
                    uri = this.getItemUri(parentId, sessionInfo);
                    relPath = ancestorPath.computeRelativePath(path);
                    break;
                }
            }
        }
        this.update(uri, relPath, new String[]{vUri}, 0, removeExisting, sessionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exists(SessionInfo sInfo, String uri) {
        HeadMethod method = new HeadMethod(uri);
        try {
            int statusCode = this.getClient(sInfo).executeMethod(method);
            if (statusCode == 200) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            log.error("Unexpected error while testing existence of item.", e);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage());
        }
        finally {
            method.releaseConnection();
        }
        return false;
    }

    @Override
    public void restore(SessionInfo sessionInfo, NodeId[] versionIds, boolean removeExisting) throws RepositoryException {
        String uri = this.uriResolver.getWorkspaceUri(sessionInfo.getWorkspaceName());
        String[] vUris = new String[versionIds.length];
        for (int i = 0; i < versionIds.length; ++i) {
            vUris[i] = this.getItemUri(versionIds[i], sessionInfo);
        }
        this.update(uri, null, vUris, 0, removeExisting, sessionInfo);
    }

    private void update(String uri, Path relPath, String[] updateSource, int updateType, boolean removeExisting, SessionInfo sessionInfo) throws RepositoryException {
        try {
            UpdateInfo uInfo;
            if (removeExisting || relPath != null) {
                Element uElem = UpdateInfo.createUpdateElement(updateSource, updateType, this.domFactory);
                if (removeExisting) {
                    DomUtil.addChildElement(uElem, "removeexisting", ItemResourceConstants.NAMESPACE);
                }
                if (relPath != null) {
                    DomUtil.addChildElement(uElem, "relpath", ItemResourceConstants.NAMESPACE, this.getNamePathResolver(sessionInfo).getJCRPath(relPath));
                }
                uInfo = new UpdateInfo(uElem);
            } else {
                uInfo = new UpdateInfo(updateSource, updateType, new DavPropertyNameSet());
            }
            UpdateMethod method = new UpdateMethod(uri, uInfo);
            this.execute(method, sessionInfo);
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
    }

    @Override
    public Iterator<NodeId> merge(SessionInfo sessionInfo, NodeId nodeId, String srcWorkspaceName, boolean bestEffort) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
        return this.merge(sessionInfo, nodeId, srcWorkspaceName, bestEffort, false);
    }

    @Override
    public Iterator<NodeId> merge(SessionInfo sessionInfo, NodeId nodeId, String srcWorkspaceName, boolean bestEffort, boolean isShallow) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
        try {
            String wspHref = this.uriResolver.getWorkspaceUri(srcWorkspaceName);
            Element mElem = MergeInfo.createMergeElement(new String[]{wspHref}, !bestEffort, false, this.domFactory);
            if (isShallow) {
                mElem.appendChild(DomUtil.depthToXml(false, this.domFactory));
            }
            MergeInfo mInfo = new MergeInfo(mElem);
            MergeMethod method = new MergeMethod(this.getItemUri(nodeId, sessionInfo), mInfo);
            this.execute(method, sessionInfo);
            MultiStatusResponse[] resps = method.getResponseBodyAsMultiStatus().getResponses();
            ArrayList<NodeId> failedIds = new ArrayList<NodeId>(resps.length);
            for (MultiStatusResponse resp : resps) {
                String href = resp.getHref();
                failedIds.add(this.uriResolver.getNodeId(href, sessionInfo));
            }
            return failedIds.iterator();
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
    }

    @Override
    public void resolveMergeConflict(SessionInfo sessionInfo, NodeId nodeId, NodeId[] mergeFailedIds, NodeId[] predecessorIds) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        try {
            ArrayList<HrefProperty> changeList = new ArrayList<HrefProperty>();
            String[] mergeFailedHref = new String[mergeFailedIds.length];
            for (int i = 0; i < mergeFailedIds.length; ++i) {
                mergeFailedHref[i] = this.getItemUri(mergeFailedIds[i], sessionInfo);
            }
            changeList.add(new HrefProperty(VersionControlledResource.AUTO_MERGE_SET, mergeFailedHref, false));
            if (predecessorIds != null && predecessorIds.length > 0) {
                String[] pdcHrefs = new String[predecessorIds.length];
                for (int i = 0; i < predecessorIds.length; ++i) {
                    pdcHrefs[i] = this.getItemUri(predecessorIds[i], sessionInfo);
                }
                changeList.add(new HrefProperty(VersionControlledResource.PREDECESSOR_SET, pdcHrefs, false));
            }
            PropPatchMethod method = new PropPatchMethod(this.getItemUri(nodeId, sessionInfo), changeList);
            this.execute(method, sessionInfo);
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public void addVersionLabel(SessionInfo sessionInfo, NodeId versionHistoryId, NodeId versionId, Name label, boolean moveLabel) throws VersionException, RepositoryException {
        try {
            String uri = this.getItemUri(versionId, sessionInfo);
            String strLabel = this.getNamePathResolver(sessionInfo).getJCRName(label);
            LabelMethod method = new LabelMethod(uri, strLabel, moveLabel ? 0 : 2);
            this.execute(method, sessionInfo);
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public void removeVersionLabel(SessionInfo sessionInfo, NodeId versionHistoryId, NodeId versionId, Name label) throws VersionException, RepositoryException {
        try {
            String uri = this.getItemUri(versionId, sessionInfo);
            String strLabel = this.getNamePathResolver(sessionInfo).getJCRName(label);
            LabelMethod method = new LabelMethod(uri, strLabel, 1);
            this.execute(method, sessionInfo);
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public NodeId createActivity(SessionInfo sessionInfo, String title) throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedOperationException("JCR-2104: JSR 283 Versioning. Implementation missing");
    }

    @Override
    public void removeActivity(SessionInfo sessionInfo, NodeId activityId) throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedOperationException("JCR-2104: JSR 283 Versioning. Implementation missing");
    }

    @Override
    public Iterator<NodeId> mergeActivity(SessionInfo sessionInfo, NodeId activityId) throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedOperationException("JCR-2104: JSR 283 Versioning. Implementation missing");
    }

    @Override
    public NodeId createConfiguration(SessionInfo sessionInfo, NodeId nodeId) throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedOperationException("JCR-2104: JSR 283 Versioning. Implementation missing");
    }

    @Override
    public String[] getSupportedQueryLanguages(SessionInfo sessionInfo) throws RepositoryException {
        OptionsMethod method = new OptionsMethod(this.uriResolver.getWorkspaceUri(sessionInfo.getWorkspaceName()));
        try {
            this.getClient(sessionInfo).executeMethod(method);
            method.checkSuccess();
            Header daslHeader = method.getResponseHeader("DASL");
            CodedUrlHeader h = new CodedUrlHeader(daslHeader.getName(), daslHeader.getValue());
            String[] stringArray = h.getCodedUrls();
            return stringArray;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            method.releaseConnection();
        }
    }

    @Override
    public String[] checkQueryStatement(SessionInfo sessionInfo, String statement, String language, Map<String, String> namespaces) throws InvalidQueryException, RepositoryException {
        return new String[0];
    }

    @Override
    public QueryInfo executeQuery(SessionInfo sessionInfo, String statement, String language, Map<String, String> namespaces, long limit, long offset, Map<String, QValue> values) throws RepositoryException {
        HttpMethodBase method = null;
        try {
            String uri = this.uriResolver.getWorkspaceUri(sessionInfo.getWorkspaceName());
            SearchInfo sInfo = new SearchInfo(language, Namespace.EMPTY_NAMESPACE, statement, namespaces);
            if (limit != -1L) {
                sInfo.setNumberResults(limit);
            }
            if (offset != -1L) {
                sInfo.setOffset(offset);
            }
            if (values != null && !values.isEmpty()) {
                throw new UnsupportedOperationException("Implementation missing:  JCR-2107");
            }
            method = new SearchMethod(uri, sInfo);
            this.getClient(sessionInfo).executeMethod(method);
            ((DavMethodBase)method).checkSuccess();
            MultiStatus ms = ((DavMethodBase)method).getResponseBodyAsMultiStatus();
            NamePathResolver resolver = this.getNamePathResolver(sessionInfo);
            QueryInfoImpl queryInfoImpl = new QueryInfoImpl(ms, this.idFactory, resolver, this.valueFactory, this.getQValueFactory());
            return queryInfoImpl;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventFilter createEventFilter(SessionInfo sessionInfo, int eventTypes, Path absPath, boolean isDeep, String[] uuids, Name[] nodeTypeNames, boolean noLocal) throws UnsupportedRepositoryOperationException, RepositoryException {
        HashSet<Name> resolvedTypeNames = null;
        if (nodeTypeNames != null) {
            resolvedTypeNames = new HashSet<Name>();
            if (this.nodeTypeDefinitions.size() == 0) {
                this.getQNodeTypeDefinitions(sessionInfo);
            }
            Map<Name, QNodeTypeDefinition> map = this.nodeTypeDefinitions;
            synchronized (map) {
                for (Name nodeTypeName : nodeTypeNames) {
                    this.resolveNodeType(resolvedTypeNames, nodeTypeName);
                }
            }
        }
        return new EventFilterImpl(eventTypes, absPath, isDeep, uuids, resolvedTypeNames, noLocal);
    }

    @Override
    public EventBundle[] getEvents(Subscription subscription, long timeout) throws RepositoryException, UnsupportedRepositoryOperationException {
        RepositoryServiceImpl.checkSubscription(subscription);
        EventSubscriptionImpl subscr = (EventSubscriptionImpl)subscription;
        String rootUri = this.uriResolver.getRootItemUri(subscr.getSessionInfo().getWorkspaceName());
        return this.poll(rootUri, subscr.getId(), timeout, subscr.getSessionInfo());
    }

    @Override
    public EventBundle getEvents(SessionInfo sessionInfo, EventFilter filter, long after) throws RepositoryException, UnsupportedRepositoryOperationException {
        throw new UnsupportedRepositoryOperationException("Not implemented -> JCR-2541");
    }

    @Override
    public Subscription createSubscription(SessionInfo sessionInfo, EventFilter[] filters) throws UnsupportedRepositoryOperationException, RepositoryException {
        RepositoryServiceImpl.checkSessionInfo(sessionInfo);
        String rootUri = this.uriResolver.getRootItemUri(sessionInfo.getWorkspaceName());
        String subscriptionId = this.subscribe(rootUri, S_INFO, null, sessionInfo, null);
        log.debug("Subscribed on server for session info " + sessionInfo);
        return new EventSubscriptionImpl(subscriptionId, (SessionInfoImpl)sessionInfo);
    }

    @Override
    public void updateEventFilters(Subscription subscription, EventFilter[] filters) throws RepositoryException {
    }

    @Override
    public void dispose(Subscription subscription) throws RepositoryException {
        RepositoryServiceImpl.checkSubscription(subscription);
        EventSubscriptionImpl subscr = (EventSubscriptionImpl)subscription;
        String rootUri = this.uriResolver.getRootItemUri(subscr.getSessionInfo().getWorkspaceName());
        this.unsubscribe(rootUri, subscr.getId(), subscr.getSessionInfo());
    }

    private String subscribe(String uri, SubscriptionInfo subscriptionInfo, String subscriptionId, SessionInfo sessionInfo, String batchId) throws RepositoryException {
        HttpMethodBase method = null;
        try {
            Object ch;
            method = subscriptionId != null ? new SubscribeMethod(uri, subscriptionInfo, subscriptionId) : new SubscribeMethod(uri, subscriptionInfo);
            if (batchId != null) {
                ch = new CodedUrlHeader("TransactionId", batchId);
                method.setRequestHeader(((CodedUrlHeader)ch).getHeaderName(), ((CodedUrlHeader)ch).getHeaderValue());
            }
            this.getClient(sessionInfo).executeMethod(method);
            ((DavMethodBase)method).checkSuccess();
            ch = ((SubscribeMethod)method).getSubscriptionId();
            return ch;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private void unsubscribe(String uri, String subscriptionId, SessionInfo sessionInfo) throws RepositoryException {
        UnSubscribeMethod method = null;
        try {
            method = new UnSubscribeMethod(uri, subscriptionId);
            this.getClient(sessionInfo).executeMethod(method);
            method.checkSuccess();
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private void resolveNodeType(Set<Name> resolved, Name ntName) {
        if (!resolved.add(ntName)) {
            return;
        }
        QNodeTypeDefinition def = this.nodeTypeDefinitions.get(ntName);
        if (def != null) {
            for (Name supertype : def.getSupertypes()) {
                this.resolveNodeType(resolved, supertype);
            }
        }
    }

    private EventBundle[] poll(String uri, String subscriptionId, long timeout, SessionInfoImpl sessionInfo) throws RepositoryException {
        HttpMethodBase method = null;
        try {
            EventBundle[] events;
            method = new PollMethod(uri, subscriptionId, timeout);
            this.getClient(sessionInfo).executeMethod(method);
            ((DavMethodBase)method).checkSuccess();
            EventDiscovery disc = ((PollMethod)method).getResponseAsEventDiscovery();
            if (disc.isEmpty()) {
                events = new EventBundle[]{};
            } else {
                Element discEl = disc.toXml(this.domFactory);
                ElementIterator it = DomUtil.getChildren(discEl, "eventbundle", ObservationConstants.NAMESPACE);
                ArrayList<EventBundleImpl> bundles = new ArrayList<EventBundleImpl>();
                while (it.hasNext()) {
                    Element bundleElement = it.nextElement();
                    String value = DomUtil.getAttribute(bundleElement, "transactionid", ObservationConstants.NAMESPACE);
                    boolean isLocal = false;
                    if (value != null) {
                        isLocal = value.equals(sessionInfo.getLastBatchId());
                    }
                    bundles.add(new EventBundleImpl(this.buildEventList(bundleElement, sessionInfo), isLocal));
                }
                events = bundles.toArray(new EventBundle[bundles.size()]);
            }
            EventBundle[] eventBundleArray = events;
            return eventBundleArray;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private List<Event> buildEventList(Element bundleElement, SessionInfoImpl sessionInfo) {
        ArrayList<Event> events = new ArrayList<Event>();
        ElementIterator eventElementIterator = DomUtil.getChildren(bundleElement, "event", ObservationConstants.NAMESPACE);
        while (eventElementIterator.hasNext()) {
            Path eventPath;
            int type;
            Element evElem = eventElementIterator.nextElement();
            Element typeEl = DomUtil.getChildElement(evElem, "eventtype", ObservationConstants.NAMESPACE);
            EventType[] et = DefaultEventType.createFromXml(typeEl);
            if (et.length == 0 || et.length > 1) {
                log.error("Ambigous event type definition: expected one single eventtype.");
                continue;
            }
            String href = DomUtil.getChildTextTrim(evElem, "href", NAMESPACE);
            try {
                type = SubscriptionImpl.getJcrEventType(et[0]);
                eventPath = this.uriResolver.getQPath(href, sessionInfo);
            }
            catch (DavException e) {
                log.error("Internal error while building Event", (Object)e.getMessage());
                continue;
            }
            catch (RepositoryException e) {
                log.error("Internal error while building Event", (Object)e.getMessage());
                continue;
            }
            ItemId eventId = null;
            try {
                eventId = type == 1 || type == 2 ? this.uriResolver.getNodeId(href, sessionInfo) : this.uriResolver.getPropertyId(href, sessionInfo);
            }
            catch (RepositoryException e) {
                log.warn("Unable to build event itemId: ", (Object)e.getMessage());
            }
            String parentHref = Text.getRelativeParent(href, 1, true);
            NodeId parentId = null;
            try {
                parentId = this.uriResolver.getNodeId(parentHref, sessionInfo);
            }
            catch (RepositoryException e) {
                log.warn("Unable to build event parentId: ", (Object)e.getMessage());
            }
            events.add(new EventImpl(eventId, eventPath, parentId, type, evElem, this.getNamePathResolver(sessionInfo), this.getQValueFactory()));
        }
        return events;
    }

    @Override
    public Map<String, String> getRegisteredNamespaces(SessionInfo sessionInfo) throws RepositoryException {
        ReportInfo info = new ReportInfo(RegisteredNamespacesReport.REGISTERED_NAMESPACES_REPORT, 0);
        HttpMethodBase method = null;
        try {
            method = new ReportMethod(this.uriResolver.getWorkspaceUri(sessionInfo.getWorkspaceName()), info);
            this.getClient(sessionInfo).executeMethod(method);
            ((DavMethodBase)method).checkSuccess();
            Document doc = ((DavMethodBase)method).getResponseBodyAsDocument();
            HashMap<String, String> namespaces = new HashMap<String, String>();
            if (doc != null) {
                Element rootElement = doc.getDocumentElement();
                ElementIterator nsElems = DomUtil.getChildren(rootElement, "namespace", ItemResourceConstants.NAMESPACE);
                while (nsElems.hasNext()) {
                    Element elem = nsElems.nextElement();
                    String prefix = DomUtil.getChildText(elem, "prefix", ItemResourceConstants.NAMESPACE);
                    String uri = DomUtil.getChildText(elem, "uri", ItemResourceConstants.NAMESPACE);
                    if (prefix == null && uri == null) {
                        uri = "";
                        prefix = "";
                    }
                    if (uri != null) {
                        namespaces.put(prefix, uri);
                        this.nsCache.add(prefix, uri);
                        continue;
                    }
                    log.error("Invalid prefix / uri pair: " + prefix + " -> " + uri);
                }
            }
            HashMap<String, String> hashMap = namespaces;
            return hashMap;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    @Override
    public String getNamespaceURI(SessionInfo sessionInfo, String prefix) throws NamespaceException, RepositoryException {
        try {
            return this.nsCache.getURI(prefix);
        }
        catch (NamespaceException e) {
            this.getRegisteredNamespaces(sessionInfo);
            return this.nsCache.getURI(prefix);
        }
    }

    @Override
    public String getNamespacePrefix(SessionInfo sessionInfo, String uri) throws NamespaceException, RepositoryException {
        try {
            return this.nsCache.getPrefix(uri);
        }
        catch (NamespaceException e) {
            this.getRegisteredNamespaces(sessionInfo);
            return this.nsCache.getPrefix(uri);
        }
    }

    @Override
    public void registerNamespace(SessionInfo sessionInfo, String prefix, String uri) throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        this.getRegisteredNamespaces(sessionInfo);
        HashMap<String, String> namespaces = new HashMap<String, String>(this.nsCache.getNamespaces());
        namespaces.put(prefix, uri);
        this.internalSetNamespaces(sessionInfo, namespaces);
        this.nsCache.add(prefix, uri);
    }

    @Override
    public void unregisterNamespace(SessionInfo sessionInfo, String uri) throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        this.getRegisteredNamespaces(sessionInfo);
        String prefix = this.nsCache.getPrefix(uri);
        HashMap<String, String> namespaces = new HashMap<String, String>(this.nsCache.getNamespaces());
        namespaces.remove(prefix);
        this.internalSetNamespaces(sessionInfo, namespaces);
        this.nsCache.remove(prefix, uri);
    }

    private void internalSetNamespaces(SessionInfo sessionInfo, Map<String, String> namespaces) throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        DavPropertySet setProperties = new DavPropertySet();
        setProperties.add(new NamespacesProperty(namespaces));
        HttpMethodBase method = null;
        try {
            String uri = this.uriResolver.getWorkspaceUri(sessionInfo.getWorkspaceName());
            method = new PropPatchMethod(uri, setProperties, new DavPropertyNameSet());
            RepositoryServiceImpl.initMethod(method, sessionInfo, true);
            this.getClient(sessionInfo).executeMethod(method);
            ((DavMethodBase)method).checkSuccess();
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    @Override
    public Iterator<QNodeTypeDefinition> getQNodeTypeDefinitions(SessionInfo sessionInfo) throws RepositoryException {
        ReportInfo info = new ReportInfo(NodeTypesReport.NODETYPES_REPORT, 0);
        info.setContentElement(DomUtil.createElement(this.domFactory, "all-nodetypes", NodeTypeConstants.NAMESPACE));
        HttpMethodBase method = null;
        try {
            String workspaceUri = this.uriResolver.getWorkspaceUri(sessionInfo.getWorkspaceName());
            method = new ReportMethod(workspaceUri, info);
            this.getClient(sessionInfo).executeMethod(method);
            ((DavMethodBase)method).checkSuccess();
            Document reportDoc = ((DavMethodBase)method).getResponseBodyAsDocument();
            Iterator<QNodeTypeDefinition> iterator = this.retrieveQNodeTypeDefinitions(sessionInfo, reportDoc);
            return iterator;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    @Override
    public Iterator<QNodeTypeDefinition> getQNodeTypeDefinitions(SessionInfo sessionInfo, Name[] nodetypeNames) throws RepositoryException {
        return this.getQNodeTypeDefinitions(sessionInfo);
    }

    @Override
    public void registerNodeTypes(SessionInfo sessionInfo, QNodeTypeDefinition[] nodeTypeDefinitions, boolean allowUpdate) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedOperationException("JCR-2003. Implementation missing");
    }

    @Override
    public void unregisterNodeTypes(SessionInfo sessionInfo, Name[] nodeTypeNames) throws UnsupportedRepositoryOperationException, NoSuchNodeTypeException, RepositoryException {
        throw new UnsupportedOperationException("JCR-2003. Implementation missing");
    }

    @Override
    public void createWorkspace(SessionInfo sessionInfo, String name, String srcWorkspaceName) throws AccessDeniedException, UnsupportedRepositoryOperationException, NoSuchWorkspaceException, RepositoryException {
        throw new UnsupportedOperationException("JCR-2003. Implementation missing");
    }

    @Override
    public void deleteWorkspace(SessionInfo sessionInfo, String name) throws AccessDeniedException, UnsupportedRepositoryOperationException, NoSuchWorkspaceException, RepositoryException {
        throw new UnsupportedOperationException("JCR-2003. Implementation missing");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<QNodeTypeDefinition> retrieveQNodeTypeDefinitions(SessionInfo sessionInfo, Document reportDoc) throws RepositoryException {
        ElementIterator it = DomUtil.getChildren(reportDoc.getDocumentElement(), "nodeType", null);
        ArrayList<QNodeTypeDefinition> ntDefs = new ArrayList<QNodeTypeDefinition>();
        NamePathResolver resolver = this.getNamePathResolver(sessionInfo);
        while (it.hasNext()) {
            ntDefs.add(DefinitionUtil.createQNodeTypeDefinition(it.nextElement(), resolver, this.getQValueFactory()));
        }
        Map<Name, QNodeTypeDefinition> map = this.nodeTypeDefinitions;
        synchronized (map) {
            this.nodeTypeDefinitions.clear();
            Iterator i$ = ntDefs.iterator();
            while (i$.hasNext()) {
                QNodeTypeDefinition ntDef;
                QNodeTypeDefinition def = ntDef = (QNodeTypeDefinition)i$.next();
                this.nodeTypeDefinitions.put(def.getName(), def);
            }
        }
        return ntDefs.iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NamespaceCache
    extends AbstractNamespaceResolver {
        private final HashMap<String, String> prefixToURI = new HashMap();
        private final HashMap<String, String> uriToPrefix = new HashMap();

        private NamespaceCache() {
        }

        public Map<String, String> getNamespaces() {
            return new HashMap<String, String>(this.prefixToURI);
        }

        public void add(String prefix, String uri) {
            this.prefixToURI.put(prefix, uri);
            this.uriToPrefix.put(uri, prefix);
        }

        public void remove(String prefix, String uri) {
            this.prefixToURI.remove(prefix);
            this.uriToPrefix.remove(uri);
        }

        @Override
        public String getURI(String prefix) throws NamespaceException {
            String uri = this.prefixToURI.get(prefix);
            if (uri != null) {
                return uri;
            }
            throw new NamespaceException(prefix + ": is not a registered namespace prefix.");
        }

        @Override
        public String getPrefix(String uri) throws NamespaceException {
            String prefix = this.uriToPrefix.get(uri);
            if (prefix != null) {
                return prefix;
            }
            throw new NamespaceException(uri + ": is not a registered namespace uri.");
        }
    }

    private class NamePathResolverImpl
    implements NamePathResolver {
        private final NameResolver nResolver;
        private final PathResolver pResolver;

        private NamePathResolverImpl(SessionInfo sessionInfo) {
            NamespaceResolverImpl nsResolver = new NamespaceResolverImpl(sessionInfo);
            this.nResolver = new ParsingNameResolver(RepositoryServiceImpl.this.getNameFactory(), nsResolver);
            IdentifierResolverImpl idResolver = new IdentifierResolverImpl(sessionInfo);
            this.pResolver = new ParsingPathResolver(RepositoryServiceImpl.this.getPathFactory(), this.nResolver, idResolver);
        }

        private NamePathResolverImpl(NamespaceResolver nsResolver) {
            this.nResolver = new ParsingNameResolver(RepositoryServiceImpl.this.getNameFactory(), nsResolver);
            this.pResolver = new ParsingPathResolver(RepositoryServiceImpl.this.getPathFactory(), this.nResolver);
        }

        public Name getQName(String jcrName) throws IllegalNameException, NamespaceException {
            return this.nResolver.getQName(jcrName);
        }

        public String getJCRName(Name qName) throws NamespaceException {
            return this.nResolver.getJCRName(qName);
        }

        public Path getQPath(String path) throws MalformedPathException, IllegalNameException, NamespaceException {
            return this.pResolver.getQPath(path);
        }

        public Path getQPath(String path, boolean normalizeIdentifier) throws MalformedPathException, IllegalNameException, NamespaceException {
            return this.pResolver.getQPath(path, normalizeIdentifier);
        }

        public String getJCRPath(Path path) throws NamespaceException {
            return this.pResolver.getJCRPath(path);
        }
    }

    private class IdentifierResolverImpl
    implements IdentifierResolver {
        private final SessionInfo sessionInfo;

        private IdentifierResolverImpl(SessionInfo sessionInfo) {
            this.sessionInfo = sessionInfo;
        }

        private Path buildPath(String uniqueID) throws RepositoryException {
            String uri = RepositoryServiceImpl.this.uriResolver.getItemUri(RepositoryServiceImpl.this.getIdFactory().createNodeId(uniqueID), this.sessionInfo.getWorkspaceName(), this.sessionInfo);
            return RepositoryServiceImpl.this.uriResolver.getQPath(uri, this.sessionInfo);
        }

        private Path resolvePath(String jcrPath) throws RepositoryException {
            return ((SessionInfoImpl)this.sessionInfo).getNamePathResolver().getQPath(jcrPath);
        }

        public Path getPath(String identifier) throws MalformedPathException {
            try {
                int pos = identifier.indexOf(47);
                if (pos == -1) {
                    return this.buildPath(identifier);
                }
                if (pos == 0) {
                    return this.resolvePath(identifier);
                }
                Path p1 = this.buildPath(identifier.substring(0, pos));
                Path p2 = this.resolvePath(identifier.substring(pos));
                return RepositoryServiceImpl.this.getPathFactory().create(p1, p2, true);
            }
            catch (RepositoryException e) {
                throw new MalformedPathException(identifier);
            }
        }

        public void checkFormat(String identifier) throws MalformedPathException {
        }
    }

    private class NamespaceResolverImpl
    implements NamespaceResolver {
        private final SessionInfo sessionInfo;

        private NamespaceResolverImpl(SessionInfo sessionInfo) {
            this.sessionInfo = sessionInfo;
        }

        public String getURI(String prefix) throws NamespaceException {
            try {
                return RepositoryServiceImpl.this.getNamespaceURI(this.sessionInfo, prefix);
            }
            catch (RepositoryException e) {
                String msg = "Error retrieving namespace uri";
                throw new NamespaceException(msg, e);
            }
        }

        public String getPrefix(String uri) throws NamespaceException {
            try {
                return RepositoryServiceImpl.this.getNamespacePrefix(this.sessionInfo, uri);
            }
            catch (RepositoryException e) {
                String msg = "Error retrieving namespace prefix";
                throw new NamespaceException(msg, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BatchImpl
    implements Batch {
        private final SessionInfo sessionInfo;
        private final ItemId targetId;
        private final List<DavMethod> methods = new ArrayList<DavMethod>();
        private final NamePathResolver resolver;
        private String batchId;
        private boolean isConsumed = false;
        private boolean clear = false;

        private BatchImpl(ItemId targetId, SessionInfo sessionInfo) throws RepositoryException {
            this.targetId = targetId;
            this.sessionInfo = sessionInfo;
            this.resolver = RepositoryServiceImpl.this.getNamePathResolver(sessionInfo);
        }

        private HttpClient start() throws RepositoryException {
            this.checkConsumed();
            String uri = RepositoryServiceImpl.this.getItemUri(this.targetId, this.sessionInfo);
            try {
                LockMethod method = new LockMethod(uri, TransactionConstants.LOCAL, TransactionConstants.TRANSACTION, null, Integer.MAX_VALUE, true);
                RepositoryServiceImpl.initMethod((HttpMethod)method, this.sessionInfo, true);
                HttpClient client = RepositoryServiceImpl.this.getClient(this.sessionInfo);
                client.executeMethod(method);
                if (method.getStatusCode() == 412) {
                    throw new InvalidItemStateException("Unable to persist transient changes.");
                }
                method.checkSuccess();
                this.batchId = method.getLockToken();
                return client;
            }
            catch (IOException e) {
                throw new RepositoryException(e);
            }
            catch (DavException e) {
                throw ExceptionConverter.generate(e);
            }
        }

        private void end(HttpClient client, boolean commit) throws RepositoryException {
            this.checkConsumed();
            String uri = RepositoryServiceImpl.this.getItemUri(this.targetId, this.sessionInfo);
            HttpMethodBase method = null;
            try {
                method = new UnLockMethod(uri, this.batchId);
                RepositoryServiceImpl.initMethod(method, this.sessionInfo, true);
                ((DavMethodBase)method).setRequestBody(new TransactionInfo(commit));
                client.executeMethod(method);
                ((DavMethodBase)method).checkSuccess();
                if (this.sessionInfo instanceof SessionInfoImpl) {
                    ((SessionInfoImpl)this.sessionInfo).setLastBatchId(this.batchId);
                }
                if (this.clear) {
                    RepositoryServiceImpl.this.clearItemUriCache(this.sessionInfo);
                }
            }
            catch (IOException e) {
                throw new RepositoryException(e);
            }
            catch (DavException e) {
                throw ExceptionConverter.generate(e);
            }
            finally {
                if (method != null) {
                    method.releaseConnection();
                }
            }
        }

        private void dispose() {
            this.methods.clear();
            this.isConsumed = true;
        }

        private void checkConsumed() {
            if (this.isConsumed) {
                throw new IllegalStateException("Batch has already been consumed.");
            }
        }

        private boolean isEmpty() {
            return this.methods.isEmpty();
        }

        private Iterator<DavMethod> methods() {
            return this.methods.iterator();
        }

        @Override
        public void addNode(NodeId parentId, Name nodeName, Name nodetypeName, String uuid) throws RepositoryException {
            this.checkConsumed();
            try {
                Name fakeName = RepositoryServiceImpl.this.getNameFactory().create("", UUID.randomUUID().toString());
                String uri = RepositoryServiceImpl.this.getItemUri(parentId, fakeName, this.sessionInfo);
                MkColMethod method = new MkColMethod(uri);
                Document body = DomUtil.BUILDER_FACTORY.newDocumentBuilder().newDocument();
                Element nodeElement = DomUtil.addChildElement(body, RepositoryServiceImpl.NODE_ELEMENT, SV_NAMESPACE);
                String nameAttr = this.resolver.getJCRName(nodeName);
                DomUtil.setAttribute(nodeElement, RepositoryServiceImpl.NAME_ATTRIBUTE, SV_NAMESPACE, nameAttr);
                Element propElement = DomUtil.addChildElement(nodeElement, RepositoryServiceImpl.PROPERTY_ELEMENT, SV_NAMESPACE);
                String name = this.resolver.getJCRName(NameConstants.JCR_PRIMARYTYPE);
                DomUtil.setAttribute(propElement, RepositoryServiceImpl.NAME_ATTRIBUTE, SV_NAMESPACE, name);
                DomUtil.setAttribute(propElement, RepositoryServiceImpl.TYPE_ATTRIBUTE, SV_NAMESPACE, PropertyType.nameFromValue(7));
                name = this.resolver.getJCRName(nodetypeName);
                DomUtil.addChildElement(propElement, RepositoryServiceImpl.VALUE_ELEMENT, SV_NAMESPACE, name);
                if (uuid != null) {
                    propElement = DomUtil.addChildElement(nodeElement, RepositoryServiceImpl.PROPERTY_ELEMENT, SV_NAMESPACE);
                    name = this.resolver.getJCRName(NameConstants.JCR_UUID);
                    DomUtil.setAttribute(propElement, RepositoryServiceImpl.NAME_ATTRIBUTE, SV_NAMESPACE, name);
                    DomUtil.setAttribute(propElement, RepositoryServiceImpl.TYPE_ATTRIBUTE, SV_NAMESPACE, PropertyType.nameFromValue(1));
                    DomUtil.addChildElement(propElement, RepositoryServiceImpl.VALUE_ELEMENT, SV_NAMESPACE, uuid);
                }
                method.setRequestBody(body);
                this.methods.add(method);
            }
            catch (IOException e) {
                throw new RepositoryException(e);
            }
            catch (ParserConfigurationException e) {
                throw new RepositoryException(e);
            }
        }

        @Override
        public void addProperty(NodeId parentId, Name propertyName, QValue value) throws RepositoryException {
            this.checkConsumed();
            String uri = RepositoryServiceImpl.this.getItemUri(parentId, propertyName, this.sessionInfo);
            PutMethod method = new PutMethod(uri);
            method.setRequestHeader("Content-Type", JcrValueType.contentTypeFromType(value.getType()));
            method.setRequestEntity(this.getEntity(value));
            this.methods.add(method);
        }

        @Override
        public void addProperty(NodeId parentId, Name propertyName, QValue[] values) throws RepositoryException {
            this.checkConsumed();
            try {
                String uri = RepositoryServiceImpl.this.getItemUri(parentId, propertyName, this.sessionInfo);
                Value[] jcrValues = new Value[values.length];
                for (int i = 0; i < values.length; ++i) {
                    jcrValues[i] = ValueFormat.getJCRValue(values[i], this.resolver, RepositoryServiceImpl.this.valueFactory);
                }
                ValuesProperty vp = new ValuesProperty(jcrValues);
                PutMethod method = new PutMethod(uri);
                method.setRequestBody(vp);
                this.methods.add(method);
            }
            catch (IOException e) {
                throw new RepositoryException(e);
            }
        }

        @Override
        public void setValue(PropertyId propertyId, QValue value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
            this.checkConsumed();
            if (value == null) {
                this.remove(propertyId);
            } else {
                RequestEntity ent = this.getEntity(value);
                String uri = RepositoryServiceImpl.this.getItemUri(propertyId, this.sessionInfo);
                PutMethod method = new PutMethod(uri);
                method.setRequestHeader("Content-Type", JcrValueType.contentTypeFromType(value.getType()));
                method.setRequestEntity(ent);
                this.methods.add(method);
            }
        }

        @Override
        public void setValue(PropertyId propertyId, QValue[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
            this.checkConsumed();
            if (values == null) {
                this.remove(propertyId);
            } else {
                DavPropertySet setProperties = new DavPropertySet();
                Value[] jcrValues = new Value[values.length];
                for (int i = 0; i < values.length; ++i) {
                    jcrValues[i] = ValueFormat.getJCRValue(values[i], this.resolver, RepositoryServiceImpl.this.valueFactory);
                }
                setProperties.add(new ValuesProperty(jcrValues));
                try {
                    String uri = RepositoryServiceImpl.this.getItemUri(propertyId, this.sessionInfo);
                    PropPatchMethod method = new PropPatchMethod(uri, setProperties, new DavPropertyNameSet());
                    this.methods.add(method);
                }
                catch (IOException e) {
                    throw new RepositoryException(e);
                }
            }
        }

        private RequestEntity getEntity(QValue value) throws RepositoryException {
            RequestEntity ent;
            int type = value.getType();
            String contentType = JcrValueType.contentTypeFromType(type);
            try {
                switch (type) {
                    case 7: 
                    case 8: {
                        String str = ValueFormat.getJCRString(value, this.resolver);
                        ent = new StringRequestEntity(str, contentType, "UTF-8");
                        break;
                    }
                    case 2: {
                        InputStream in = value.getStream();
                        ent = new InputStreamRequestEntity(in, contentType);
                        break;
                    }
                    default: {
                        String str = value.getString();
                        ent = new StringRequestEntity(str, contentType, "UTF-8");
                        break;
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RepositoryException(e.getMessage());
            }
            return ent;
        }

        @Override
        public void remove(ItemId itemId) throws RepositoryException {
            this.checkConsumed();
            String uri = RepositoryServiceImpl.this.getItemUri(itemId, this.sessionInfo);
            DeleteMethod method = new DeleteMethod(uri);
            this.methods.add(method);
            if (itemId.getPath() == null) {
                this.clear = true;
            }
        }

        @Override
        public void reorderNodes(NodeId parentId, NodeId srcNodeId, NodeId beforeNodeId) throws RepositoryException {
            this.checkConsumed();
            try {
                OrderPatchMethod method;
                String uri = RepositoryServiceImpl.this.getItemUri(parentId, this.sessionInfo);
                String srcUri = RepositoryServiceImpl.this.getItemUri(srcNodeId, this.sessionInfo);
                String srcSegment = Text.getName(srcUri, true);
                if (beforeNodeId == null) {
                    method = new OrderPatchMethod(uri, "DAV:custom", srcSegment, false);
                } else {
                    String beforeUri = RepositoryServiceImpl.this.getItemUri(beforeNodeId, this.sessionInfo);
                    String targetSegment = Text.getName(beforeUri, true);
                    method = new OrderPatchMethod(uri, "DAV:custom", srcSegment, targetSegment, true);
                }
                this.methods.add(method);
            }
            catch (IOException e) {
                throw new RepositoryException(e);
            }
        }

        @Override
        public void setMixins(NodeId nodeId, Name[] mixinNodeTypeIds) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
            this.checkConsumed();
            try {
                DavPropertyNameSet removeProperties;
                DavPropertySet setProperties;
                if (mixinNodeTypeIds == null || mixinNodeTypeIds.length == 0) {
                    setProperties = new DavPropertySet();
                    removeProperties = new DavPropertyNameSet();
                    removeProperties.add(ItemResourceConstants.JCR_MIXINNODETYPES);
                } else {
                    String[] ntNames = new String[mixinNodeTypeIds.length];
                    for (int i = 0; i < mixinNodeTypeIds.length; ++i) {
                        ntNames[i] = this.resolver.getJCRName(mixinNodeTypeIds[i]);
                    }
                    setProperties = new DavPropertySet();
                    setProperties.add(new NodeTypeProperty(ItemResourceConstants.JCR_MIXINNODETYPES, ntNames, false));
                    removeProperties = new DavPropertyNameSet();
                }
                String uri = RepositoryServiceImpl.this.getItemUri(nodeId, this.sessionInfo);
                PropPatchMethod method = new PropPatchMethod(uri, setProperties, removeProperties);
                this.methods.add(method);
            }
            catch (IOException e) {
                throw new RepositoryException(e);
            }
        }

        @Override
        public void setPrimaryType(NodeId nodeId, Name primaryNodeTypeName) throws RepositoryException {
            this.checkConsumed();
            try {
                DavPropertySet setProperties = new DavPropertySet();
                setProperties.add(new NodeTypeProperty(ItemResourceConstants.JCR_PRIMARYNODETYPE, new String[]{this.resolver.getJCRName(primaryNodeTypeName)}, false));
                String uri = RepositoryServiceImpl.this.getItemUri(nodeId, this.sessionInfo);
                PropPatchMethod method = new PropPatchMethod(uri, setProperties, new DavPropertyNameSet());
                this.methods.add(method);
            }
            catch (IOException e) {
                throw new RepositoryException(e);
            }
        }

        @Override
        public void move(NodeId srcNodeId, NodeId destParentNodeId, Name destName) throws RepositoryException {
            this.checkConsumed();
            String uri = RepositoryServiceImpl.this.getItemUri(srcNodeId, this.sessionInfo);
            String destUri = RepositoryServiceImpl.this.getItemUri(destParentNodeId, destName, this.sessionInfo);
            MoveMethod method = new MoveMethod(uri, destUri, false);
            this.methods.add(method);
            this.clear = true;
        }
    }
}

