/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2davex;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.jackrabbit.spi2davex.BinaryPartSource;

class BinaryPart
extends FilePart {
    public BinaryPart(String name, PartSource partSource, String contentType, String charset) {
        super(name, partSource, contentType, charset);
    }

    protected void sendDispositionHeader(OutputStream out) throws IOException {
        out.write(CONTENT_DISPOSITION_BYTES);
        out.write(QUOTE_BYTES);
        out.write(EncodingUtil.getBytes(this.getName(), this.getCharSet()));
        out.write(QUOTE_BYTES);
        String filename = this.getSource().getFileName();
        if (filename != null) {
            out.write(EncodingUtil.getAsciiBytes("; filename="));
            out.write(QUOTE_BYTES);
            out.write(EncodingUtil.getBytes(this.getName(), this.getCharSet()));
            out.write(QUOTE_BYTES);
        }
    }

    public void dispose() {
        PartSource src = this.getSource();
        if (src instanceof BinaryPartSource) {
            ((BinaryPartSource)src).dispose();
        }
    }
}

