/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2davex;

import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.spi.RepositoryService;
import org.apache.jackrabbit.spi.RepositoryServiceFactory;
import org.apache.jackrabbit.spi2davex.BatchReadConfig;
import org.apache.jackrabbit.spi2davex.RepositoryServiceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Spi2davexRepositoryServiceFactory
implements RepositoryServiceFactory {
    public static final String PARAM_REPOSITORY_URI = "org.apache.jackrabbit.spi2davex.uri";
    public static String DEFAULT_REPOSITORY_URI = "http://localhost:8080/jackrabbit/server";
    public static final String PARAM_BATCHREAD_CONFIG = "org.apache.jackrabbit.spi2davex.BatchReadConfig";
    public static final String PARAM_ITEMINFO_CACHE_SIZE = "org.apache.jackrabbit.spi2davex.ItemInfoCacheSize";

    @Override
    public RepositoryService createRepositoryService(Map<?, ?> parameters) throws RepositoryException {
        Object param;
        String uri;
        if (parameters == null) {
            uri = System.getProperty(PARAM_REPOSITORY_URI);
        } else {
            String string = uri = parameters.get(PARAM_REPOSITORY_URI) == null ? null : parameters.get(PARAM_REPOSITORY_URI).toString();
        }
        if (uri == null) {
            uri = DEFAULT_REPOSITORY_URI;
        }
        BatchReadConfig brc = null;
        if (parameters != null && (param = parameters.get(PARAM_BATCHREAD_CONFIG)) != null && param instanceof BatchReadConfig) {
            brc = (BatchReadConfig)param;
        }
        int itemInfoCacheSize = 5000;
        Object param2 = parameters.get(PARAM_ITEMINFO_CACHE_SIZE);
        if (param2 != null) {
            try {
                itemInfoCacheSize = Integer.parseInt(param2.toString());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return new RepositoryServiceImpl(uri, null, brc, itemInfoCacheSize);
    }
}

