/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.jackrabbit.standalone.cli.CommandHelper;

public class CommandException
extends Exception {
    private static ResourceBundle bundle = CommandHelper.getBundle();
    private Object[] arguments;
    private static final long serialVersionUID = 3978426922931860275L;

    public CommandException(String message) {
        super(message);
    }

    public CommandException(String message, Object[] arguments) {
        super(message);
        this.arguments = arguments;
    }

    public CommandException(String message, Throwable cause) {
        super(message, cause);
    }

    public CommandException(String message, Throwable cause, Object[] arguments) {
        super(message, cause);
        this.arguments = arguments;
    }

    public String getLocalizedMessage() {
        try {
            if (this.arguments == null) {
                return bundle.getString(this.getMessage());
            }
            MessageFormat f = new MessageFormat("");
            f.applyPattern(bundle.getString(this.getMessage()));
            return f.format(this.arguments);
        }
        catch (MissingResourceException e) {
            return this.getMessage();
        }
    }
}

