/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import jline.ArgumentCompletor;
import jline.Completor;
import jline.ConsoleReader;
import jline.History;
import jline.SimpleCompletor;
import org.apache.commons.chain.Context;
import org.apache.commons.chain.impl.ContextBase;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.standalone.cli.CommandException;
import org.apache.jackrabbit.standalone.cli.CommandHelper;
import org.apache.jackrabbit.standalone.cli.CommandLine;
import org.apache.jackrabbit.standalone.cli.CommandLineFactory;
import org.apache.jackrabbit.standalone.cli.JcrParser;
import org.apache.jackrabbit.standalone.cli.JcrParserException;
import org.apache.jackrabbit.util.ChildrenCollectorFilter;

public class JcrClient {
    private static Log log = LogFactory.getLog(JcrClient.class);
    private ResourceBundle bundle = CommandHelper.getBundle();
    private boolean exit = false;
    private Context ctx;
    private Options options;

    JcrClient() {
        this.ctx = new ContextBase();
        this.initOptions();
        this.initContext();
    }

    public JcrClient(Context ctx) {
        this.ctx = ctx;
    }

    public static void main(String[] args) {
        JcrClient client = new JcrClient();
        client.run(args);
    }

    private void run(String[] args) {
        try {
            BasicParser parser = new BasicParser();
            org.apache.commons.cli.CommandLine cl = parser.parse(this.options, args);
            this.setLocale(cl);
            System.out.println(this.bundle.getString("word.welcome"));
            if (cl.hasOption("source")) {
                this.runNonInteractive(cl);
            } else {
                this.runInteractive();
            }
        }
        catch (Exception e) {
            HelpFormatter hf = new HelpFormatter();
            hf.printHelp("jcrclient", this.options);
            e.printStackTrace();
            return;
        }
    }

    public void runInteractive() throws Exception {
        ConsoleReader reader = new ConsoleReader();
        reader.setHistory(new History());
        reader.setUseHistory(true);
        Collection commands = CommandLineFactory.getInstance().getCommandLines();
        ArrayList<String> commandNames = new ArrayList<String>();
        for (CommandLine c : commands) {
            commandNames.add(c.getName());
            for (Object alias : c.getAlias()) {
                commandNames.add((String)alias);
            }
        }
        commandNames.add("exit");
        commandNames.add("quit");
        reader.addCompletor(new ArgumentCompletor(new Completor[]{new SimpleCompletor(commandNames.toArray(new String[0])), new JcrChildrenCompletor()}));
        while (!this.exit) {
            try {
                String input = reader.readLine("[" + this.getPrompt() + "] > ");
                log.debug("running: " + input);
                if (input.trim().equals("exit") || input.trim().equals("quit")) {
                    this.exit = true;
                    System.out.println("Good bye...");
                    continue;
                }
                if (input.trim().length() == 0) continue;
                this.runCommand(input);
            }
            catch (JcrParserException e) {
                System.out.println(e.getLocalizedMessage());
                System.out.println();
            }
            catch (Exception e) {
                this.handleException(reader, e);
            }
        }
    }

    private void runNonInteractive(org.apache.commons.cli.CommandLine cl) throws Exception {
        this.runCommand("source " + cl.getOptionValue("source"));
    }

    void runCommand(String input) throws Exception {
        if (input.startsWith("#") || input.length() == 0) {
            return;
        }
        JcrParser parser = new JcrParser();
        parser.parse(input);
        parser.populateContext(this.ctx);
        long start = System.currentTimeMillis();
        parser.getCommand().execute(this.ctx);
        long elapsed = System.currentTimeMillis() - start;
        parser.depopulateContext(this.ctx);
        System.out.println();
        System.out.println(this.bundle.getString("phrase.elapsedtime") + ": " + elapsed + " ms.");
        System.out.println();
    }

    private void handleException(ConsoleReader cr, Exception ex) {
        System.out.println();
        System.out.println(this.bundle.getString("exception.occurred"));
        System.out.println();
        System.out.println(this.bundle.getString("exception") + ": " + ex.getClass().getName());
        System.out.println(this.bundle.getString("word.message") + ": " + ex.getLocalizedMessage());
        System.out.println();
        String prompt = this.bundle.getString("phrase.display.stacktrace") + "? [y/n]";
        String str = "";
        int tries = 0;
        while (!str.equals("y") && !str.equals("n") && tries < 3) {
            ++tries;
            try {
                str = cr.readLine(prompt);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (str.equals("y")) {
            ex.printStackTrace();
        }
    }

    private String getPrompt() throws RepositoryException {
        try {
            CommandHelper.getRepository(this.ctx);
        }
        catch (CommandException e) {
            return this.bundle.getString("phrase.not.connected");
        }
        boolean unsaved = false;
        try {
            unsaved = CommandHelper.getSession(this.ctx).hasPendingChanges();
        }
        catch (CommandException e) {
            return this.bundle.getString("phrase.not.logged.in");
        }
        try {
            String path;
            Node n = CommandHelper.getCurrentNode(this.ctx);
            try {
                path = n.getPath();
            }
            catch (InvalidItemStateException e) {
                CommandHelper.setCurrentNode(this.ctx, CommandHelper.getSession(this.ctx).getRootNode());
                path = CommandHelper.getCurrentNode(this.ctx).getPath();
            }
            if (unsaved) {
                return path + "*";
            }
            return path;
        }
        catch (CommandException e) {
            return this.bundle.getString("phrase.not.logged.in");
        }
    }

    private void initOptions() {
        this.options = new Options();
        this.options.addOption("lang", "code", true, "Language code");
        this.options.addOption("country", "code", true, "Country code");
        this.options.addOption("source", "path", true, "Script for noninteractive mode");
    }

    private void setLocale(org.apache.commons.cli.CommandLine cl) throws ParseException {
        Locale locale = null;
        if (cl.hasOption("lang") && cl.hasOption("country")) {
            locale = new Locale(cl.getOptionValue("lang"), cl.getOptionValue("country"));
        }
        if (cl.hasOption("lang") && !cl.hasOption("country")) {
            locale = new Locale(cl.getOptionValue("lang"));
        }
        if (locale != null) {
            Locale.setDefault(locale);
        }
    }

    private void initContext() {
        CommandHelper.setOutput(this.ctx, new PrintWriter(System.out, true));
    }

    private class JcrChildrenCompletor
    implements Completor {
        private JcrChildrenCompletor() {
        }

        public int complete(String buffer, int cursor, List clist) {
            String start = buffer == null ? "" : buffer;
            try {
                Node node = CommandHelper.getNode(JcrClient.this.ctx, ".");
                ArrayList<Item> items = new ArrayList<Item>();
                ChildrenCollectorFilter collector = new ChildrenCollectorFilter("*", items, true, true, 1);
                collector.visit(node);
                for (Object e : items) {
                    String can = ((Item)e).getName();
                    if (!can.startsWith(start)) continue;
                    clist.add(can);
                }
                return 0;
            }
            catch (CommandException e) {
                e.printStackTrace();
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
            return -1;
        }
    }
}

