/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ResourceBundle;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.jackrabbit.standalone.cli.CommandException;
import org.apache.jackrabbit.standalone.cli.CommandHelper;
import org.apache.jackrabbit.standalone.cli.JcrClient;

public class SourceCommand
implements Command {
    private ResourceBundle bundle = CommandHelper.getBundle();
    private String fileKey = "file";

    public String getFileKey() {
        return this.fileKey;
    }

    public void setFileKey(String file) {
        this.fileKey = file;
    }

    public boolean execute(Context ctx) throws Exception {
        File f = new File((String)ctx.get(this.fileKey));
        if (!f.exists()) {
            throw new CommandException("exception.file.not.found", new String[]{f.getAbsolutePath()});
        }
        JcrClient client = new JcrClient(ctx);
        BufferedReader in = new BufferedReader(new FileReader(f));
        PrintWriter out = CommandHelper.getOutput(ctx);
        String line = null;
        while ((line = in.readLine()) != null) {
            out.println(this.bundle.getString("word.running") + ": " + line);
            client.runCommand(line);
        }
        in.close();
        return false;
    }
}

