/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.collect;

import java.util.ArrayList;
import javax.jcr.Item;
import javax.jcr.Node;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.standalone.cli.CommandHelper;
import org.apache.jackrabbit.util.ChildrenCollectorFilter;

public abstract class AbstractCollect
implements Command {
    private static Log log = LogFactory.getLog(AbstractCollect.class);
    private String srcPathKey = "srcPath";
    private String depthKey = "depth";
    private String namePatternKey = "namePattern";
    private String destKey = "collected";

    public final boolean execute(Context ctx) throws Exception {
        String namePattern;
        if (this.destKey == null || this.destKey.length() == 0) {
            throw new IllegalStateException("target variable is not set");
        }
        String relPath = (String)ctx.get(this.srcPathKey);
        if (relPath == null) {
            relPath = ".";
        }
        if ((namePattern = (String)ctx.get(this.namePatternKey)) == null || namePattern.length() == 0) {
            namePattern = "*";
        }
        int depth = Integer.parseInt((String)ctx.get(this.depthKey));
        Node node = CommandHelper.getNode(ctx, relPath);
        if (log.isDebugEnabled()) {
            log.debug("collecting nodes from " + node.getPath() + " depth=" + depth + " pattern=" + namePattern + " into target variable " + this.destKey);
        }
        ArrayList<Item> items = new ArrayList<Item>();
        ChildrenCollectorFilter collector = new ChildrenCollectorFilter(namePattern, items, this.isCollectNodes(), this.isCollectProperties(), depth);
        collector.visit(node);
        ctx.put(this.destKey, items.iterator());
        return false;
    }

    public String getDepthKey() {
        return this.depthKey;
    }

    public void setDepthKey(String depthKey) {
        this.depthKey = depthKey;
    }

    public String getNamePatternKey() {
        return this.namePatternKey;
    }

    public void setNamePatternKey(String namePatternKey) {
        this.namePatternKey = namePatternKey;
    }

    protected abstract boolean isCollectNodes();

    protected abstract boolean isCollectProperties();

    public String getDestKey() {
        return this.destKey;
    }

    public void setDestKey(String destKey) {
        this.destKey = destKey;
    }

    public String getSrcPathKey() {
        return this.srcPathKey;
    }

    public void setSrcPathKey(String srcPathKey) {
        this.srcPathKey = srcPathKey;
    }
}

