/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.core;

import javax.jcr.Node;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.standalone.cli.CommandHelper;

public class AddNode
implements Command {
    private static Log log = LogFactory.getLog(AddNode.class);
    private String typeKey = "type";
    private String relPathKey = "relPath";

    public boolean execute(Context ctx) throws Exception {
        Node node = CommandHelper.getCurrentNode(ctx);
        String nodeType = (String)ctx.get(this.typeKey);
        String name = (String)ctx.get(this.relPathKey);
        if (log.isDebugEnabled()) {
            log.debug("adding node at " + node.getPath() + "/" + name);
        }
        if (name.startsWith("/")) {
            node = CommandHelper.getSession(ctx).getRootNode();
            name = name.substring(1);
        }
        if (nodeType == null) {
            node.addNode(name);
        } else {
            node.addNode(name, nodeType);
        }
        return false;
    }

    public String getTypeKey() {
        return this.typeKey;
    }

    public void setTypeKey(String nodeTypeKey) {
        this.typeKey = nodeTypeKey;
    }

    public String getRelPathKey() {
        return this.relPathKey;
    }

    public void setRelPathKey(String relPathKey) {
        this.relPathKey = relPathKey;
    }
}

