/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.core;

import javax.jcr.Node;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.standalone.cli.CommandHelper;

public class OrderBefore
implements Command {
    private static Log log = LogFactory.getLog(OrderBefore.class);
    private String parentPathKey = "parentPath";
    private String srcChildKey = "srcChild";
    private String destChildKey = "destChild";

    public boolean execute(Context ctx) throws Exception {
        String parentPath = (String)ctx.get(this.parentPathKey);
        Node n = CommandHelper.getNode(ctx, parentPath);
        String srcChildPath = (String)ctx.get(this.srcChildKey);
        String destChildPath = (String)ctx.get(this.destChildKey);
        if (log.isDebugEnabled()) {
            log.debug("ordering before. from " + n.getPath() + "/" + srcChildPath + " to " + n.getPath() + "/" + destChildPath);
        }
        n.orderBefore(srcChildPath, destChildPath);
        return false;
    }

    public String getDestChildKey() {
        return this.destChildKey;
    }

    public void setDestChildKey(String destChildRelPathKey) {
        this.destChildKey = destChildRelPathKey;
    }

    public String getSrcChildKey() {
        return this.srcChildKey;
    }

    public void setSrcChildKey(String srcChildRelPathKey) {
        this.srcChildKey = srcChildRelPathKey;
    }

    public String getParentPathKey() {
        return this.parentPathKey;
    }

    public void setParentPathKey(String parentPathKey) {
        this.parentPathKey = parentPathKey;
    }
}

