/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.core;

import javax.jcr.Property;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.standalone.cli.CommandHelper;

public class ReadValue
implements Command {
    private static Log log = LogFactory.getLog(ReadValue.class);
    private String srcPathKey = "srcPath";
    private String srcIndexKey = "srcIndex";
    private String destKey = "dest";

    public boolean execute(Context ctx) throws Exception {
        Property p;
        String path = (String)ctx.get(this.srcPathKey);
        int index = 1;
        if (ctx.get(this.srcIndexKey) != null) {
            index = Integer.valueOf((String)ctx.get(this.srcIndexKey));
        }
        String dest = (String)ctx.get(this.destKey);
        if (log.isDebugEnabled()) {
            log.debug("reading value from " + path + "[" + index + "] to " + dest);
        }
        if ((p = (Property)CommandHelper.getItem(ctx, path)).getDefinition().isMultiple()) {
            ctx.put(dest, p.getValues()[index].getString());
        } else {
            ctx.put(dest, p.getValue().getString());
        }
        return false;
    }

    public String getDestKey() {
        return this.destKey;
    }

    public void setDestKey(String destKey) {
        this.destKey = destKey;
    }

    public String getSrcIndexKey() {
        return this.srcIndexKey;
    }

    public void setSrcIndexKey(String srcIndexKey) {
        this.srcIndexKey = srcIndexKey;
    }

    public String getSrcPathKey() {
        return this.srcPathKey;
    }

    public void setSrcPathKey(String srcPathKey) {
        this.srcPathKey = srcPathKey;
    }
}

