/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.ext;

import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.standalone.cli.CommandHelper;

public class StartJackrabbit
implements Command {
    private static Log log = LogFactory.getLog(StartJackrabbit.class);
    private String configKey = "config";
    private String homeKey = "home";

    public boolean execute(Context ctx) throws Exception {
        String config = (String)ctx.get(this.configKey);
        String home = (String)ctx.get(this.homeKey);
        if (log.isDebugEnabled()) {
            log.debug("starting jackrabbit. config=" + config + " home=" + home);
        }
        RepositoryConfig conf = RepositoryConfig.create(config, home);
        RepositoryImpl repo = RepositoryImpl.create(conf);
        CommandHelper.setRepository(ctx, repo, "local " + home);
        return false;
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public void setConfigKey(String configKey) {
        this.configKey = configKey;
    }

    public String getHomeKey() {
        return this.homeKey;
    }

    public void setHomeKey(String homeKey) {
        this.homeKey = homeKey;
    }
}

