/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.ext;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Repository;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.standalone.cli.CommandHelper;

public class StartJackrabbitSingleton
implements Command {
    private static Log log = LogFactory.getLog(StartJackrabbitSingleton.class);
    private static Map cache = new HashMap();
    private String configKey = "config";
    private String homeKey = "home";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Context ctx) throws Exception {
        String config = (String)ctx.get(this.configKey);
        String home = (String)ctx.get(this.homeKey);
        if (log.isDebugEnabled()) {
            log.debug("starting jackrabbit. config=" + config + " home=" + home);
        }
        try {
            Map map = cache;
            synchronized (map) {
                String key = config + "@" + home;
                Repository repo = (Repository)cache.get(key);
                if (repo == null) {
                    String msg = "Starting Jakrabbit instance";
                    log.info(msg);
                    RepositoryConfig conf = RepositoryConfig.create(config, home);
                    repo = RepositoryImpl.create(conf);
                    cache.put(key, repo);
                }
                CommandHelper.setRepository(ctx, repo, "local singleton " + home);
            }
        }
        catch (Exception e) {
            log.error("Unable to start jackrabbit", e);
            throw e;
        }
        return false;
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public void setConfigKey(String configKey) {
        this.configKey = configKey;
    }

    public String getHomeKey() {
        return this.homeKey;
    }

    public void setHomeKey(String homeKey) {
        this.homeKey = homeKey;
    }
}

