/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.fs;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.standalone.cli.CommandException;
import org.apache.jackrabbit.standalone.cli.CommandHelper;

public class ExportFileSystem
implements Command {
    private static Log log = LogFactory.getLog(ExportFileSystem.class);
    private String srcJcrPathKey = "srcJcrPath";
    private String destFsPathKey = "destFsPath";
    private String overwriteKey = "overwrite";

    public boolean execute(Context ctx) throws Exception {
        String from = (String)ctx.get(this.srcJcrPathKey);
        String to = (String)ctx.get(this.destFsPathKey);
        boolean overwrite = Boolean.valueOf((String)ctx.get(this.overwriteKey));
        if (log.isDebugEnabled()) {
            log.debug("exporting node at " + from + " to the filesystem (" + to + ") overwrite=" + overwrite);
        }
        Node node = CommandHelper.getNode(ctx, from);
        File f = new File(to);
        if (f.exists() && !overwrite) {
            throw new CommandException("exception.file.exists", new String[]{to});
        }
        if (node.isNodeType("nt:file")) {
            this.createFile(node, f);
        } else if (node.isNodeType("nt:folder")) {
            this.addFolder(node, f);
        } else {
            throw new CommandException("exception.not.file.or.folder", new String[]{node.getPrimaryNodeType().getName()});
        }
        return false;
    }

    private void createFile(Node node, File file) throws IOException, CommandException, ValueFormatException, PathNotFoundException, RepositoryException {
        int c;
        boolean created = file.createNewFile();
        if (!created) {
            throw new CommandException("exception.file.not.created", new String[]{file.getPath()});
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        InputStream in = node.getNode("jcr:content").getProperty("jcr:data").getStream();
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        in.close();
        out.flush();
        out.close();
    }

    private void addFolder(Node node, File file) throws CommandException, RepositoryException, IOException {
        boolean created = file.mkdir();
        if (!created) {
            throw new CommandException("exception.folder.not.created", new String[]{file.getPath()});
        }
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            if (child.isNodeType("nt:file")) {
                File childFile = new File(file, child.getName());
                this.createFile(child, childFile);
                continue;
            }
            if (!child.isNodeType("nt:folder")) continue;
            File childFolder = new File(file, child.getName());
            this.addFolder(child, childFolder);
        }
    }

    public String getOverwriteKey() {
        return this.overwriteKey;
    }

    public void setOverwriteKey(String overwriteKey) {
        this.overwriteKey = overwriteKey;
    }

    public String getSrcJcrPathKey() {
        return this.srcJcrPathKey;
    }

    public void setSrcJcrPathKey(String srcJcrPathKey) {
        this.srcJcrPathKey = srcJcrPathKey;
    }

    public String getDestFsPathKey() {
        return this.destFsPathKey;
    }

    public void setDestFsPathKey(String toFsPathKey) {
        this.destFsPathKey = toFsPathKey;
    }
}

