/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.fs;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.standalone.cli.CommandException;
import org.apache.jackrabbit.standalone.cli.CommandHelper;

public class ExportPropertyToFile
implements Command {
    private static Log log = LogFactory.getLog(ExportPropertyToFile.class);
    private String nameKey = "name";
    private String indexKey = "index";
    private String destFsPathKey = "destFsPath";
    private String overwriteKey = "overwrite";

    public boolean execute(Context ctx) throws Exception {
        Property p;
        String name = (String)ctx.get(this.nameKey);
        Integer index = (Integer)ctx.get(this.indexKey);
        String to = (String)ctx.get(this.destFsPathKey);
        Node n = CommandHelper.getCurrentNode(ctx);
        if (log.isDebugEnabled()) {
            log.debug("exporting property value from " + n.getPath() + "/" + name + " to the filesystem: " + to);
        }
        if ((p = n.getProperty(name)).getDefinition().isMultiple()) {
            this.exportValue(ctx, p.getValues()[index], to);
        } else {
            this.exportValue(ctx, p.getValue(), to);
        }
        return false;
    }

    private void exportValue(Context ctx, Value value, String to) throws CommandException, IOException, RepositoryException {
        boolean overwrite = Boolean.valueOf((String)ctx.get(this.overwriteKey));
        File file = new File(to);
        if (file.exists() && !overwrite) {
            throw new CommandException("exception.file.exists", new String[]{to});
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        if (value.getType() == 2) {
            int c;
            InputStream in = value.getStream();
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            in.close();
            out.flush();
            out.close();
        } else {
            int c;
            StringReader in = new StringReader(value.getString());
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            while ((c = ((Reader)in).read()) != -1) {
                out.write(c);
            }
            ((Reader)in).close();
            out.flush();
            out.close();
        }
    }

    public String getIndexKey() {
        return this.indexKey;
    }

    public void setIndexKey(String indexKey) {
        this.indexKey = indexKey;
    }

    public String getNameKey() {
        return this.nameKey;
    }

    public void setNameKey(String nameKey) {
        this.nameKey = nameKey;
    }

    public String getOverwriteKey() {
        return this.overwriteKey;
    }

    public void setOverwriteKey(String overwriteKey) {
        this.overwriteKey = overwriteKey;
    }

    public String getDestFsPathKey() {
        return this.destFsPathKey;
    }

    public void setDestFsPathKey(String destFsPathKey) {
        this.destFsPathKey = destFsPathKey;
    }
}

