/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.info;

import java.util.Iterator;
import java.util.ResourceBundle;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import org.apache.commons.chain.Context;
import org.apache.jackrabbit.standalone.cli.CommandException;
import org.apache.jackrabbit.standalone.cli.CommandHelper;
import org.apache.jackrabbit.standalone.cli.info.AbstractLs;
import org.apache.jackrabbit.standalone.cli.info.PrintHelper;

public abstract class AbstractLsItems
extends AbstractLs {
    private static ResourceBundle bundle = CommandHelper.getBundle();
    private int nameWidth = 30;
    private int typeWidth = 15;

    protected abstract Iterator getItems(Context var1) throws CommandException, RepositoryException;

    public final boolean execute(Context ctx) throws Exception {
        int nodes = 0;
        int properties = 0;
        int[] width = new int[]{this.nameWidth, this.typeWidth, this.longWidth, this.longWidth, this.longWidth};
        String[] header = new String[]{bundle.getString("word.name"), bundle.getString("word.type"), bundle.getString("word.node"), bundle.getString("word.new"), bundle.getString("word.modified")};
        PrintHelper.printRow(ctx, width, header);
        PrintHelper.printSeparatorRow(ctx, width, '-');
        Iterator iter = this.getItems(ctx);
        int maxItems = this.getMaxItems(ctx);
        for (int index = 0; iter.hasNext() && index < maxItems; ++index) {
            Item i = (Item)iter.next();
            String type = null;
            String name = null;
            name = this.isPath() ? i.getPath() : i.getName();
            if (i.isNode()) {
                ++nodes;
                Node n = (Node)i;
                if (!this.isPath() && n.getIndex() > 1) {
                    name = n.getName() + "[" + n.getIndex() + "]";
                }
                type = n.getPrimaryNodeType().getName();
            } else {
                ++properties;
                type = PropertyType.nameFromValue(((Property)i).getType());
            }
            PrintHelper.printRow(ctx, width, new String[]{name, type, Boolean.toString(i.isNode()), Boolean.valueOf(i.isNew()).toString(), Boolean.valueOf(i.isModified()).toString()});
        }
        this.printFooter(ctx, iter);
        return false;
    }
}

